/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg.context.impl;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.validation.ValidationException;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.cfg.context.impl.ConstraintMappingContext;
import org.hibernate.validator.cfg.context.impl.MethodConstraintMappingContextImpl;
import org.hibernate.validator.cfg.context.impl.PropertyConstraintMappingContextImpl;
import org.hibernate.validator.cfg.context.impl.TypeConstraintMappingContextImpl;
import org.hibernate.validator.util.Contracts;
import org.hibernate.validator.util.ReflectionHelper;

public abstract class ConstraintMappingContextImplBase {
    protected final Class<?> beanClass;
    protected final ConstraintMappingContext mapping;

    public ConstraintMappingContextImplBase(Class<?> beanClass, ConstraintMappingContext mapping) {
        this.beanClass = beanClass;
        this.mapping = mapping;
    }

    public <C> TypeConstraintMappingContext<C> type(Class<C> type) {
        Contracts.assertNotNull(this.beanClass, "The bean type must not be null when creating a constraint mapping.");
        return new TypeConstraintMappingContextImpl(type, this.mapping);
    }

    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        Contracts.assertNotNull(property, "The property name must not be null.");
        Contracts.assertNotNull((Object)elementType, "The element type must not be null.");
        if (property.length() == 0) {
            throw new IllegalArgumentException("The property name must not be empty.");
        }
        Member member = ReflectionHelper.getMember(this.beanClass, property, elementType);
        if (member == null) {
            throw new ValidationException("The class " + this.beanClass + " does not have a property '" + property + "' with access " + (Object)((Object)elementType));
        }
        return new PropertyConstraintMappingContextImpl(this.beanClass, member, this.mapping);
    }

    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(name, "The method name must not be null.");
        Method method = ReflectionHelper.getDeclaredMethod(this.beanClass, name, parameterTypes);
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> oneParameterType : parameterTypes) {
                sb.append(oneParameterType.getName() + ", ");
            }
            String parameterTypesAsString = sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
            throw new IllegalArgumentException(String.format("Type %s doesn't have a method %s(%s).", this.beanClass, name, parameterTypesAsString));
        }
        return new MethodConstraintMappingContextImpl(this.beanClass, method, this.mapping);
    }
}

