/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.ConstraintValidatorContextImpl;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.MethodValidationContext;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.StandardValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.util.IdentitySet;

public abstract class ValidationContext<T, C extends ConstraintViolation<T>> {
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final Map<Object, Set<PathImpl>> processedPaths;
    private final Set<C> failingConstraintViolations;
    private boolean allowOneValidationPerPath = true;
    protected final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final boolean failFast;

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidate(T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = object.getClass();
        return new StandardValidationContext(rootBeanClass, object, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateProperty(T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = rootBean.getClass();
        return new StandardValidationContext(rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> ValidationContext<T, ConstraintViolation<T>> getContextForValidateValue(Class<T> rootBeanClass, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        return new StandardValidationContext<Object>(rootBeanClass, null, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> MethodValidationContext<T> getContextForValidateParameter(Method method, int parameterIndex, T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = object.getClass();
        return new MethodValidationContext(rootBeanClass, object, method, parameterIndex, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    public static <T> MethodValidationContext<T> getContextForValidateParameters(Method method, T object, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        Class<?> rootBeanClass = object.getClass();
        return new MethodValidationContext(rootBeanClass, object, method, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    protected ValidationContext(Class<T> rootBeanClass, T rootBean, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.failFast = failFast;
        this.processedObjects = new HashMap();
        this.processedPaths = new IdentityHashMap<Object, Set<PathImpl>>();
        this.failingConstraintViolations = new HashSet<C>();
    }

    public final T getRootBean() {
        return this.rootBean;
    }

    public final Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public final TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public final boolean shouldFailFast() {
        return this.failFast && !this.failingConstraintViolations.isEmpty();
    }

    public abstract <U, V> C createConstraintViolation(ValueContext<U, V> var1, MessageAndPath var2, ConstraintDescriptor<?> var3);

    public final <U, V> List<C> createConstraintViolations(ValueContext<U, V> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        ArrayList<C> constraintViolations = new ArrayList<C>();
        for (MessageAndPath messageAndPath : constraintValidatorContext.getMessageAndPathList()) {
            C violation = this.createConstraintViolation(localContext, messageAndPath, constraintValidatorContext.getConstraintDescriptor());
            constraintViolations.add(violation);
        }
        return constraintViolations;
    }

    public final ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isAlreadyValidated(Object value, Class<?> group, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group);
        if (alreadyValidated && this.allowOneValidationPerPath) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markProcessed(Object value, Class<?> group, PathImpl path) {
        this.markProcessForCurrentGroup(value, group);
        if (this.allowOneValidationPerPath) {
            this.markProcessedForCurrentPath(value, path);
        }
    }

    public final void addConstraintFailures(Set<C> failingConstraintViolations) {
        this.failingConstraintViolations.addAll(failingConstraintViolations);
    }

    public Set<C> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPaths.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!path.isRootPath() && !p.isRootPath() && !this.isSubPathOf(path, p) && !this.isSubPathOf(p, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubPathOf(Path p1, Path p2) {
        Iterator p1Iter = p1.iterator();
        Iterator p2Iter = p2.iterator();
        while (p1Iter.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iter.next();
            if (!p2Iter.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iter.next();
            if (p1Node.equals(p2Node)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(group);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    private void markProcessedForCurrentPath(Object value, PathImpl path) {
        if (this.processedPaths.containsKey(value)) {
            this.processedPaths.get(value).add(path);
        } else {
            HashSet<PathImpl> set = new HashSet<PathImpl>();
            set.add(path);
            this.processedPaths.put(value, set);
        }
    }

    private void markProcessForCurrentGroup(Object value, Class<?> group) {
        if (this.processedObjects.containsKey(group)) {
            this.processedObjects.get(group).add(value);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(value);
            this.processedObjects.put(group, set);
        }
    }
}

