/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util;

import com.googlecode.jtype.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;

public final class ValidatorTypeHelper {
    private static final int VALIDATOR_TYPE_INDEX = 1;

    private ValidatorTypeHelper() {
    }

    public static <T extends Annotation> Map<Type, Class<? extends ConstraintValidator<?, ?>>> getValidatorsTypes(List<Class<? extends ConstraintValidator<T, ?>>> validators) {
        HashMap validatorsTypes = new HashMap();
        for (Class<ConstraintValidator<T, ?>> clazz : validators) {
            validatorsTypes.put(ValidatorTypeHelper.extractType(clazz), clazz);
        }
        return validatorsTypes;
    }

    private static Type extractType(Class<? extends ConstraintValidator<?, ?>> validator) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type constraintValidatorType = ValidatorTypeHelper.resolveTypes(resolvedTypes, validator);
        Type validatorType = ((ParameterizedType)constraintValidatorType).getActualTypeArguments()[1];
        if (validatorType == null) {
            throw new ValidationException("null is an invalid type for a constraint validator.");
        }
        if (validatorType instanceof GenericArrayType) {
            validatorType = TypeUtils.getArrayType((Type)TypeUtils.getComponentType((Type)validatorType));
        }
        while (resolvedTypes.containsKey(validatorType)) {
            validatorType = (Type)resolvedTypes.get(validatorType);
        }
        return validatorType;
    }

    private static Type resolveTypes(Map<Type, Type> resolvedTypes, Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Type returnedType = ValidatorTypeHelper.resolveTypeForClassAndHierarchy(resolvedTypes, clazz);
            if (returnedType != null) {
                return returnedType;
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (!(paramType.getRawType() instanceof Class)) {
                return null;
            }
            Class rawType = (Class)paramType.getRawType();
            TypeVariable<Class<T>>[] originalTypes = rawType.getTypeParameters();
            Type[] partiallyResolvedTypes = paramType.getActualTypeArguments();
            int nbrOfParams = originalTypes.length;
            for (int i = 0; i < nbrOfParams; ++i) {
                resolvedTypes.put(originalTypes[i], partiallyResolvedTypes[i]);
            }
            if (rawType.equals(ConstraintValidator.class)) {
                return type;
            }
            Type returnedType = ValidatorTypeHelper.resolveTypeForClassAndHierarchy(resolvedTypes, rawType);
            if (returnedType != null) {
                return returnedType;
            }
        }
        return null;
    }

    private static Type resolveTypeForClassAndHierarchy(Map<Type, Type> resolvedTypes, Class<?> clazz) {
        Type returnedType = ValidatorTypeHelper.resolveTypes(resolvedTypes, clazz.getGenericSuperclass());
        if (returnedType != null) {
            return returnedType;
        }
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            returnedType = ValidatorTypeHelper.resolveTypes(resolvedTypes, genericInterface);
            if (returnedType == null) continue;
            return returnedType;
        }
        return null;
    }
}

