/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.portlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.junit.Assert;

public class ResourcePortlet
extends GenericPortlet {
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write("<img src='" + response.encodeURL(request.getContextPath() + "/gif/logo.gif") + "'/>");
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        String resourceID = request.getResourceID();
        if (resourceID.equals("resourceFromWriter")) {
            response.setContentType("image/png");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write("foo");
            response.setContentType("text/html");
            ((Writer)writer).close();
        } else if (resourceID.equals("resourceFromStream")) {
            response.setContentType("image/png");
            OutputStream stream = response.getPortletOutputStream();
            byte[] byteArray = new byte[]{0, 1, 2, 3, 4};
            stream.write(byteArray);
            response.setContentType("text/html");
            stream.close();
        } else if (resourceID.equals("uploaded")) {
            Assert.assertTrue((boolean)request.getContentType().startsWith("multipart"));
            InputStream inputStream = request.getPortletInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            Assert.assertTrue((boolean)line.startsWith("--"));
            line = reader.readLine();
            Assert.assertEquals((Object)"Content-type: image/png", (Object)line);
            line = reader.readLine();
            Assert.assertTrue((boolean)line.isEmpty());
            String image = reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.startsWith("--"));
            Assert.assertTrue((boolean)line.endsWith("--"));
            response.setContentType("image/png");
            OutputStream outputStream = response.getPortletOutputStream();
            outputStream.write(image.getBytes());
            outputStream.close();
        } else {
            throw new PortletException("No known resource with id: " + resourceID);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String actionName = request.getParameter("javax.portlet.action");
        if (actionName.equals("uploadImage")) {
            Assert.assertTrue((boolean)request.getContentType().startsWith("multipart"));
            InputStream inputStream = request.getPortletInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            Assert.assertTrue((boolean)line.startsWith("--"));
            line = reader.readLine();
            Assert.assertEquals((Object)"Content-type: image/png", (Object)line);
            line = reader.readLine();
            Assert.assertTrue((boolean)line.isEmpty());
            String image = reader.readLine();
            line = reader.readLine();
            Assert.assertTrue((boolean)line.startsWith("--"));
            byte[] expectedBytes = new byte[]{0, 1, 2, 3, 4};
            byte[] receivedBytes = image.getBytes();
            Assert.assertEquals((long)expectedBytes.length, (long)receivedBytes.length);
            for (int i = 0; i < expectedBytes.length; ++i) {
                Assert.assertEquals((long)expectedBytes[i], (long)receivedBytes[i]);
            }
        } else {
            throw new PortletException("Unkown Action:" + actionName);
        }
    }
}

