/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedPortletApplication;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.wsrp.portlet.ApplicationScopeGetPortlet;
import org.gatein.wsrp.portlet.ApplicationScopeSetPortlet;
import org.gatein.wsrp.portlet.BasicPortlet;
import org.gatein.wsrp.portlet.DispatcherPortlet;
import org.gatein.wsrp.portlet.EncodeURLPortlet;
import org.gatein.wsrp.portlet.EventConsumerPortlet;
import org.gatein.wsrp.portlet.EventGeneratorPortlet;
import org.gatein.wsrp.portlet.GetLocalesPortlet;
import org.gatein.wsrp.portlet.ImplicitCloningPortlet;
import org.gatein.wsrp.portlet.MarkupPortlet;
import org.gatein.wsrp.portlet.MultiValuedPortlet;
import org.gatein.wsrp.portlet.RenderParamPortlet;
import org.gatein.wsrp.portlet.ResourceNoEncodeURLPortlet;
import org.gatein.wsrp.portlet.ResourcePortlet;
import org.gatein.wsrp.portlet.SessionPortlet;
import org.gatein.wsrp.portlet.UserContextPortlet;
import org.gatein.wsrp.producer.WSRPProducer;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.mockito.Mockito;

public abstract class WSRPProducerBaseTest
extends TestCase {
    protected Map<String, List<String>> war2Handles = new HashMap<String, List<String>>(7);
    protected String currentlyDeployedArchiveName;
    @ArquillianResource
    private Deployer deployer;

    protected WSRPProducerBaseTest(String name) throws Exception {
        super(name);
    }

    protected abstract WSRPProducer getProducer();

    protected abstract ProducerHelper getProducerHelper();

    protected void deployArchive(String deploymentName) {
        this.deployer.deploy(deploymentName);
    }

    protected void undeployArchive(String deploymentName) {
        this.deployer.undeploy(deploymentName);
    }

    public void deploy(String warFileName) throws Exception {
        this.deployArchive(warFileName);
        WSRPProducer producer = this.getProducer();
        Set portlets = producer.getPortletInvoker().getPortlets();
        for (Portlet portlet : portlets) {
            PortletContext context = portlet.getContext();
            if (this.war2Handles.containsKey(this.getWarName(context.getId()))) continue;
            ManagedPortletApplication portletApplication = (ManagedPortletApplication)Mockito.mock(ManagedPortletApplication.class);
            PortletContext.PortletContextComponents components = context.getComponents();
            Mockito.stub((Object)portletApplication.getId()).toReturn((Object)components.getApplicationName());
            ManagedPortletContainer portletContainer = (ManagedPortletContainer)Mockito.mock(ManagedPortletContainer.class);
            Mockito.stub((Object)portletContainer.getManagedPortletApplication()).toReturn((Object)portletApplication);
            Mockito.stub((Object)portletContainer.getId()).toReturn((Object)components.getPortletName());
            Mockito.stub((Object)portletContainer.getInfo()).toReturn((Object)portlet.getInfo());
            ManagedObjectLifeCycleEvent lifeCycleEvent = new ManagedObjectLifeCycleEvent((ManagedObject)portletContainer, LifeCycleStatus.STARTED);
            producer.onEvent((ManagedObjectRegistryEvent)lifeCycleEvent);
        }
        this.currentlyDeployedArchiveName = warFileName;
        if (!this.war2Handles.containsKey(warFileName)) {
            Collection<String> portletHandles = this.getPortletHandles();
            if (portletHandles != null) {
                for (String handle : portletHandles) {
                    String warName = this.getWarName(handle);
                    if (!warName.equals(warFileName)) continue;
                    List<String> handles = this.war2Handles.get(warName);
                    if (handles == null) {
                        handles = new ArrayList<String>(3);
                        this.war2Handles.put(warName, handles);
                    }
                    handles.add(handle);
                }
            } else {
                throw new IllegalArgumentException(warFileName + " didn't contain any portlets...");
            }
        }
    }

    public void undeploy(String warFileName) throws Exception {
        this.currentlyDeployedArchiveName = null;
        List<String> handles = this.war2Handles.get(warFileName);
        WSRPProducer producer = this.getProducer();
        if (handles != null) {
            for (String handle : handles) {
                PortletContext context = PortletContext.createPortletContext((String)handle);
                try {
                    Portlet portlet = producer.getPortletInvoker().getPortlet(context);
                    ManagedPortletApplication portletApplication = (ManagedPortletApplication)Mockito.mock(ManagedPortletApplication.class);
                    PortletContext.PortletContextComponents components = context.getComponents();
                    Mockito.stub((Object)portletApplication.getId()).toReturn((Object)components.getApplicationName());
                    ManagedPortletContainer portletContainer = (ManagedPortletContainer)Mockito.mock(ManagedPortletContainer.class);
                    Mockito.stub((Object)portletContainer.getManagedPortletApplication()).toReturn((Object)portletApplication);
                    Mockito.stub((Object)portletContainer.getId()).toReturn((Object)components.getPortletName());
                    Mockito.stub((Object)portletContainer.getInfo()).toReturn((Object)portlet.getInfo());
                    ManagedObjectLifeCycleEvent lifeCycleEvent = new ManagedObjectLifeCycleEvent((ManagedObject)portletContainer, LifeCycleStatus.STOPPED);
                    producer.onEvent((ManagedObjectRegistryEvent)lifeCycleEvent);
                }
                catch (Exception e) {}
            }
        }
        if (this.removeCurrent(warFileName)) {
            this.war2Handles.remove(warFileName);
        }
        this.undeployArchive(warFileName);
    }

    protected abstract boolean removeCurrent(String var1);

    protected void resetRegistrationInfo() throws RegistrationException {
        WSRPProducer producer = this.getProducer();
        ProducerRegistrationRequirements registrationRequirements = producer.getConfigurationService().getConfiguration().getRegistrationRequirements();
        registrationRequirements.setRegistrationRequired(false);
        registrationRequirements.clearRegistrationProperties();
        registrationRequirements.clearRegistrationPropertyChangeListeners();
        producer.getRegistrationManager().clear();
        registrationRequirements.removeRegistrationPropertyChangeListener((RegistrationPropertyChangeListener)producer.getRegistrationManager());
    }

    private File getDirectory(String property) throws Exception {
        String deployableProperty = System.getProperty(property);
        if (deployableProperty != null) {
            File deployableDir = new File(deployableProperty);
            if (deployableDir.exists() && deployableDir.isDirectory()) {
                return deployableDir;
            }
            throw new Error("Found a system property for '" + property + "' [" + deployableProperty + "] but value does not correspond to a directory.");
        }
        throw new Error("Could not find the system property '" + property + "' cannot deploy test archives.");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.resetRegistrationInfo();
        this.getProducerHelper().reset();
    }

    public void tearDown() throws Exception {
        this.resetRegistrationInfo();
        super.tearDown();
    }

    protected String getWarName(String handle) {
        PortletContext context = PortletContext.createPortletContext((String)handle);
        return context.getComponents().getApplicationName() + ".war";
    }

    protected abstract Collection<String> getPortletHandles() throws Exception;

    @Deployment(name="test-basic-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestBasicPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-basic-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-basic-portlet-war").as(WebArchive.class));
        webArchive.addClass(BasicPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-markup-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestMarkupPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-markup-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-markup-portlet-war").as(WebArchive.class));
        webArchive.addClass(MarkupPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-resourcenoencodeurl-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestResourceNoEncodeURLPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-resourcenoencodeurl-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-resourcenoencodeurl-portlet-war").as(WebArchive.class));
        webArchive.addClass(ResourceNoEncodeURLPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-applicationscope-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestApplicationScopePortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-applicationscope-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-applicationscope-portlet-war").as(WebArchive.class));
        webArchive.addClass(ApplicationScopeSetPortlet.class);
        webArchive.addClass(ApplicationScopeGetPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-session-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestSessionPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-session-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-session-portlet-war").as(WebArchive.class));
        webArchive.addClass(SessionPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-dispatcher-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestDispatcherPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-dispatcher-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-dispatcher-portlet-war").as(WebArchive.class));
        webArchive.addClass(DispatcherPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-getlocales-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestGetLocalesPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-getlocales-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-getlocales-portlet-war").as(WebArchive.class));
        webArchive.addClass(GetLocalesPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-encodeurl-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestEncodeURLPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-encodeurl-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-encodeurl-portlet-war").as(WebArchive.class));
        webArchive.addClass(EncodeURLPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-usercontext-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestUserContextPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-usercontext-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-usercontext-portlet-war").as(WebArchive.class));
        webArchive.addClass(UserContextPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-multivalued-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestMultiValuedPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-multivalued-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-multivalued-portlet-war").as(WebArchive.class));
        webArchive.addClass(MultiValuedPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-implicitcloning-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestImplicitCloningPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-implicitcloning-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-implicitcloning-portlet-war").as(WebArchive.class));
        webArchive.addClass(ImplicitCloningPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-resource-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestResourcePortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-resource-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-resource-portlet-war").as(WebArchive.class));
        webArchive.addClass(ResourcePortlet.class);
        return webArchive;
    }

    @Deployment(name="test-renderparam-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestRenderParamPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-renderparam-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-renderparam-portlet-war").as(WebArchive.class));
        webArchive.addClass(RenderParamPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-events-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestEventsPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-events-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-events-portlet-war").as(WebArchive.class));
        webArchive.addClass(EventGeneratorPortlet.class);
        webArchive.addClass(EventConsumerPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-prp-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestPRPPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-prp-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-prp-portlet-war").as(WebArchive.class));
        webArchive.addClass(RenderParamPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-portletmodes-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestPortletModesPortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-portletmodes-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-portletmodes-portlet-war").as(WebArchive.class));
        webArchive.addClass(RenderParamPortlet.class);
        return webArchive;
    }

    @Deployment(name="test-portletstate-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createTestPortletStatePortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test-portletstate-portlet.war");
        webArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/test-portlets/test-portletstate-portlet-war").as(WebArchive.class));
        webArchive.addClass(RenderParamPortlet.class);
        return webArchive;
    }

    @Deployment(name="google-portlet.war", managed=false)
    @OverProtocol(value="Servlet 2.5")
    public static WebArchive createGooglePortletArchive() {
        WebArchive webArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"google-portlet.war");
        webArchive.setManifest(new File("src/test/test-portlets/google-portlet-war/META-INF/MANIFEST.MF"));
        WebArchive googlePortletArchive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/test-archives/google-portlet.war"));
        webArchive.merge((Archive)googlePortletArchive);
        return webArchive;
    }
}

