/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPActionURL;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPRenderURL;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v1.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v1.V1BlockingInteractionResponse;
import org.oasis.wsrp.v1.V1CacheControl;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1InitCookie;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1MarkupContext;
import org.oasis.wsrp.v1.V1MarkupResponse;
import org.oasis.wsrp.v1.V1NamedString;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PerformBlockingInteraction;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1SessionContext;
import org.oasis.wsrp.v1.V1StateChange;
import org.oasis.wsrp.v1.V1UnsupportedMode;
import org.oasis.wsrp.v1.V1UpdateResponse;

@RunWith(value=Arquillian.class)
public class MarkupTestCase
extends NeedPortletHandleTest {
    private static final String DEFAULT_VIEW_MARKUP = "<p>symbol unset stock value: value unset</p>";
    private static final String DEFAULT_MARKUP_PORTLET_WAR = "test-markup-portlet.war";

    public MarkupTestCase() throws Exception {
        super("MarkupTestCase", DEFAULT_MARKUP_PORTLET_WAR);
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        Archive archive = V1ProducerBaseTest.createDeployment();
        return archive;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetMarkupViewNoSession() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        V1MarkupResponse response = this.producer.getMarkup(getMarkup);
        this.checkMarkupResponse(response, DEFAULT_VIEW_MARKUP);
    }

    @Test
    public void testGetMarkupNoPortletInstanceKeyNoNamespacePrefix() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getRuntimeContext().setNamespacePrefix(null);
        getMarkup.getRuntimeContext().setPortletInstanceKey(null);
        MarkupTestCase.assertNull((Object)getMarkup.getRuntimeContext().getNamespacePrefix());
        MarkupTestCase.assertNull((Object)getMarkup.getRuntimeContext().getPortletInstanceKey());
        V1MarkupResponse response = this.producer.getMarkup(getMarkup);
        this.checkMarkupResponse(response, DEFAULT_VIEW_MARKUP);
        getMarkup.getRuntimeContext().setNamespacePrefix("");
        getMarkup.getRuntimeContext().setPortletInstanceKey("");
        MarkupTestCase.assertSame((Object)"", (Object)getMarkup.getRuntimeContext().getNamespacePrefix());
        MarkupTestCase.assertSame((Object)"", (Object)getMarkup.getRuntimeContext().getPortletInstanceKey());
        response = this.producer.getMarkup(getMarkup);
        this.checkMarkupResponse(response, DEFAULT_VIEW_MARKUP);
    }

    @Test
    public void testInvalidGetMarkup() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getMarkupParams().setMode("invalid mode");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail();
        }
        catch (V1UnsupportedMode v1UnsupportedMode) {
            // empty catch block
        }
    }

    @Test
    public void testGetMarkupWithSessionID() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getRuntimeContext().setSessionID("Hello World");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"A sessionID should not be allowed to be passed in GetMarkup()");
        }
        catch (V1OperationFailed v1OperationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testGetMarkupEditNoSession() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getMarkupParams().setMode("wsrp:edit");
        V1MarkupResponse response = this.producer.getMarkup(getMarkup);
        String namespacePrefix = getMarkup.getRuntimeContext().getNamespacePrefix();
        this.checkMarkupResponse(response, "<form method='post' action='wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite' id='" + namespacePrefix + "portfolioManager'><table><tr><td>Stock symbol</t" + "d><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupRenderParameters() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archiveName = "test-renderparam-portlet.war";
        this.deploy(archiveName);
        try {
            V1GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getMarkupString();
            String julienLink = this.extractLink(markupString, 0);
            WSRPPortletURL julienURL = WSRPPortletURL.create((String)julienLink);
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Hello, Anonymous!");
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Counter: 0");
            ExtendedAssert.assertTrue((boolean)(julienURL instanceof WSRPRenderURL));
            WSRPRenderURL julienRender = (WSRPRenderURL)julienURL;
            gm.getMarkupParams().setNavigationalState(julienRender.getNavigationalState().getStringValue());
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getMarkupString();
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Hello, Julien!");
            WSRPPortletURL incrementURL = WSRPPortletURL.create((String)this.extractLink(markupString, julienLink.length() * 2));
            ExtendedAssert.assertTrue((boolean)(incrementURL instanceof WSRPActionURL));
            WSRPActionURL incrementAction = (WSRPActionURL)incrementURL;
            V1PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            V1InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
            interactionParams.setInteractionState(incrementAction.getInteractionState().getStringValue());
            this.producer.performBlockingInteraction(performBlockingInteraction);
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getMarkupString();
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Counter: 1");
        }
        finally {
            this.undeploy(archiveName);
        }
    }

    private String extractLink(String markupString, int fromIndex) {
        int urlStartIndex = markupString.indexOf("='", fromIndex);
        int urlEndIndex = markupString.indexOf("'>", urlStartIndex);
        return markupString.substring(urlStartIndex + 2, urlEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupSession() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String sessionPortletArchive = "test-session-portlet.war";
        this.deploy(sessionPortletArchive);
        try {
            V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponseWithSession(response, 0);
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponseWithSession(response, 1);
        }
        finally {
            this.undeploy(sessionPortletArchive);
        }
    }

    @Test
    public void testPerformBlockingInteractionNoRedirect() throws Exception {
        this.checkPBIAndGetNavigationalState("RHAT");
    }

    @Test
    public void testPerformBlockingInteractionRedirect() throws Exception {
        V1PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getDefaultHandle());
        V1InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        V1NamedString namedString = new V1NamedString();
        namedString.setName("symbol");
        namedString.setValue("HELP");
        interactionParams.getFormParameters().add(namedString);
        V1BlockingInteractionResponse response = this.producer.performBlockingInteraction(performBlockingInteraction);
        ExtendedAssert.assertNotNull((Object)response);
        String redirectURL = response.getRedirectURL();
        ExtendedAssert.assertNotNull((Object)redirectURL);
        ExtendedAssert.assertEquals((String)"/WEB-INF/jsp/help.jsp", (String)redirectURL);
        V1UpdateResponse updateResponse = response.getUpdateResponse();
        ExtendedAssert.assertNull((Object)updateResponse);
    }

    @Test
    public void testGMAndPBIInteraction() throws Exception {
        this.testGetMarkupViewNoSession();
        String symbol = "AAPL";
        String navigationalState = this.checkPBIAndGetNavigationalState(symbol);
        V1GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getMarkupParams().setNavigationalState(navigationalState);
        V1MarkupResponse response = this.producer.getMarkup(getMarkup);
        this.checkMarkupResponse(response, "<p>" + symbol + " stock value: 123.45</p>");
    }

    @Test
    public void testPBIWithSessionID() throws Exception {
        String portletHandle = this.getDefaultHandle();
        V1PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(portletHandle);
        V1RuntimeContext runtimeContext = performBlockingInteraction.getRuntimeContext();
        runtimeContext.setSessionID("Hello World");
        try {
            this.producer.performBlockingInteraction(performBlockingInteraction);
            ExtendedAssert.fail((String)"Should not be able to pass a sessionID in a PerformBlockingInteraction()");
        }
        catch (V1OperationFailed expected) {
            // empty catch block
        }
    }

    @Test
    public void testMarkupCaching() throws Exception {
        V1GetMarkup getMarkup = this.createMarkupRequest();
        V1MarkupResponse response = this.producer.getMarkup(getMarkup);
        V1CacheControl cacheControl = response.getMarkupContext().getCacheControl();
        ExtendedAssert.assertNotNull((Object)cacheControl);
        ExtendedAssert.assertEquals((String)"wsrp:perUser", (String)cacheControl.getUserScope());
        ExtendedAssert.assertEquals((int)15, (int)cacheControl.getExpires());
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String sessionPortletArchive = "test-session-portlet.war";
        this.deploy(sessionPortletArchive);
        response = this.producer.getMarkup(this.createMarkupRequestForCurrentlyDeployedPortlet());
        cacheControl = response.getMarkupContext().getCacheControl();
        ExtendedAssert.assertNull((Object)cacheControl);
        this.undeploy(sessionPortletArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithDispatcherPortlet() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String dispatcherPortletArchive = "test-dispatcher-portlet.war";
        this.deploy(dispatcherPortletArchive);
        try {
            V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "test");
        }
        finally {
            this.undeploy(dispatcherPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNoContent() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String basicPortletArchive = "test-basic-portlet.war";
        this.deploy(basicPortletArchive);
        try {
            V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "");
        }
        finally {
            this.undeploy(basicPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNonStandardLocalesStrictMode() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
        getMarkup.getMarkupParams().getLocales().clear();
        getMarkup.getMarkupParams().getLocales().add("en_US");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    @Test
    public void testGetMarkupWithNonStandardLocalesLenientMode() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
        getMarkup.getMarkupParams().getLocales().clear();
        getMarkup.getMarkupParams().getLocales().add("en_US");
        this.producer.usingStrictModeChangedTo(false);
        this.checkMarkupResponse(this.producer.getMarkup(getMarkup), "English (United States)");
        this.undeploy(getLocalesPortletArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithoutDeclaredLocale() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        V1GetMarkup getMarkup = this.createMarkupRequest(this.getPortletHandleFrom("No Declared"));
        try {
            this.checkMarkupResponse(this.producer.getMarkup(getMarkup), Locale.getDefault().getDisplayName());
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupLocales() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        V1GetMarkup getMarkup = this.createMarkupRequest(this.getPortletHandleFrom("Simple"));
        try {
            List locales = getMarkup.getMarkupParams().getLocales();
            locales.add("en");
            locales.add("fr");
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.ENGLISH.getDisplayName());
            locales.clear();
            locales.add("fr");
            locales.add("en");
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.FRENCH.getDisplayName());
            locales.clear();
            locales.add("de");
            locales.add("en");
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.ENGLISH.getDisplayName());
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithEncodedURLs() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String encodeURLPortletArchive = "test-encodeurl-portlet.war";
        this.deploy(encodeURLPortletArchive);
        try {
            V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite\nwsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewrite");
        }
        finally {
            this.undeploy(encodeURLPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithUserContext() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String userContextPortletArchive = "test-usercontext-portlet.war";
        this.deploy(userContextPortletArchive);
        try {
            V1GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            getMarkup.setUserContext(WSRP1TypeFactory.createUserContext((String)"johndoe"));
            V1MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "user: null");
        }
        finally {
            this.undeploy(userContextPortletArchive);
        }
    }

    @Test
    public void testGetMarkupMultiValuedFormParams() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String multiValuedPortletArchive = "test-multivalued-portlet.war";
        this.deploy(multiValuedPortletArchive);
        V1NamedString namedString = this.createNamedString("multi", "value1");
        try {
            V1PerformBlockingInteraction action = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            List formParameters = action.getInteractionParams().getFormParameters();
            formParameters.add(namedString);
            V1BlockingInteractionResponse actionResponse = this.producer.performBlockingInteraction(action);
            V1GetMarkup markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalState(actionResponse.getUpdateResponse().getNavigationalState());
            V1MarkupResponse response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: value1");
            formParameters.clear();
            formParameters.add(namedString);
            formParameters.add(this.createNamedString("multi", "value2"));
            actionResponse = this.producer.performBlockingInteraction(action);
            markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalState(actionResponse.getUpdateResponse().getNavigationalState());
            response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: value1, value2");
            formParameters.clear();
            formParameters.add(this.createNamedString("foo", null));
            actionResponse = this.producer.performBlockingInteraction(action);
            markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalState(actionResponse.getUpdateResponse().getNavigationalState());
            response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: ");
        }
        catch (Exception e) {
            System.out.println("Failure in TestGetMarkupMultiValuedFromParams");
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            this.undeploy(multiValuedPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImplicitCloning() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archiveName = "test-implicitcloning-portlet.war";
        this.deploy(archiveName);
        try {
            V1GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getMarkupString();
            ExtendedAssert.assertEquals((String)"initial", (String)markupString);
            V1PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            pbi.getInteractionParams().setPortletStateChange(V1StateChange.CLONE_BEFORE_WRITE);
            String value = "new value";
            pbi.getInteractionParams().getFormParameters().add(this.createNamedString("value", value));
            V1BlockingInteractionResponse response = this.producer.performBlockingInteraction(pbi);
            ExtendedAssert.assertNotNull((Object)response);
            V1PortletContext pc = response.getUpdateResponse().getPortletContext();
            ExtendedAssert.assertNotNull((Object)pc);
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getMarkupString();
            ExtendedAssert.assertEquals((String)"initial", (String)markupString);
            gm.setPortletContext(pc);
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getMarkupString();
            ExtendedAssert.assertEquals((String)value, (String)markupString);
        }
        finally {
            this.undeploy(archiveName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithResource() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resource-portlet.war";
        this.deploy(archive);
        try {
            V1GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getMarkupString();
            String markupStart = "<img src='wsrp_rewrite?wsrp-urlType=resource&amp;wsrp-url=http%3A%2F%2F";
            String markupEnd = "%3A8080%2Ftest-resource-portlet%2Fgif%2Flogo.gif&amp;wsrp-requiresRewrite=true/wsrp_rewrite'/>";
            String localhostMarkup = markupStart + "localhost" + markupEnd;
            String homeIPMarkup = markupStart + "127.0.0.1" + markupEnd;
            boolean result = localhostMarkup.equals(markupString) || homeIPMarkup.equals(markupString);
            ExtendedAssert.assertTrue((String)("Expectd '" + localhostMarkup + "' or '" + homeIPMarkup + "' but received '" + markupString + "'."), (boolean)result);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNonURLEncodedResource() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resourcenoencodeurl-portlet.war";
        this.deploy(archive);
        try {
            V1GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            V1MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getMarkupString();
            String markupStart = "<img src='http://";
            String markupEnd = ":8080/test-resourcenoencodeurl-portlet/gif/logo.gif'/>";
            String localhostMarkup = markupStart + "localhost" + markupEnd;
            String homeIPMarkup = markupStart + "127.0.0.1" + markupEnd;
            boolean result = localhostMarkup.equals(markupString) || homeIPMarkup.equals(markupString);
            ExtendedAssert.assertTrue((String)("Expectd '" + localhostMarkup + "' or '" + homeIPMarkup + "' but received '" + markupString + "'."), (boolean)result);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplicationScopeVariableHandling() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-applicationscope-portlet.war";
        this.deploy(archive);
        try {
            V1PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getPortletHandleFrom("Set"));
            pbi.getInteractionParams().getFormParameters().add(this.createNamedString("appVar", "value"));
            this.producer.performBlockingInteraction(pbi);
            V1GetMarkup gm = this.createMarkupRequest(this.getPortletHandleFrom("Get"));
            V1MarkupResponse res = this.producer.getMarkup(gm);
            this.checkMarkupResponse(res, "appVar=value");
        }
        finally {
            this.undeploy(archive);
        }
    }

    @Test
    public void testGetMarkupNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1GetMarkup gm = this.createMarkupRequest();
        try {
            this.producer.getMarkup(gm);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (V1InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPerformBlockingInteractionNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
        try {
            this.producer.performBlockingInteraction(pbi);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (V1InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInitCookieNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1InitCookie initCookie = WSRP1TypeFactory.createInitCookie(null);
        try {
            this.producer.initCookie(initCookie);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (V1InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    private V1NamedString createNamedString(String name, String value) {
        V1NamedString namedString = new V1NamedString();
        namedString.setName(name);
        namedString.setValue(value);
        return namedString;
    }

    private String checkPBIAndGetNavigationalState(String symbol) throws Exception {
        V1PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getDefaultHandle());
        V1InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        interactionParams.getFormParameters().add(this.createNamedString("symbol", symbol));
        V1BlockingInteractionResponse response = this.producer.performBlockingInteraction(performBlockingInteraction);
        ExtendedAssert.assertNotNull((Object)response);
        ExtendedAssert.assertNull((Object)response.getRedirectURL());
        V1UpdateResponse updateResponse = response.getUpdateResponse();
        ExtendedAssert.assertNotNull((Object)updateResponse);
        ExtendedAssert.assertNull((Object)updateResponse.getPortletContext());
        ExtendedAssert.assertNull((Object)updateResponse.getSessionContext());
        String navigationalState = updateResponse.getNavigationalState();
        ExtendedAssert.assertNotNull((Object)navigationalState);
        ExtendedAssert.assertEquals((String)updateResponse.getNewMode(), (String)"wsrp:view");
        V1MarkupContext markupContext = updateResponse.getMarkupContext();
        ExtendedAssert.assertNull((Object)markupContext);
        return navigationalState;
    }

    private void checkMarkupResponseWithSession(V1MarkupResponse response, int count) throws RemoteException, V1InvalidRegistration, V1OperationFailed {
        ExtendedAssert.assertNotNull((Object)response);
        V1MarkupContext markupContext = response.getMarkupContext();
        ExtendedAssert.assertNotNull((Object)markupContext);
        String markupString = markupContext.getMarkupString();
        ExtendedAssert.assertString1ContainsString2((String)markupString, (String)("count = " + count));
        ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"<a href='wsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewrite'>render</a>");
        this.checkSessionForCurrentlyDeployedPortlet(response);
    }

    private V1MarkupContext checkMarkupResponse(V1MarkupResponse response, String markupString) {
        ExtendedAssert.assertNotNull((Object)response);
        V1MarkupContext markupContext = response.getMarkupContext();
        ExtendedAssert.assertNotNull((Object)markupContext);
        ExtendedAssert.assertEquals((String)"text/html", (String)markupContext.getMimeType());
        ExtendedAssert.assertEquals((String)"title", (String)markupContext.getPreferredTitle());
        if (!ParameterValidation.isNullOrEmpty((String)markupString)) {
            ExtendedAssert.assertTrue((boolean)markupContext.isRequiresUrlRewriting());
        } else {
            ExtendedAssert.assertFalse((boolean)markupContext.isRequiresUrlRewriting());
        }
        ExtendedAssert.assertEquals((String)markupString, (String)markupContext.getMarkupString());
        V1SessionContext sessionContext = response.getSessionContext();
        ExtendedAssert.assertNull((Object)sessionContext);
        return markupContext;
    }

    @Override
    protected String getMostUsedPortletWARFileName() {
        return DEFAULT_MARKUP_PORTLET_WAR;
    }
}

