/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.rmi.RemoteException;
import java.util.List;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1MarkupResponse;
import org.oasis.wsrp.v1.V1OperationFailed;

public abstract class NeedPortletHandleTest
extends V1ProducerBaseTest {
    private String mostUsedPortletWARFileName;

    public NeedPortletHandleTest(String portletWARFileName) throws Exception {
        this("NeedPortletHandleTest", portletWARFileName);
        this.mostUsedPortletWARFileName = portletWARFileName;
    }

    protected NeedPortletHandleTest(String name, String portletWARFileName) throws Exception {
        super(name);
        this.mostUsedPortletWARFileName = portletWARFileName;
    }

    protected String getDefaultHandle() {
        return this.getFirstHandleFor(this.mostUsedPortletWARFileName);
    }

    private String getFirstHandleFor(String archiveName) {
        return (String)((List)this.war2Handles.get(archiveName)).get(0);
    }

    protected String getHandleForCurrentlyDeployedArchive() {
        return this.getFirstHandleFor(this.currentlyDeployedArchiveName);
    }

    protected List<String> getHandlesForCurrentlyDeployedArchive() {
        return (List)this.war2Handles.get(this.currentlyDeployedArchiveName);
    }

    @Override
    protected boolean removeCurrent(String archiveName) {
        return !this.mostUsedPortletWARFileName.equals(archiveName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mostUsedPortletWARFileName = this.getMostUsedPortletWARFileName();
        this.deploy(this.mostUsedPortletWARFileName);
        this.producer.usingStrictModeChangedTo(true);
    }

    protected abstract String getMostUsedPortletWARFileName();

    @Override
    public void tearDown() throws Exception {
        this.undeploy(this.mostUsedPortletWARFileName);
        super.tearDown();
    }

    protected V1GetMarkup createMarkupRequestForCurrentlyDeployedPortlet() throws Exception {
        return this.createMarkupRequest(this.getHandleForCurrentlyDeployedArchive());
    }

    protected V1GetMarkup createMarkupRequest(String handle) throws RemoteException, V1InvalidRegistration, V1OperationFailed {
        V1GetMarkup getMarkup = this.createDefaultMarkupRequest(handle);
        getMarkup.getMarkupParams().getMarkupCharacterSets().add("UTF-8");
        return getMarkup;
    }

    protected String getPortletHandleFrom(String partialHandle) {
        List<String> handles = this.getHandlesForCurrentlyDeployedArchive();
        for (String handle : handles) {
            if (!handle.contains(partialHandle)) continue;
            return handle;
        }
        throw new IllegalArgumentException("Couldn't find a portlet handle matching '" + partialHandle + "' in " + this.currentlyDeployedArchiveName);
    }

    protected V1GetMarkup createMarkupRequest() throws Exception {
        return this.createMarkupRequestForCurrentlyDeployedPortlet();
    }

    protected void checkSessionForCurrentlyDeployedPortlet(V1MarkupResponse response) throws RemoteException, V1InvalidRegistration, V1OperationFailed {
    }
}

