/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v1.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1ClonePortlet;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1DestroyPortlets;
import org.oasis.wsrp.v1.V1DestroyPortletsResponse;
import org.oasis.wsrp.v1.V1GetPortletDescription;
import org.oasis.wsrp.v1.V1GetPortletProperties;
import org.oasis.wsrp.v1.V1GetPortletPropertyDescription;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescriptionResponse;
import org.oasis.wsrp.v1.V1PortletPropertyDescriptionResponse;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1SetPortletProperties;

@RunWith(value=Arquillian.class)
public class PortletManagementTestCase
extends NeedPortletHandleTest {
    private static final String TEST_BASIC_PORTLET_WAR = "test-basic-portlet.war";

    public PortletManagementTestCase() throws Exception {
        super("PortletManagementTestCase", TEST_BASIC_PORTLET_WAR);
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        Archive archive = V1ProducerBaseTest.createDeployment();
        return archive;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testClonePortlet() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext initialContext = WSRP1TypeFactory.createPortletContext((String)handle);
        V1PortletContext cloneContext = this.clonePortlet(handle);
        ExtendedAssert.assertNotNull((Object)cloneContext);
        ExtendedAssert.assertFalse((boolean)initialContext.equals(cloneContext));
        V1GetPortletProperties getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)cloneContext);
        List result = this.producer.getPortletProperties(getPortletProperties).getProperties();
        getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)initialContext);
        this.checkGetPropertiesResponse(this.producer.getPortletProperties(getPortletProperties), result);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        this.checkServiceDescriptionWithOnlyBasicPortlet(gs);
    }

    @Test
    public void testClonePortletNoRegistrationWhenRequired() {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String handle = this.getDefaultHandle();
        V1ClonePortlet clonePortlet = WSRP1TypeFactory.createSimpleClonePortlet((String)handle);
        try {
            this.producer.clonePortlet(clonePortlet);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistrationFault");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDestroyPortlets() throws Exception {
        String handle = this.getDefaultHandle();
        V1DestroyPortlets destroyPortlets = WSRP1TypeFactory.createDestroyPortlets(null, Collections.singletonList(handle));
        V1DestroyPortletsResponse response = this.producer.destroyPortlets(destroyPortlets);
        ExtendedAssert.assertNotNull((Object)response);
        List failures = response.getDestroyFailed();
        ExtendedAssert.assertNotNull((Object)failures);
        ExtendedAssert.assertEquals((int)1, (int)failures.size());
        V1DestroyFailed failure = (V1DestroyFailed)failures.get(0);
        ExtendedAssert.assertNotNull((Object)failure);
        ExtendedAssert.assertEquals((String)handle, (String)failure.getPortletHandle());
        ExtendedAssert.assertNotNull((Object)failure.getReason());
        V1PortletContext portletContext = this.clonePortlet(handle);
        destroyPortlets = WSRP1TypeFactory.createDestroyPortlets(null, Collections.singletonList(portletContext.getPortletHandle()));
        response = this.producer.destroyPortlets(destroyPortlets);
        ExtendedAssert.assertNotNull((Object)response);
        failures = response.getDestroyFailed();
        ExtendedAssert.assertTrue((String)("Got back failures when none expected :" + failures), (failures == null || failures.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDestroyPortletsNoRegistrationWhenRequired() {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String handle = this.getDefaultHandle();
        V1DestroyPortlets dp = WSRP1TypeFactory.createDestroyPortlets(null, Collections.singletonList(handle));
        try {
            this.producer.destroyPortlets(dp);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistrationFault");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPortletDescription() throws Exception {
        String handle = this.getDefaultHandle();
        V1GetPortletDescription gpd = WSRP1TypeFactory.createGetPortletDescription(null, (String)handle);
        V1PortletDescriptionResponse response = this.producer.getPortletDescription(gpd);
        ExtendedAssert.assertNotNull((Object)response);
        this.checkBasicPortletDescription(response.getPortletDescription(), handle);
    }

    @Test
    public void testGetPortletDescriptionNoRegistrationWhenRequired() {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String handle = this.getDefaultHandle();
        V1GetPortletDescription gpd = WSRP1TypeFactory.createGetPortletDescription(null, (String)handle);
        try {
            this.producer.getPortletDescription(gpd);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistrationFault");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetPortletPropertiesNoKeys() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext initialContext = WSRP1TypeFactory.createPortletContext((String)handle);
        V1GetPortletProperties getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)initialContext);
        V1PropertyList response = this.producer.getPortletProperties(getPortletProperties);
        ArrayList<V1Property> expected = new ArrayList<V1Property>(2);
        Collections.addAll(expected, WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"prefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"prefValue2"));
        this.checkGetPropertiesResponse(response, expected);
    }

    @Test
    public void testGetPortletPropertiesNoRegistration() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext initialContext = WSRP1TypeFactory.createPortletContext((String)handle);
        V1GetPortletProperties getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)initialContext);
        List names = getPortletProperties.getNames();
        Collections.addAll(names, "prefName1", "prefName2");
        V1PropertyList response = this.producer.getPortletProperties(getPortletProperties);
        ArrayList<V1Property> expected = new ArrayList<V1Property>(2);
        Collections.addAll(expected, WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"prefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"prefValue2"));
        this.checkGetPropertiesResponse(response, expected);
        names.clear();
        response = this.producer.getPortletProperties(getPortletProperties);
        names.add("prefName2");
        response = this.producer.getPortletProperties(getPortletProperties);
        this.checkGetPropertiesResponse(response, Collections.singletonList(WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"prefValue2")));
    }

    public void testGetPortletPropertyDescription() throws Exception {
        String handle = this.getDefaultHandle();
        V1GetPortletPropertyDescription getPortletPropertyDescription = WSRP1TypeFactory.createSimpleGetPortletPropertyDescription((String)handle);
        V1PortletPropertyDescriptionResponse response = this.producer.getPortletPropertyDescription(getPortletPropertyDescription);
        V1ModelDescription desc = response.getModelDescription();
        ExtendedAssert.assertNotNull((Object)desc);
        List propertyDescriptions = desc.getPropertyDescriptions();
        ExtendedAssert.assertNotNull((Object)propertyDescriptions);
        ArrayList<V1PropertyDescription> expected = new ArrayList<V1PropertyDescription>(2);
        V1PropertyDescription description = WSRP1TypeFactory.createPropertyDescription((String)"prefName1", (QName)WSRPConstants.XSD_STRING);
        description.setHint(WSRP1TypeFactory.createLocalizedString((String)"prefName1"));
        description.setLabel(WSRP1TypeFactory.createLocalizedString((String)"prefName1"));
        expected.add(description);
        description = WSRP1TypeFactory.createPropertyDescription((String)"prefName2", (QName)WSRPConstants.XSD_STRING);
        description.setHint(WSRP1TypeFactory.createLocalizedString((String)"prefName2"));
        description.setLabel(WSRP1TypeFactory.createLocalizedString((String)"prefName2"));
        expected.add(description);
        this.checkPropertyDescriptions(expected, propertyDescriptions);
    }

    @Test
    public void testGetPortletPropertiesNoRegistrationWhenRequired() {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String handle = this.getDefaultHandle();
        V1GetPortletPropertyDescription getPortletPropertyDescription = WSRP1TypeFactory.createSimpleGetPortletPropertyDescription((String)handle);
        try {
            this.producer.getPortletPropertyDescription(getPortletPropertyDescription);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistrationFault");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetPortletProperties() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext portletContext = this.clonePortlet(handle);
        V1PropertyList propertyList = WSRP1TypeFactory.createPropertyList();
        List properties = propertyList.getProperties();
        Collections.addAll(properties, WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"newPrefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"newPrefValue2"));
        V1SetPortletProperties setPortletProperties = WSRP1TypeFactory.createSetPortletProperties(null, (V1PortletContext)portletContext, (V1PropertyList)propertyList);
        V1PortletContext response = this.producer.setPortletProperties(setPortletProperties);
        V1GetPortletProperties getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)response);
        Collections.addAll(getPortletProperties.getNames(), "prefName1", "prefName2");
        this.checkGetPropertiesResponse(this.producer.getPortletProperties(getPortletProperties), properties);
        portletContext = WSRP1TypeFactory.createPortletContext((String)handle);
        setPortletProperties.setPortletContext(portletContext);
        try {
            response = this.producer.setPortletProperties(setPortletProperties);
            ExtendedAssert.fail((String)"Setting properties on Producer-Offered Portlet should fail...");
        }
        catch (V1InconsistentParameters expected) {
            // empty catch block
        }
    }

    @Test
    public void testSetPortletPropertiesNoLanguage() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext portletContext = this.clonePortlet(handle);
        V1PropertyList propertyList = WSRP1TypeFactory.createPropertyList();
        List properties = propertyList.getProperties();
        Collections.addAll(properties, WSRP1TypeFactory.createProperty((String)"prefName1", null, (String)"newPrefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", null, (String)"newPrefValue2"));
        V1SetPortletProperties setPortletProperties = WSRP1TypeFactory.createSetPortletProperties(null, (V1PortletContext)portletContext, (V1PropertyList)propertyList);
        V1PortletContext response = this.producer.setPortletProperties(setPortletProperties);
        V1GetPortletProperties getPortletProperties = WSRP1TypeFactory.createGetPortletProperties(null, (V1PortletContext)response);
        Collections.addAll(getPortletProperties.getNames(), "prefName1", "prefName2");
        propertyList = WSRP1TypeFactory.createPropertyList();
        properties = propertyList.getProperties();
        Collections.addAll(properties, WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"newPrefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"newPrefValue2"));
        this.checkGetPropertiesResponse(this.producer.getPortletProperties(getPortletProperties), properties);
    }

    @Test
    public void testSetResetSamePortletProperty() throws Exception {
        String handle = this.getDefaultHandle();
        V1PortletContext portletContext = this.clonePortlet(handle);
        V1PropertyList propertyList = WSRP1TypeFactory.createPropertyList();
        propertyList.getProperties().add(WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"newPrefValue1"));
        propertyList.getResetProperties().add(WSRP1TypeFactory.createResetProperty((String)"prefName1"));
        V1SetPortletProperties setPortletProperties = WSRP1TypeFactory.createSetPortletProperties(null, (V1PortletContext)portletContext, (V1PropertyList)propertyList);
        try {
            this.producer.setPortletProperties(setPortletProperties);
            PortletManagementTestCase.fail((String)"Shouldn't be possible to set and reset a property in the same call");
        }
        catch (V1InconsistentParameters v1InconsistentParameters) {
            // empty catch block
        }
    }

    @Test
    public void testSetPortletPropertiesNoRegistrationWhenRequired() {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        V1PropertyList propertyList = WSRP1TypeFactory.createPropertyList();
        List properties = propertyList.getProperties();
        Collections.addAll(properties, WSRP1TypeFactory.createProperty((String)"prefName1", (String)"en", (String)"newPrefValue1"), WSRP1TypeFactory.createProperty((String)"prefName2", (String)"en", (String)"newPrefValue2"));
        V1SetPortletProperties setPortletProperties = WSRP1TypeFactory.createSetPortletProperties(null, (V1PortletContext)WSRP1TypeFactory.createPortletContext((String)this.getDefaultHandle()), (V1PropertyList)propertyList);
        try {
            this.producer.setPortletProperties(setPortletProperties);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistrationFault");
        }
        catch (V1InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    private V1PortletContext clonePortlet(String handle) throws V1InvalidUserCategory, V1InconsistentParameters, V1InvalidRegistration, V1MissingParameters, V1OperationFailed, V1AccessDenied, V1InvalidHandle {
        V1ClonePortlet clonePortlet = WSRP1TypeFactory.createSimpleClonePortlet((String)handle);
        return this.producer.clonePortlet(clonePortlet);
    }

    private List<V1Property> checkGetPropertiesResponse(V1PropertyList response, List<V1Property> expected) {
        ExtendedAssert.assertNotNull((Object)response);
        List properties = response.getProperties();
        ExtendedAssert.assertEquals((Object[])expected.toArray(), (Object[])properties.toArray(), (boolean)false, (String)"Didn't receive expected properties!", (ExtendedAssert.Decorator)new PropertyDecorator());
        return properties;
    }

    private void checkPropertyDescriptions(List<V1PropertyDescription> expected, List<V1PropertyDescription> propertyDescriptions) {
        ExtendedAssert.assertEquals((int)expected.size(), (int)propertyDescriptions.size());
        V1PropertyDescription propDesc = propertyDescriptions.get(0);
        ExtendedAssert.assertNotNull((Object)propDesc);
        String name = propDesc.getName();
        if ("prefName1".equals(name)) {
            PortletManagementTestCase.assertEquals(expected.get(0), propDesc);
            PortletManagementTestCase.assertEquals(expected.get(1), propertyDescriptions.get(1));
        } else if ("prefName2".equals(name)) {
            PortletManagementTestCase.assertEquals(expected.get(1), propDesc);
            PortletManagementTestCase.assertEquals(expected.get(0), propertyDescriptions.get(1));
        } else {
            ExtendedAssert.fail((String)("Unexpected PropertyDescription named '" + name + "'"));
        }
    }

    @Override
    protected String getMostUsedPortletWARFileName() {
        return TEST_BASIC_PORTLET_WAR;
    }

    private static class PropertyDecorator
    implements ExtendedAssert.Decorator {
        private V1Property prop;

        private PropertyDecorator() {
        }

        public void decorate(Object decorated) {
            this.prop = (V1Property)decorated;
        }

        public boolean equals(Object o) {
            if (o instanceof ExtendedAssert.DecoratedObject) {
                ExtendedAssert.DecoratedObject decoratedObject = (ExtendedAssert.DecoratedObject)o;
                V1Property that = (V1Property)decoratedObject.getDecorated();
                String name = this.prop.getName();
                if (name != null ? !name.equals(that.getName()) : that.getName() != null) {
                    return false;
                }
                String value = this.prop.getStringValue();
                if (value != null ? !value.equals(that.getStringValue()) : that.getStringValue() != null) {
                    return false;
                }
                String lang = this.prop.getLang();
                if (lang != null ? !lang.equals(that.getLang()) : that.getLang() != null) {
                    return false;
                }
                List any = this.prop.getAny();
                return !(any == null ? that.getAny() != null : !any.equals(that.getAny()));
            }
            return false;
        }

        public String toString() {
            return new StringBuffer().append("Property: ").append(this.prop.getName()).append("=").append(this.prop.getStringValue()).append(" (").append(this.prop.getLang()).append(")").toString();
        }
    }
}

