/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationManager;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1ModifyRegistration;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v2.PropertyDescription;

@RunWith(value=Arquillian.class)
public class RegistrationTestCase
extends V1ProducerBaseTest {
    public RegistrationTestCase() throws Exception {
        super("RegistrationTestCase");
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        Archive archive = V1ProducerBaseTest.createDeployment();
        return archive;
    }

    @Override
    protected boolean removeCurrent(String archiveName) {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testUniqueNameRegistration() throws Exception {
    }

    @Test
    public void testConsumerAgent() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1RegistrationData regData = this.createBaseRegData();
        regData.setConsumerAgent("invalid consumer agent");
        try {
            this.producer.register(regData);
            ExtendedAssert.fail((String)"Trying to register with an invalid consumer agent String should fail.");
        }
        catch (V1OperationFailed v1OperationFailed) {
            // empty catch block
        }
        regData.setConsumerAgent(WSRPConstants.CONSUMER_AGENT);
        this.producer.register(regData);
    }

    public void testRegistrationHandle() throws Exception {
        try {
            V1RegistrationContext rc = this.registerConsumer();
            String registrationHandle = rc.getRegistrationHandle();
            RegistrationTestCase.assertNotNull((Object)registrationHandle);
            RegistrationManager registrationManager = this.producer.getRegistrationManager();
            Registration registration = registrationManager.getRegistration(registrationHandle);
            RegistrationTestCase.assertNotNull((Object)registration);
            String key = registration.getPersistentKey();
            RegistrationTestCase.assertNotNull((Object)key);
            String expectedHandle = registrationManager.getPolicy().createRegistrationHandleFor(key);
            RegistrationTestCase.assertEquals((String)expectedHandle, (String)registrationHandle);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("An error occured, please see the server logs for details (arquillian can't serialize this exception for output).");
        }
    }

    @Test
    public void testDeregister() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1RegistrationContext rc = this.registerConsumer();
        this.producer.deregister(rc);
        V1GetMarkup getMarkup = this.createDefaultMarkupRequest("foo");
        getMarkup.getMarkupParams().getMarkupCharacterSets().add("UTF-8");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"Consumer tried to access info with a de-registered context. Operations should fail.");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
            // empty catch block
        }
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        gs.setRegistrationContext(rc);
        try {
            this.producer.getServiceDescription(gs);
            ExtendedAssert.fail((String)"Required registration info has been modified: operations should fail until registration is modified.");
        }
        catch (V1InvalidRegistration invalidRegistrationFault) {
            // empty catch block
        }
        gs = this.getNoRegistrationServiceDescriptionRequest();
        ExtendedAssert.assertNotNull((Object)this.producer.getServiceDescription(gs));
    }

    @Test
    public void testModifyRegistration() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1RegistrationContext rc = this.registerConsumer();
        String newPropName = "New Prop";
        RegistrationPropertyDescription regProp = new RegistrationPropertyDescription(newPropName, new QName("urn:oasis:names:tc:wsrp:v1:types", "LocalizedString", "ns1"));
        regProp.setDefaultLabel("New Registration Property");
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().addRegistrationProperty(regProp);
        V1GetMarkup getMarkup = this.createDefaultMarkupRequest("foo");
        getMarkup.getMarkupParams().getMarkupCharacterSets().add("UTF-8");
        getMarkup.setRegistrationContext(rc);
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"Required registration info has been modified: operations should fail until registration is modified.");
        }
        catch (V1OperationFailed operationFailedFault) {
            // empty catch block
        }
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        gs.setRegistrationContext(rc);
        try {
            this.producer.getServiceDescription(gs);
            ExtendedAssert.fail((String)"Required registration info has been modified: operations should fail until registration is modified.");
        }
        catch (V1OperationFailed operationFailedFault) {
            // empty catch block
        }
        gs.setRegistrationContext(null);
        List pds = this.producer.getServiceDescription(gs).getRegistrationPropertyDescription().getPropertyDescriptions();
        ExtendedAssert.assertEquals((int)2, (int)pds.size());
        V1PropertyDescription description = (V1PropertyDescription)pds.get(1);
        if (description.getName().startsWith("New")) {
            RegistrationTestCase.assertEquals((Object)WSRPUtils.convertToPropertyDescription((RegistrationPropertyDescription)regProp), (Object)description);
        } else {
            PropertyDescription propertyDescription = WSRPUtils.convertToPropertyDescription((RegistrationPropertyDescription)regProp);
            V1PropertyDescription v1PropertyDescription = V2ToV1Converter.toV1PropertyDescription((PropertyDescription)propertyDescription);
            RegistrationTestCase.assertEquals(v1PropertyDescription, (V1PropertyDescription)pds.get(0));
        }
        V1RegistrationData regData = this.createBaseRegData();
        regData.getRegistrationProperties().add(WSRP1TypeFactory.createProperty((String)newPropName, (String)"en", (String)"blah"));
        V1ModifyRegistration registration = new V1ModifyRegistration();
        registration.setRegistrationContext(rc);
        registration.setRegistrationData(regData);
        this.producer.modifyRegistration(registration);
        gs.setRegistrationContext(rc);
        this.checkServiceDescriptionWithOnlyBasicPortlet(gs);
    }

    @Test
    public void testModifyRegistrationIncorrectData() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1RegistrationContext rc = this.registerConsumer();
        String newPropName = "New Prop";
        RegistrationPropertyDescription regProp = new RegistrationPropertyDescription(newPropName, new QName("urn:oasis:names:tc:wsrp:v1:types", "LocalizedString", "ns1"));
        regProp.setDefaultLabel("New Registration Property");
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().addRegistrationProperty(regProp);
        try {
            V1ModifyRegistration registration = new V1ModifyRegistration();
            registration.setRegistrationContext(rc);
            registration.setRegistrationData(this.createBaseRegData());
            this.producer.modifyRegistration(registration);
            ExtendedAssert.fail((String)"Passing incorrect data should fail");
        }
        catch (V1OperationFailed operationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testRegister() throws Exception {
        this.configureRegistrationSettings(true, false);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        V1RegistrationContext registrationContext = this.registerConsumer();
        ExtendedAssert.assertNotNull((Object)registrationContext);
        ExtendedAssert.assertNotNull((Object)registrationContext.getRegistrationHandle());
        gs.setRegistrationContext(registrationContext);
        this.checkServiceDescriptionWithOnlyBasicPortlet(gs);
    }

    @Test
    public void testRegisterWhenRegistrationNotRequired() throws Exception {
        this.configureRegistrationSettings(false, false);
        try {
            this.registerConsumer();
            ExtendedAssert.fail((String)"Shouldn't be possible to register if no registration is required.");
        }
        catch (V1OperationFailed v1OperationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testDeregisterWhenRegistrationNotRequired() throws Exception {
        this.configureRegistrationSettings(false, false);
        try {
            this.producer.deregister(null);
            ExtendedAssert.fail((String)"Shouldn't be possible to deregister if no registration is required.");
        }
        catch (V1OperationFailed v1OperationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testModifyRegistrationWhenRegistrationNotRequired() throws Exception {
        this.configureRegistrationSettings(false, false);
        try {
            this.producer.modifyRegistration(null);
            ExtendedAssert.fail((String)"Shouldn't be possible to modify registration if no registration is required.");
        }
        catch (V1OperationFailed v1OperationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testModifyRegistrationNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        try {
            this.producer.modifyRegistration(null);
            ExtendedAssert.fail((String)"Shouldn't be possible to modify registration if no registration is required.");
        }
        catch (V1OperationFailed operationFailedFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeregisterNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        try {
            this.producer.deregister(null);
            ExtendedAssert.fail((String)"Shouldn't be possible to deregister if no registration is required.");
        }
        catch (V1OperationFailed operationFailedFault) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }
}

