/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v1.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1ReleaseSessions;

@RunWith(value=Arquillian.class)
public class ReleaseSessionTestCase
extends NeedPortletHandleTest {
    private static final String DEFAULT_SESSION_PORTLET_WAR = "test-session-portlet.war";
    private static final Logger log = Logger.getLogger(ReleaseSessionTestCase.class);

    @Override
    protected String getMostUsedPortletWARFileName() {
        return DEFAULT_SESSION_PORTLET_WAR;
    }

    public ReleaseSessionTestCase() throws Exception {
        super("SessionWar", DEFAULT_SESSION_PORTLET_WAR);
        log.debug((Object)"Instantiating ReleaseSessionTestCase");
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        Archive archive = V1ProducerBaseTest.createDeployment();
        return archive;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testReleaseSession() throws Exception {
        V1RegistrationContext fakeRegContext = WSRP1TypeFactory.createRegistrationContext((String)"Fake Registration Handle");
        V1RegistrationContext[] regContexts = new V1RegistrationContext[]{null, null, fakeRegContext};
        Object nullSessionID = null;
        String fakeSessionID = "Fake Session ID";
        String[][] sessionIDs = new String[][]{{nullSessionID}, {nullSessionID, nullSessionID}, {fakeSessionID}, {fakeSessionID, fakeSessionID}, {fakeSessionID, nullSessionID}, {nullSessionID, fakeSessionID}};
        for (int i = 0; i < regContexts.length; ++i) {
            for (String[] sessionID : sessionIDs) {
                V1ReleaseSessions releaseSession = WSRP1TypeFactory.createReleaseSessions((V1RegistrationContext)regContexts[i], Arrays.asList(sessionID));
                this.releaseSessions(releaseSession, false, i);
                this.releaseSessions(releaseSession, true, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSessions(V1ReleaseSessions releaseSessions, boolean useRegistration, int index) throws Exception {
        this.setUp();
        try {
            if (useRegistration) {
                this.configureRegistrationSettings(true, false);
                if (index == 0) {
                    releaseSessions.setRegistrationContext(this.registerConsumer());
                }
            }
            log.info((Object)this.getSetupString(releaseSessions));
            this.producer.releaseSessions(releaseSessions);
            ExtendedAssert.fail((String)("ReleaseSessions did not thrown an OperationFailed Fault." + this.getSetupString(releaseSessions)));
        }
        catch (V1OperationFailed operationFailedFault) {
            operationFailedFault.printStackTrace();
        }
        finally {
            if (index == 0 && useRegistration) {
                releaseSessions.setRegistrationContext(null);
            }
            this.tearDown();
        }
    }

    private String getSetupString(V1ReleaseSessions releaseSessions) {
        StringBuffer message = new StringBuffer("ReleaseSessions Setup:\n");
        if (releaseSessions == null) {
            message.append(" ReleaseSessions : null");
        } else {
            V1RegistrationContext regContext = releaseSessions.getRegistrationContext();
            List sessionIDs = releaseSessions.getSessionIDs();
            message.append(" RegistrationContext : ").append(regContext != null ? regContext.getRegistrationHandle() : null);
            message.append(" | SessionIDs : ");
            if (sessionIDs != null) {
                for (int i = 0; i < sessionIDs.size(); ++i) {
                    message.append((String)sessionIDs.get(i)).append(i == sessionIDs.size() - 1 ? "" : ", ");
                }
            }
        }
        if (this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().isRegistrationRequired()) {
            message.append(" | with registration required.");
        }
        return message.toString();
    }
}

