/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v1.V1ProducerBaseTest;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v1.V2ToV1Converter;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1ModelDescription;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1ServiceDescription;
import org.oasis.wsrp.v2.PropertyDescription;

@RunWith(value=Arquillian.class)
public class ServiceDescriptionTestCase
extends V1ProducerBaseTest {
    public ServiceDescriptionTestCase() throws Exception {
        super("ServiceDescriptionTestCase");
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        Archive archive = V1ProducerBaseTest.createDeployment();
        return archive;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testNotRequiringRegistration() throws Throwable {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        V1ServiceDescription sd = this.checkServiceDescriptionWithOnlyBasicPortlet(gs);
        ExtendedAssert.assertFalse((boolean)sd.isRequiresRegistration());
        ExtendedAssert.assertNull((Object)sd.getRegistrationPropertyDescription());
    }

    @Test
    public void testNotRequiringRegistrationSwitching() throws Throwable {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        V1ServiceDescription sd = this.producer.getServiceDescription(gs);
        ExtendedAssert.assertFalse((boolean)sd.isRequiresRegistration());
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        gs = this.getNoRegistrationServiceDescriptionRequest();
        sd = this.producer.getServiceDescription(gs);
        ExtendedAssert.assertTrue((boolean)sd.isRequiresRegistration());
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        gs = this.getNoRegistrationServiceDescriptionRequest();
        sd = this.producer.getServiceDescription(gs);
        ExtendedAssert.assertFalse((boolean)sd.isRequiresRegistration());
    }

    @Test
    public void testRequiringRegistrationNotProvidingPortlets() throws Throwable {
        RegistrationPropertyDescription regProp = this.configureRegistrationSettings(true, false);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        V1ServiceDescription sd = this.producer.getServiceDescription(gs);
        ExtendedAssert.assertNotNull((Object)sd);
        ExtendedAssert.assertTrue((boolean)sd.isRequiresRegistration());
        this.checkRequiredRegistrationProperties(sd, regProp);
        ExtendedAssert.assertTrue((String)("Should not get any offered portlets back. Retrieved " + sd.getOfferedPortlets()), (sd.getOfferedPortlets() == null || sd.getOfferedPortlets().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testRequiringRegistrationProvidingPortlets() throws Throwable {
        RegistrationPropertyDescription regProp = this.configureRegistrationSettings(true, true);
        V1GetServiceDescription gs = this.getNoRegistrationServiceDescriptionRequest();
        V1ServiceDescription sd = this.checkServiceDescriptionWithOnlyBasicPortlet(gs);
        ExtendedAssert.assertNotNull((Object)sd);
        ExtendedAssert.assertTrue((boolean)sd.isRequiresRegistration());
        this.checkRequiredRegistrationProperties(sd, regProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLiveDeployment() throws Throwable {
        try {
            V1GetServiceDescription gsd = this.getNoRegistrationServiceDescriptionRequest();
            this.deploy("test-basic-portlet.war");
            V1ServiceDescription sd = this.producer.getServiceDescription(gsd);
            ExtendedAssert.assertEquals((int)1, (int)sd.getOfferedPortlets().size());
            this.deploy("test-markup-portlet.war");
            sd = this.producer.getServiceDescription(gsd);
            ExtendedAssert.assertEquals((int)2, (int)sd.getOfferedPortlets().size());
            this.deploy("test-session-portlet.war");
            sd = this.producer.getServiceDescription(gsd);
            ExtendedAssert.assertEquals((int)3, (int)sd.getOfferedPortlets().size());
            this.undeploy("test-markup-portlet.war");
            sd = this.producer.getServiceDescription(gsd);
            ExtendedAssert.assertEquals((int)2, (int)sd.getOfferedPortlets().size());
            this.undeploy("test-session-portlet.war");
            this.checkServiceDescriptionWithOnlyBasicPortlet(gsd);
        }
        finally {
            this.undeploy("test-basic-portlet.war");
            this.undeploy("test-markup-portlet.war");
            this.undeploy("test-session-portlet.war");
        }
    }

    private void checkRequiredRegistrationProperties(V1ServiceDescription sd, RegistrationPropertyDescription regProp) {
        V1ModelDescription registrationPropertyDescription = sd.getRegistrationPropertyDescription();
        ExtendedAssert.assertNotNull((Object)registrationPropertyDescription);
        List propertyDescriptions = registrationPropertyDescription.getPropertyDescriptions();
        ExtendedAssert.assertNotNull((Object)propertyDescriptions);
        ExtendedAssert.assertEquals((int)1, (int)propertyDescriptions.size());
        ServiceDescriptionTestCase.assertEquals(V2ToV1Converter.toV1PropertyDescription((PropertyDescription)WSRPUtils.convertToPropertyDescription((RegistrationPropertyDescription)regProp)), (V1PropertyDescription)propertyDescriptions.get(0));
    }

    @Override
    protected boolean removeCurrent(String archiveName) {
        return true;
    }
}

