/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v1;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.producer.ProducerHolder;
import org.gatein.wsrp.producer.WSRPProducer;
import org.gatein.wsrp.producer.WSRPProducerBaseTest;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.v1.WSRP1Producer;
import org.gatein.wsrp.protocol.v1.MarkupTestCase;
import org.gatein.wsrp.protocol.v1.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v1.PortletManagementTestCase;
import org.gatein.wsrp.protocol.v1.RegistrationTestCase;
import org.gatein.wsrp.protocol.v1.ReleaseSessionTestCase;
import org.gatein.wsrp.protocol.v1.ServiceDescriptionTestCase;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.ExtendedAssert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.oasis.wsrp.v1.V1GetMarkup;
import org.oasis.wsrp.v1.V1GetServiceDescription;
import org.oasis.wsrp.v1.V1InteractionParams;
import org.oasis.wsrp.v1.V1LocalizedString;
import org.oasis.wsrp.v1.V1MarkupParams;
import org.oasis.wsrp.v1.V1MarkupType;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PerformBlockingInteraction;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1PropertyDescription;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1RegistrationData;
import org.oasis.wsrp.v1.V1RuntimeContext;
import org.oasis.wsrp.v1.V1ServiceDescription;

public abstract class V1ProducerBaseTest
extends WSRPProducerBaseTest {
    private static final String CONSUMER = "test-consumer";
    private static final Function<V1PortletDescription, String> PORTLET_DESCRIPTION_TO_HANDLE = new Function<V1PortletDescription, String>(){

        public String apply(V1PortletDescription from) {
            return from.getPortletHandle();
        }
    };
    protected WSRP1Producer producer = ProducerHolder.getV1Producer();

    public V1ProducerBaseTest() throws Exception {
        this("V1ProducerBaseTest");
    }

    protected V1ProducerBaseTest(String name) throws Exception {
        super(name);
    }

    @Override
    protected WSRPProducer getProducer() {
        return this.producer;
    }

    @Override
    protected ProducerHelper getProducerHelper() {
        return this.producer;
    }

    public void checkBasicPortletDescription(V1PortletDescription desc, String handle) {
        ExtendedAssert.assertNotNull((Object)desc);
        ExtendedAssert.assertTrue((desc.getPortletHandle().length() <= 255 ? 1 : 0) != 0);
        if (handle != null) {
            ExtendedAssert.assertEquals((String)handle, (String)desc.getPortletHandle());
        }
        ExtendedAssert.assertEquals((String)"title", (String)desc.getTitle().getValue());
        List markupTypes = desc.getMarkupTypes();
        ExtendedAssert.assertEquals((int)1, (int)markupTypes.size());
        V1MarkupType markupType = (V1MarkupType)markupTypes.get(0);
        ArrayList<String> states = new ArrayList<String>(3);
        states.add("wsrp:normal");
        states.add("wsrp:maximized");
        states.add("wsrp:minimized");
        V1MarkupType expected = WSRP1TypeFactory.createMarkupType((String)"text/html", Collections.singletonList("wsrp:view"), states, Collections.singletonList("en"));
        V1ProducerBaseTest.assertEquals(expected, markupType);
    }

    protected V1ServiceDescription checkServiceDescriptionWithOnlyBasicPortlet(V1GetServiceDescription gs) throws Exception {
        this.deploy("test-basic-portlet.war");
        V1ServiceDescription sd = this.producer.getServiceDescription(gs);
        ExtendedAssert.assertNotNull((String)"sd != null", (Object)sd);
        List offeredPortlets = sd.getOfferedPortlets();
        ExtendedAssert.assertNotNull((Object)offeredPortlets);
        ExtendedAssert.assertEquals((int)1, (int)offeredPortlets.size());
        V1PortletDescription desc = (V1PortletDescription)offeredPortlets.get(0);
        this.checkBasicPortletDescription(desc, null);
        this.undeploy("test-basic-portlet.war");
        return sd;
    }

    protected V1RegistrationContext registerConsumer() throws V1OperationFailed, V1MissingParameters {
        V1RegistrationData registrationData = this.createBaseRegData();
        return this.producer.register(registrationData);
    }

    protected V1RegistrationData createBaseRegData() {
        V1RegistrationData regData = WSRP1TypeFactory.createDefaultRegistrationData();
        regData.setConsumerName(CONSUMER);
        regData.getRegistrationProperties().add(WSRP1TypeFactory.createProperty((String)"regProp", (String)"en", (String)"regValue"));
        return regData;
    }

    protected RegistrationPropertyDescription configureRegistrationSettings(boolean requiresRegistration, boolean provideUnregisteredFullDescription) {
        ProducerRegistrationRequirements registrationRequirements = this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements();
        registrationRequirements.setRegistrationRequired(requiresRegistration);
        registrationRequirements.setRegistrationRequiredForFullDescription(!provideUnregisteredFullDescription);
        if (requiresRegistration) {
            RegistrationPropertyDescription regProp = new RegistrationPropertyDescription("regProp", new QName("urn:oasis:names:tc:wsrp:v1:types", "LocalizedString", "ns1"));
            regProp.setDefaultLabel("Registration Property");
            registrationRequirements.addRegistrationProperty(regProp);
            DefaultRegistrationPolicy defaultRegistrationPolicy = new DefaultRegistrationPolicy();
            defaultRegistrationPolicy.setValidator((RegistrationPropertyValidator)new DefaultRegistrationPropertyValidator());
            registrationRequirements.setPolicy((RegistrationPolicy)defaultRegistrationPolicy);
            RegistrationManager registrationManager = this.producer.getRegistrationManager();
            registrationManager.setPolicy((RegistrationPolicy)defaultRegistrationPolicy);
            registrationRequirements.addRegistrationPropertyChangeListener((RegistrationPropertyChangeListener)registrationManager);
            try {
                registrationManager.createConsumer(CONSUMER);
            }
            catch (RegistrationException e) {
                ExtendedAssert.fail((String)("Couldn't create consumer. Cause: " + e.getLocalizedMessage()));
            }
            return regProp;
        }
        return null;
    }

    protected V1GetServiceDescription getNoRegistrationServiceDescriptionRequest() {
        V1GetServiceDescription gs = WSRP1TypeFactory.createGetServiceDescription();
        gs.getDesiredLocales().add("en-US");
        gs.getDesiredLocales().add("en");
        return gs;
    }

    protected static void assertEquals(V1MarkupType expected, V1MarkupType tested) {
        String message = "Expected: <" + expected + ">, got: <" + tested + ">. Failed on: ";
        if (expected != tested) {
            if (expected == null || tested == null) {
                ExtendedAssert.fail((String)(message + "Different classes or not both null."));
            }
            V1ProducerBaseTest.assertEquals((String)(message + "Extensions"), (Object)expected.getExtensions(), (Object)tested.getExtensions());
            V1ProducerBaseTest.assertEquals((String)(message + "Locales"), (Object)expected.getLocales(), (Object)tested.getLocales());
            V1ProducerBaseTest.assertEquals((String)(message + "Modes"), (Object)expected.getModes(), (Object)tested.getModes());
            Collections.sort(expected.getWindowStates());
            Collections.sort(tested.getWindowStates());
            V1ProducerBaseTest.assertEquals((String)(message + "Window states"), (Object)expected.getWindowStates(), (Object)tested.getWindowStates());
        }
    }

    protected static void assertEquals(V1PropertyDescription expected, V1PropertyDescription tested) {
        String message = "Expected: <" + expected + ">, got: <" + tested + ">. Failed on ";
        if (expected != tested) {
            if (expected == null || tested == null) {
                ExtendedAssert.fail((String)(message + "Different classes or not both null."));
            }
            V1ProducerBaseTest.assertEquals((String)(message + "extensions."), (Object)expected.getExtensions(), (Object)tested.getExtensions());
            V1ProducerBaseTest.assertEquals(message + "hint.", expected.getHint(), tested.getHint());
            V1ProducerBaseTest.assertEquals(message + "label.", expected.getLabel(), tested.getLabel());
            ExtendedAssert.assertEquals((String)(message + "name."), (String)expected.getName(), (String)tested.getName());
            ExtendedAssert.assertEquals((String)(message + "type."), (Object)expected.getType(), (Object)tested.getType());
        }
    }

    protected static void assertEquals(String message, V1LocalizedString expected, V1LocalizedString tested) {
        String precise = "Expected: <" + expected + ">, got: <" + tested + ">. Failed on ";
        if (expected != tested) {
            if (expected == null || tested == null) {
                ExtendedAssert.fail((String)(message + ": Different classes or not both null."));
            }
            ExtendedAssert.assertEquals((String)(precise + "lang."), (String)expected.getLang(), (String)tested.getLang());
            ExtendedAssert.assertEquals((String)(precise + "resource name."), (String)expected.getResourceName(), (String)tested.getResourceName());
            ExtendedAssert.assertEquals((String)(precise + "value."), (String)expected.getValue(), (String)tested.getValue());
        }
    }

    protected void checkException(Exception e, String errorCode) {
        Throwable cause = e.getCause();
    }

    protected V1GetMarkup createDefaultMarkupRequest(String handle) {
        V1PortletContext portletContext = WSRP1TypeFactory.createPortletContext((String)handle);
        return WSRP1TypeFactory.createMarkupRequest((V1PortletContext)portletContext, (V1RuntimeContext)this.createDefaultRuntimeContext(), (V1MarkupParams)WSRP1TypeFactory.createDefaultMarkupParams());
    }

    protected V1PerformBlockingInteraction createDefaultPerformBlockingInteraction(String handle) {
        V1PortletContext portletContext = WSRP1TypeFactory.createPortletContext((String)handle);
        return WSRP1TypeFactory.createPerformBlockingInteraction((V1PortletContext)portletContext, (V1RuntimeContext)this.createDefaultRuntimeContext(), (V1MarkupParams)WSRP1TypeFactory.createDefaultMarkupParams(), (V1InteractionParams)WSRP1TypeFactory.createDefaultInteractionParams());
    }

    protected V1RuntimeContext createDefaultRuntimeContext() {
        return WSRP1TypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"bar");
    }

    @Override
    protected Collection<String> getPortletHandles() throws Exception {
        V1GetServiceDescription getServiceDescription = WSRP1TypeFactory.createGetServiceDescription();
        V1ServiceDescription serviceDescription = this.producer.getServiceDescription(getServiceDescription);
        List offered = serviceDescription.getOfferedPortlets();
        return Collections2.transform((Collection)offered, PORTLET_DESCRIPTION_TO_HANDLE);
    }

    protected static Archive createDeployment() {
        EnterpriseArchive archive = (EnterpriseArchive)ShrinkWrap.createFromZipFile(EnterpriseArchive.class, (File)new File("target/test-archives/test-producer.ear"));
        JavaArchive testJar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClasses(new Class[]{V1ProducerBaseTest.class, WSRPProducerBaseTest.class});
        testJar = (JavaArchive)testJar.addClasses(new Class[]{MarkupTestCase.class, NeedPortletHandleTest.class, PortletManagementTestCase.class, RegistrationTestCase.class, ReleaseSessionTestCase.class, ServiceDescriptionTestCase.class});
        archive = (EnterpriseArchive)archive.addAsLibraries(new Archive[]{testJar});
        WebArchive pcWebArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"producer-test-portlet-container.war");
        pcWebArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/portlet-container-war").as(WebArchive.class));
        archive.addAsModule((Archive)pcWebArchive);
        return archive;
    }
}

