/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.wsrp.WSRPActionURL;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPRenderURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.extensions.ExtensionAccess;
import org.gatein.wsrp.api.extensions.InvocationHandlerDelegate;
import org.gatein.wsrp.api.extensions.UnmarshalledExtension;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.payload.PayloadUtils;
import org.gatein.wsrp.payload.SerializableSimplePayload;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v2.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v2.V2ProducerBaseTest;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.CacheControl;
import org.oasis.wsrp.v2.Event;
import org.oasis.wsrp.v2.EventParams;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.NavigationalContext;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.SessionParams;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UploadContext;
import org.w3c.dom.Element;

@RunWith(value=Arquillian.class)
public class MarkupTestCase
extends NeedPortletHandleTest {
    private static final String DEFAULT_VIEW_MARKUP = "<p>symbol unset stock value: value unset</p>";
    private static final String DEFAULT_MARKUP_PORTLET_WAR = "test-markup-portlet.war";

    public MarkupTestCase() throws Exception {
        super("MarkupTestCase", DEFAULT_MARKUP_PORTLET_WAR);
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        return V2ProducerBaseTest.createDeployment();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetMarkupViewNoSession() throws Exception {
        try {
            GetMarkup getMarkup = this.createMarkupRequest();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, DEFAULT_VIEW_MARKUP);
        }
        catch (Exception e) {
            System.out.println("ERROR running testGetMarkupViewNoSession");
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testGetMarkupViewWithExtensions() throws Exception {
        InvocationHandlerDelegate.registerProducerDelegate((InvocationHandlerDelegate)new InvocationHandlerDelegate(){
            private boolean success;

            public void processInvocation(PortletInvocation invocation) {
                List extensions = ExtensionAccess.getProducerExtensionAccessor().getRequestExtensionsFor(MarkupParams.class);
                Assert.assertEquals((int)1, (int)extensions.size());
                Assert.assertEquals((Object)"foo", (Object)((UnmarshalledExtension)extensions.get(0)).getValue());
                this.success = true;
            }

            public void processInvocationResponse(PortletInvocationResponse response, PortletInvocation invocation) {
                if (this.success) {
                    ExtensionAccess.getProducerExtensionAccessor().addResponseExtension(MarkupResponse.class, (Object)"bar");
                }
            }
        });
        try {
            GetMarkup getMarkup = this.createMarkupRequest();
            getMarkup.getMarkupParams().getExtensions().add(WSRPTypeFactory.createExtension((Object)PayloadUtils.marshallExtension((Object)"foo")));
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, DEFAULT_VIEW_MARKUP);
            List responseExtensions = response.getExtensions();
            MarkupTestCase.assertEquals((int)1, (int)responseExtensions.size());
            MarkupTestCase.assertEquals((Object)"bar", (Object)PayloadUtils.unmarshallExtension((Object)((Extension)responseExtensions.get(0)).getAny()).getValue());
        }
        catch (Exception e) {
            System.out.println("ERROR running testGetMarkupViewWithExtensions");
            e.printStackTrace();
            throw e;
        }
        finally {
            InvocationHandlerDelegate.registerProducerDelegate(null);
        }
    }

    @Test
    public void testInvalidGetMarkup() throws Exception {
        GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getMarkupParams().setMode("invalid mode");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail();
        }
        catch (UnsupportedMode unsupportedMode) {
            // empty catch block
        }
    }

    @Test
    public void testGetMarkupWithSessionID() throws Exception {
        GetMarkup getMarkup = this.createMarkupRequest();
        SessionParams sessionParams = WSRPTypeFactory.createSessionParams((String)"Hello World");
        getMarkup.getRuntimeContext().setSessionParams(sessionParams);
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"A sessionID should not be allowed to be passed in GetMarkup()");
        }
        catch (OperationFailed operationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testGetMarkupEditNoSession() throws Exception {
        GetMarkup getMarkup = this.createMarkupRequest();
        getMarkup.getMarkupParams().setMode("wsrp:edit");
        MarkupResponse response = this.producer.getMarkup(getMarkup);
        String namespacePrefix = getMarkup.getRuntimeContext().getNamespacePrefix();
        this.checkMarkupResponse(response, "<form method='post' action='wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite' id='" + namespacePrefix + "portfolioManager'><table><tr><td>Stock symbol</t" + "d><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupRenderParameters() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archiveName = "test-renderparam-portlet.war";
        this.deploy(archiveName);
        try {
            GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getItemString();
            String julienLink = this.extractLink(markupString, 0);
            WSRPPortletURL julienURL = WSRPPortletURL.create((String)julienLink);
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Hello, Anonymous!");
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Counter: 0");
            ExtendedAssert.assertTrue((boolean)(julienURL instanceof WSRPRenderURL));
            WSRPRenderURL julienRender = (WSRPRenderURL)julienURL;
            NavigationalContext navigationalContext = WSRPTypeFactory.createNavigationalContext((String)julienRender.getNavigationalState().getStringValue(), null);
            gm.getMarkupParams().setNavigationalContext(navigationalContext);
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getItemString();
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Hello, Julien!");
            WSRPPortletURL incrementURL = WSRPPortletURL.create((String)this.extractLink(markupString, julienLink.length() * 2));
            ExtendedAssert.assertTrue((boolean)(incrementURL instanceof WSRPActionURL));
            WSRPActionURL incrementAction = (WSRPActionURL)incrementURL;
            PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
            interactionParams.setInteractionState(incrementAction.getInteractionState().getStringValue());
            this.producer.performBlockingInteraction(performBlockingInteraction);
            res = this.producer.getMarkup(gm);
            markupString = res.getMarkupContext().getItemString();
            ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"Counter: 1");
        }
        finally {
            this.undeploy(archiveName);
        }
    }

    private String extractLink(String markupString, int fromIndex) {
        int urlStartIndex = markupString.indexOf("='", fromIndex);
        int urlEndIndex = markupString.indexOf("'>", urlStartIndex);
        return markupString.substring(urlStartIndex + 2, urlEndIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupSession() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String sessionPortletArchive = "test-session-portlet.war";
        this.deploy(sessionPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponseWithSession(response, 0);
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponseWithSession(response, 1);
        }
        finally {
            this.undeploy(sessionPortletArchive);
        }
    }

    @Test
    public void testPerformBlockingInteractionNoRedirect() throws Exception {
        this.checkPBIAndGetNavigationalState("RHAT");
    }

    @Test
    public void testPerformBlockingInteractionRedirect() throws Exception {
        PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getDefaultHandle());
        InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        NamedString namedString = WSRPTypeFactory.createNamedString((String)"symbol", (String)"HELP");
        interactionParams.getFormParameters().add(namedString);
        BlockingInteractionResponse response = this.producer.performBlockingInteraction(performBlockingInteraction);
        ExtendedAssert.assertNotNull((Object)response);
        String redirectURL = response.getRedirectURL();
        ExtendedAssert.assertNotNull((Object)redirectURL);
        ExtendedAssert.assertEquals((String)"/WEB-INF/jsp/help.jsp", (String)redirectURL);
        UpdateResponse updateResponse = response.getUpdateResponse();
        ExtendedAssert.assertNull((Object)updateResponse);
    }

    @Test
    public void testPerformBlockingInteractionWithExtensions() throws Exception {
        InvocationHandlerDelegate.registerProducerDelegate((InvocationHandlerDelegate)new InvocationHandlerDelegate(){
            private boolean success;

            public void processInvocation(PortletInvocation invocation) {
                List extensions = ExtensionAccess.getProducerExtensionAccessor().getRequestExtensionsFor(InteractionParams.class);
                Assert.assertEquals((int)1, (int)extensions.size());
                Assert.assertEquals((Object)"foo", (Object)((UnmarshalledExtension)extensions.get(0)).getValue());
                this.success = true;
            }

            public void processInvocationResponse(PortletInvocationResponse response, PortletInvocation invocation) {
                if (this.success) {
                    ExtensionAccess.getProducerExtensionAccessor().addResponseExtension(BlockingInteractionResponse.class, (Object)"bar");
                }
            }
        });
        try {
            PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getDefaultHandle());
            InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
            interactionParams.getExtensions().add(WSRPTypeFactory.createExtension((Object)PayloadUtils.marshallExtension((Object)"foo")));
            NamedString namedString = WSRPTypeFactory.createNamedString((String)"symbol", (String)"RHT");
            interactionParams.getFormParameters().add(namedString);
            BlockingInteractionResponse interactionResponse = this.producer.performBlockingInteraction(performBlockingInteraction);
            MarkupTestCase.assertNotNull((Object)interactionResponse);
            List responseExtensions = interactionResponse.getExtensions();
            MarkupTestCase.assertEquals((int)1, (int)responseExtensions.size());
            MarkupTestCase.assertEquals((Object)"bar", (Object)PayloadUtils.unmarshallExtension((Object)((Extension)responseExtensions.get(0)).getAny()).getValue());
        }
        catch (Exception e) {
            System.out.println("ERROR running testPerformBlockingInteractionWithExtensions");
            e.printStackTrace();
            throw e;
        }
        finally {
            InvocationHandlerDelegate.registerProducerDelegate(null);
        }
    }

    @Test
    public void testGMAndPBIInteraction() throws Exception {
        this.testGetMarkupViewNoSession();
        String symbol = "AAPL";
        String navigationalState = this.checkPBIAndGetNavigationalState(symbol);
        GetMarkup getMarkup = this.createMarkupRequest();
        NavigationalContext navigationalContext = WSRPTypeFactory.createNavigationalContextOrNull((StateString)StateString.create((String)navigationalState), null);
        getMarkup.getMarkupParams().setNavigationalContext(navigationalContext);
        MarkupResponse response = this.producer.getMarkup(getMarkup);
        this.checkMarkupResponse(response, "<p>" + symbol + " stock value: 123.45</p>");
    }

    @Test
    public void testPBIWithSessionID() throws Exception {
        String portletHandle = this.getDefaultHandle();
        PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(portletHandle);
        RuntimeContext runtimeContext = performBlockingInteraction.getRuntimeContext();
        SessionParams sessionParams = WSRPTypeFactory.createSessionParams((String)"Hello World");
        runtimeContext.setSessionParams(sessionParams);
        try {
            this.producer.performBlockingInteraction(performBlockingInteraction);
            ExtendedAssert.fail((String)"Should not be able to pass a sessionID in a PerformBlockingInteraction()");
        }
        catch (OperationFailed expected) {
            // empty catch block
        }
    }

    @Test
    public void testMarkupCaching() throws Exception {
        GetMarkup getMarkup = this.createMarkupRequest();
        MarkupResponse response = this.producer.getMarkup(getMarkup);
        CacheControl cacheControl = response.getMarkupContext().getCacheControl();
        ExtendedAssert.assertNotNull((Object)cacheControl);
        ExtendedAssert.assertEquals((String)"wsrp:perUser", (String)cacheControl.getUserScope());
        ExtendedAssert.assertEquals((int)15, (int)cacheControl.getExpires());
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String sessionPortletArchive = "test-session-portlet.war";
        this.deploy(sessionPortletArchive);
        response = this.producer.getMarkup(this.createMarkupRequestForCurrentlyDeployedPortlet());
        cacheControl = response.getMarkupContext().getCacheControl();
        ExtendedAssert.assertNull((Object)cacheControl);
        this.undeploy(sessionPortletArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithDispatcherPortlet() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String dispatcherPortletArchive = "test-dispatcher-portlet.war";
        this.deploy(dispatcherPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "test");
        }
        finally {
            this.undeploy(dispatcherPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNoContent() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String basicPortletArchive = "test-basic-portlet.war";
        this.deploy(basicPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "");
        }
        finally {
            this.undeploy(basicPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithProperties() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String basicPortletArchive = "test-basic-portlet.war";
        this.deploy(basicPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            List clientAttributes = response.getMarkupContext().getClientAttributes();
            MarkupTestCase.assertEquals((int)2, (int)clientAttributes.size());
            int pass = 0;
            for (NamedString attribute : clientAttributes) {
                String name = attribute.getName();
                String value = attribute.getValue();
                if ("prop".equals(name)) {
                    MarkupTestCase.assertEquals((String)"propValue", (String)value);
                    ++pass;
                }
                if (!"javax.portlet.markup.head.element".equals(name)) continue;
                Element element = PayloadUtils.parseFromXMLString((String)value);
                MarkupTestCase.assertEquals((String)"style", (String)element.getTagName());
                MarkupTestCase.assertEquals((String)"bar", (String)element.getAttribute("foo"));
                ++pass;
            }
            MarkupTestCase.assertEquals((int)2, (int)pass);
        }
        finally {
            this.undeploy(basicPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNonStandardLocalesStrictMode() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
        getMarkup.getMarkupParams().getLocales().clear();
        getMarkup.getMarkupParams().getLocales().add("en_US");
        try {
            this.producer.getMarkup(getMarkup);
            ExtendedAssert.fail((String)"Should have thrown an exception");
        }
        catch (UnsupportedLocale unsupportedLocale) {
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    @Test
    public void testGetMarkupWithNonStandardLocalesLenientMode() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
        getMarkup.getMarkupParams().getLocales().clear();
        getMarkup.getMarkupParams().getLocales().add("en_US");
        this.producer.usingStrictModeChangedTo(false);
        this.checkMarkupResponse(this.producer.getMarkup(getMarkup), Locale.US.getDisplayName());
        this.undeploy(getLocalesPortletArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithoutDeclaredLocale() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        GetMarkup getMarkup = this.createMarkupRequest(this.getPortletHandleFrom("No Declared"));
        try {
            this.checkMarkupResponse(this.producer.getMarkup(getMarkup), Locale.getDefault().getDisplayName());
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupLocales() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String getLocalesPortletArchive = "test-getlocales-portlet.war";
        this.deploy(getLocalesPortletArchive);
        GetMarkup getMarkup = this.createMarkupRequest(this.getPortletHandleFrom("Simple"));
        try {
            List locales = getMarkup.getMarkupParams().getLocales();
            locales.clear();
            locales.add("en");
            locales.add("fr");
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.ENGLISH.getDisplayName());
            locales.clear();
            locales.add("fr");
            locales.add("en");
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.FRENCH.getDisplayName());
            locales.clear();
            locales.add("de");
            locales.add("en");
            response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, Locale.ENGLISH.getDisplayName());
        }
        finally {
            this.undeploy(getLocalesPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithEncodedURLs() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String encodeURLPortletArchive = "test-encodeurl-portlet.war";
        this.deploy(encodeURLPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite\nwsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewrite");
        }
        finally {
            this.undeploy(encodeURLPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithUserContext() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String userContextPortletArchive = "test-usercontext-portlet.war";
        this.deploy(userContextPortletArchive);
        try {
            GetMarkup getMarkup = this.createMarkupRequestForCurrentlyDeployedPortlet();
            getMarkup.setUserContext(WSRPTypeFactory.createUserContext((String)"johndoe"));
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "user: null");
        }
        finally {
            this.undeploy(userContextPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupMultiValuedFormParams() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String multiValuedPortletArchive = "test-multivalued-portlet.war";
        this.deploy(multiValuedPortletArchive);
        NamedString namedString = this.createNamedString("multi", "value1");
        try {
            PerformBlockingInteraction action = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            List formParameters = action.getInteractionParams().getFormParameters();
            formParameters.add(namedString);
            BlockingInteractionResponse actionResponse = this.producer.performBlockingInteraction(action);
            GetMarkup markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalContext(actionResponse.getUpdateResponse().getNavigationalContext());
            MarkupResponse response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: value1");
            formParameters.clear();
            formParameters.add(namedString);
            formParameters.add(this.createNamedString("multi", "value2"));
            actionResponse = this.producer.performBlockingInteraction(action);
            markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalContext(actionResponse.getUpdateResponse().getNavigationalContext());
            response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: value1, value2");
            formParameters.clear();
            formParameters.add(WSRPTypeFactory.createNamedString((String)"test", null));
            actionResponse = this.producer.performBlockingInteraction(action);
            markupRequest = this.createMarkupRequestForCurrentlyDeployedPortlet();
            markupRequest.getMarkupParams().setNavigationalContext(actionResponse.getUpdateResponse().getNavigationalContext());
            response = this.producer.getMarkup(markupRequest);
            this.checkMarkupResponse(response, "multi: ");
        }
        finally {
            this.undeploy(multiValuedPortletArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImplicitCloning() throws Exception {
        try {
            this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
            String archiveName = "test-implicitcloning-portlet.war";
            this.deploy(archiveName);
            try {
                GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
                MarkupResponse res = this.producer.getMarkup(gm);
                String markupString = res.getMarkupContext().getItemString();
                ExtendedAssert.assertEquals((String)"initial", (String)markupString);
                PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
                pbi.getInteractionParams().setPortletStateChange(StateChange.CLONE_BEFORE_WRITE);
                String value = "new value";
                pbi.getInteractionParams().getFormParameters().add(this.createNamedString("value", value));
                BlockingInteractionResponse response = this.producer.performBlockingInteraction(pbi);
                ExtendedAssert.assertNotNull((Object)response);
                PortletContext pc = response.getUpdateResponse().getPortletContext();
                ExtendedAssert.assertNotNull((Object)pc);
                res = this.producer.getMarkup(gm);
                markupString = res.getMarkupContext().getItemString();
                ExtendedAssert.assertEquals((String)"initial", (String)markupString);
                gm.setPortletContext(pc);
                res = this.producer.getMarkup(gm);
                markupString = res.getMarkupContext().getItemString();
                ExtendedAssert.assertEquals((String)value, (String)markupString);
            }
            finally {
                this.undeploy(archiveName);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR during " + ((Object)((Object)this)).getClass() + " testImplicitCloning");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithResource() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resource-portlet.war";
        this.deploy(archive);
        try {
            GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getItemString();
            String markupStart = "<img src='wsrp_rewrite?wsrp-urlType=resource&amp;wsrp-url=http%3A%2F%2F";
            String markupEnd = "%3A8080%2Ftest-resource-portlet%2Fgif%2Flogo.gif&amp;wsrp-requiresRewrite=true/wsrp_rewrite'/>";
            String localhostMarkup = markupStart + "localhost" + markupEnd;
            String homeIPMarkup = markupStart + "127.0.0.1" + markupEnd;
            boolean result = localhostMarkup.equals(markupString) || homeIPMarkup.equals(markupString);
            ExtendedAssert.assertTrue((String)("Expectd '" + localhostMarkup + "' or '" + homeIPMarkup + "' but received '" + markupString + "'."), (boolean)result);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithNonURLEncodedResource() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resourcenoencodeurl-portlet.war";
        this.deploy(archive);
        try {
            GetMarkup gm = this.createMarkupRequestForCurrentlyDeployedPortlet();
            MarkupResponse res = this.producer.getMarkup(gm);
            String markupString = res.getMarkupContext().getItemString();
            String markupStart = "<img src='http://";
            String markupEnd = ":8080/test-resourcenoencodeurl-portlet/gif/logo.gif'/>";
            String localhostMarkup = markupStart + "localhost" + markupEnd;
            String homeIPMarkup = markupStart + "127.0.0.1" + markupEnd;
            boolean result = localhostMarkup.equals(markupString) || homeIPMarkup.equals(markupString);
            ExtendedAssert.assertTrue((String)("Expectd '" + localhostMarkup + "' or '" + homeIPMarkup + "' but received '" + markupString + "'."), (boolean)result);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplicationScopeVariableHandling() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-applicationscope-portlet.war";
        this.deploy(archive);
        try {
            PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getPortletHandleFrom("Set"));
            pbi.getInteractionParams().getFormParameters().add(this.createNamedString("appVar", "value"));
            this.producer.performBlockingInteraction(pbi);
            GetMarkup gm = this.createMarkupRequest(this.getPortletHandleFrom("Get"));
            MarkupResponse res = this.producer.getMarkup(gm);
            this.checkMarkupResponse(res, "appVar=value");
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithSimpleEvent() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-events-portlet.war";
        this.deploy(archive);
        NamedString namedString = this.createNamedString("parameter", "param-value");
        try {
            List<String> handles = this.getHandlesForCurrentlyDeployedArchive();
            String generatorHandle = null;
            String consumerHandle = null;
            for (String portletHandle : handles) {
                if (portletHandle.contains("Generator")) {
                    generatorHandle = portletHandle;
                    continue;
                }
                if (!portletHandle.contains("Consumer")) continue;
                consumerHandle = portletHandle;
            }
            PerformBlockingInteraction action = this.createDefaultPerformBlockingInteraction(generatorHandle);
            List formParameters = action.getInteractionParams().getFormParameters();
            formParameters.add(namedString);
            BlockingInteractionResponse actionResponse = this.producer.performBlockingInteraction(action);
            List events = actionResponse.getUpdateResponse().getEvents();
            MarkupTestCase.assertNotNull((Object)events);
            MarkupTestCase.assertEquals((int)1, (int)events.size());
            Event event = (Event)events.get(0);
            MarkupTestCase.assertEquals((Object)new QName("urn:jboss:gatein:samples:event", "eventsample"), (Object)event.getName());
            MarkupTestCase.assertEquals((Object)WSRPConstants.XSD_STRING, (Object)event.getType());
            Serializable serializable = PayloadUtils.getPayloadAsSerializable((Event)event);
            MarkupTestCase.assertTrue((boolean)(serializable instanceof SerializableSimplePayload));
            MarkupTestCase.assertEquals((Object)"param-value", (Object)((SerializableSimplePayload)serializable).getPayload());
            HandleEvents handleEvents = WSRPTypeFactory.createHandleEvents(null, (PortletContext)WSRPTypeFactory.createPortletContext((String)consumerHandle), (RuntimeContext)this.createDefaultRuntimeContext(), null, (MarkupParams)this.createDefaultMarkupParams(), (EventParams)WSRPTypeFactory.createEventParams((List)events, (StateChange)StateChange.READ_ONLY));
            HandleEventsResponse handleEventsResponse = this.producer.handleEvents(handleEvents);
            List failedEvents = handleEventsResponse.getFailedEvents();
            MarkupTestCase.assertEquals((int)0, (int)failedEvents.size());
            GetMarkup markupRequestConsumer = this.createMarkupRequest(consumerHandle);
            markupRequestConsumer.getMarkupParams().setNavigationalContext(handleEventsResponse.getUpdateResponse().getNavigationalContext());
            MarkupResponse response = this.producer.getMarkup(markupRequestConsumer);
            this.checkMarkupResponse(response, "param-value", false, true);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithPublicRenderParameter() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-prp-portlet.war";
        this.deploy(archive);
        NamedString namedString = this.createNamedString("parameter", "param-value-prp");
        try {
            List<String> handles = this.getHandlesForCurrentlyDeployedArchive();
            String generatorHandle = null;
            String consumerHandle = null;
            for (String portletHandle : handles) {
                if (portletHandle.contains("Generator")) {
                    generatorHandle = portletHandle;
                    continue;
                }
                if (!portletHandle.contains("Consumer")) continue;
                consumerHandle = portletHandle;
            }
            PerformBlockingInteraction action = this.createDefaultPerformBlockingInteraction(generatorHandle);
            List formParameters = action.getInteractionParams().getFormParameters();
            formParameters.add(namedString);
            BlockingInteractionResponse actionResponse = this.producer.performBlockingInteraction(action);
            GetMarkup markupRequestConsumer = this.createMarkupRequest(consumerHandle);
            markupRequestConsumer.getMarkupParams().setNavigationalContext(actionResponse.getUpdateResponse().getNavigationalContext());
            MarkupResponse response = this.producer.getMarkup(markupRequestConsumer);
            this.checkMarkupResponse(response, "param-value-prp", false, true);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithDefaultPortletModes() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-portletmodes-portlet.war";
        this.deploy(archive);
        try {
            GetMarkup getMarkup = this.createMarkupRequest();
            getMarkup.getMarkupParams().setMode("wsrp:edit");
            MarkupTestCase.assertEquals((String)"wsrp:edit", (String)getMarkup.getMarkupParams().getMode());
            MarkupResponse responseEdit = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(responseEdit, "This is EDIT MODE.", false, true);
            getMarkup.getMarkupParams().setMode("wsrp:view");
            MarkupTestCase.assertEquals((String)"wsrp:view", (String)getMarkup.getMarkupParams().getMode());
            MarkupResponse responseView = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(responseView, "This is VIEW MODE.", false, true);
            getMarkup.getMarkupParams().setMode("wsrp:help");
            MarkupTestCase.assertEquals((String)"wsrp:help", (String)getMarkup.getMarkupParams().getMode());
            MarkupResponse responseHelp = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(responseHelp, "This is HELP MODE.", false, true);
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMarkupWithCustomPortletMode() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-portletmodes-portlet.war";
        this.deploy(archive);
        try {
            GetMarkup getMarkup = this.createMarkupRequest();
            getMarkup.getMarkupParams().setMode("test_mode");
            MarkupTestCase.assertEquals((String)"test_mode", (String)getMarkup.getMarkupParams().getMode());
            MarkupResponse response = this.producer.getMarkup(getMarkup);
            this.checkMarkupResponse(response, "This is TEST MODE.", false, true);
        }
        finally {
            this.undeploy(archive);
        }
    }

    @Test
    public void testGetMarkupNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        GetMarkup gm = this.createMarkupRequest();
        try {
            this.producer.getMarkup(gm);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPerformBlockingInteractionNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
        try {
            this.producer.performBlockingInteraction(pbi);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInitCookieNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        InitCookie initCookie = WSRPTypeFactory.createInitCookie(null);
        try {
            this.producer.initCookie(initCookie);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResourceNoRegistrationWhenRegistrationRequired() throws Exception {
        this.configureRegistrationSettings(true, false);
        GetResource getResource = this.createGetResource(DEFAULT_MARKUP_PORTLET_WAR, "foo");
        try {
            this.producer.getResource(getResource);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetMarkupRegistrationWhenNoneRequired() throws Exception {
        this.configureRegistrationSettings(false, true);
        GetMarkup gm = this.createMarkupRequest();
        gm.setRegistrationContext(WSRPTypeFactory.createRegistrationContext((String)"foo"));
        try {
            this.producer.getMarkup(gm);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPerformBlockingInteractionRegistrationWhenNoneRequired() throws Exception {
        this.configureRegistrationSettings(false, true);
        PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
        pbi.setRegistrationContext(WSRPTypeFactory.createRegistrationContext((String)"foo"));
        try {
            this.producer.performBlockingInteraction(pbi);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInitCookieRegistrationWhenNoneRequired() throws Exception {
        this.configureRegistrationSettings(false, true);
        InitCookie initCookie = WSRPTypeFactory.createInitCookie(null);
        initCookie.setRegistrationContext(WSRPTypeFactory.createRegistrationContext((String)"foo"));
        try {
            this.producer.initCookie(initCookie);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetResourceRegistrationWhenNoneRequired() throws Exception {
        this.configureRegistrationSettings(false, true);
        GetResource getResource = this.createGetResource(DEFAULT_MARKUP_PORTLET_WAR, "foo");
        getResource.setRegistrationContext(WSRPTypeFactory.createRegistrationContext((String)"foo"));
        try {
            this.producer.getResource(getResource);
            ExtendedAssert.fail((String)"Should have thrown InvalidRegistration!");
        }
        catch (InvalidRegistration invalidRegistration) {
        }
        catch (Exception e) {
            ExtendedAssert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResource() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resource-portlet.war";
        this.deploy(archive);
        try {
            GetResource getResource = this.createGetResource(archive, "resourceFromWriter");
            ResourceResponse response = this.producer.getResource(getResource);
            MarkupTestCase.assertEquals((String)"image/png", (String)response.getResourceContext().getMimeType());
            MarkupTestCase.assertNull((Object)response.getResourceContext().getItemBinary());
            MarkupTestCase.assertEquals((String)"foo", (String)response.getResourceContext().getItemString());
            getResource = this.createGetResource(archive, "resourceFromStream");
            response = this.producer.getResource(getResource);
            MarkupTestCase.assertEquals((String)"image/png", (String)response.getResourceContext().getMimeType());
            byte[] expected = new byte[]{0, 1, 2, 3, 4};
            byte[] actual = response.getResourceContext().getItemBinary();
            MarkupTestCase.assertEquals((int)expected.length, (int)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                MarkupTestCase.assertEquals((byte)expected[i], (byte)actual[i]);
            }
            MarkupTestCase.assertNull((Object)response.getResourceContext().getItemString());
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResourceUpload() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resource-portlet.war";
        this.deploy(archive);
        try {
            byte[] uploadedBytes = new byte[]{0, 1, 2, 3, 4};
            GetResource getResource = this.createGetResource(archive, "uploaded");
            UploadContext uploadContext = WSRPTypeFactory.createUploadContext((String)"image/png", (byte[])uploadedBytes);
            getResource.getResourceParams().getUploadContexts().add(uploadContext);
            ResourceResponse response = this.producer.getResource(getResource);
            MarkupTestCase.assertEquals((String)"image/png", (String)response.getResourceContext().getMimeType());
            byte[] actual = response.getResourceContext().getItemBinary();
            MarkupTestCase.assertEquals((int)uploadedBytes.length, (int)actual.length);
            for (int i = 0; i < uploadedBytes.length; ++i) {
                MarkupTestCase.assertEquals((byte)uploadedBytes[i], (byte)actual[i]);
            }
            MarkupTestCase.assertNull((Object)response.getResourceContext().getItemString());
        }
        finally {
            this.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPBIResourceUpload() throws Exception {
        this.undeploy(DEFAULT_MARKUP_PORTLET_WAR);
        String archive = "test-resource-portlet.war";
        this.deploy(archive);
        try {
            byte[] uploadedBytes = new byte[]{0, 1, 2, 3, 4};
            PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(this.getHandleForCurrentlyDeployedArchive());
            UploadContext uploadContext = WSRPTypeFactory.createUploadContext((String)"image/png", (byte[])uploadedBytes);
            pbi.getInteractionParams().getUploadContexts().add(uploadContext);
            pbi.getInteractionParams().getFormParameters().add(this.createNamedString("javax.portlet.action", "uploadImage"));
            this.producer.performBlockingInteraction(pbi);
        }
        finally {
            this.undeploy(archive);
        }
    }

    private String checkPBIAndGetNavigationalState(String symbol) throws Exception {
        PerformBlockingInteraction performBlockingInteraction = this.createDefaultPerformBlockingInteraction(this.getDefaultHandle());
        InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        interactionParams.getFormParameters().add(this.createNamedString("symbol", symbol));
        BlockingInteractionResponse response = this.producer.performBlockingInteraction(performBlockingInteraction);
        ExtendedAssert.assertNotNull((Object)response);
        ExtendedAssert.assertNull((Object)response.getRedirectURL());
        UpdateResponse updateResponse = response.getUpdateResponse();
        ExtendedAssert.assertNotNull((Object)updateResponse);
        ExtendedAssert.assertNull((Object)updateResponse.getPortletContext());
        ExtendedAssert.assertNull((Object)updateResponse.getSessionContext());
        String navigationalState = updateResponse.getNavigationalContext().getOpaqueValue();
        ExtendedAssert.assertNotNull((Object)navigationalState);
        ExtendedAssert.assertEquals((String)updateResponse.getNewMode(), (String)"wsrp:view");
        MarkupContext markupContext = updateResponse.getMarkupContext();
        ExtendedAssert.assertNull((Object)markupContext);
        return navigationalState;
    }

    private void checkMarkupResponseWithSession(MarkupResponse response, int count) throws RemoteException, InvalidRegistration, OperationFailed {
        ExtendedAssert.assertNotNull((Object)response);
        MarkupContext markupContext = response.getMarkupContext();
        ExtendedAssert.assertNotNull((Object)markupContext);
        String markupString = markupContext.getItemString();
        ExtendedAssert.assertString1ContainsString2((String)markupString, (String)("count = " + count));
        ExtendedAssert.assertString1ContainsString2((String)markupString, (String)"<a href='wsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewrite'>render</a>");
        this.checkSessionForCurrentlyDeployedPortlet(response);
    }

    private MarkupContext checkMarkupResponse(MarkupResponse response, String markupString) {
        return this.checkMarkupResponse(response, markupString, true, false);
    }

    private MarkupContext checkMarkupResponse(MarkupResponse response, String markupString, boolean checkTitle, boolean partialMarkupMatch) {
        MarkupTestCase.assertNotNull((Object)response);
        MarkupContext markupContext = response.getMarkupContext();
        MarkupTestCase.assertNotNull((Object)markupContext);
        MarkupTestCase.assertEquals((String)"text/html", (String)markupContext.getMimeType());
        if (checkTitle) {
            MarkupTestCase.assertEquals((String)"title", (String)markupContext.getPreferredTitle());
        }
        if (!ParameterValidation.isNullOrEmpty((String)markupString)) {
            MarkupTestCase.assertTrue((boolean)markupContext.isRequiresRewriting());
        } else {
            MarkupTestCase.assertFalse((boolean)markupContext.isRequiresRewriting());
        }
        if (!partialMarkupMatch) {
            MarkupTestCase.assertEquals((String)markupString, (String)markupContext.getItemString());
        } else {
            MarkupTestCase.assertTrue((boolean)markupContext.getItemString().contains(markupString));
        }
        SessionContext sessionContext = response.getSessionContext();
        MarkupTestCase.assertNull((Object)sessionContext);
        return markupContext;
    }

    private NamedString createNamedString(String name, String value) {
        NamedString namedString = WSRPTypeFactory.createNamedString((String)name, (String)value);
        return namedString;
    }

    @Override
    protected String getMostUsedPortletWARFileName() {
        return DEFAULT_MARKUP_PORTLET_WAR;
    }
}

