/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.rmi.RemoteException;
import java.util.List;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.protocol.v2.V2ProducerBaseTest;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.StateChange;

public abstract class NeedPortletHandleTest
extends V2ProducerBaseTest {
    private String mostUsedPortletWARFileName;

    public NeedPortletHandleTest(String portletWARFileName) throws Exception {
        this("NeedPortletHandleTest", portletWARFileName);
        this.mostUsedPortletWARFileName = portletWARFileName;
    }

    protected NeedPortletHandleTest(String name, String portletWARFileName) throws Exception {
        super(name);
        this.mostUsedPortletWARFileName = portletWARFileName;
    }

    protected String getDefaultHandle() {
        return this.getFirstHandleFor(this.mostUsedPortletWARFileName);
    }

    private String getFirstHandleFor(String archiveName) {
        return (String)((List)this.war2Handles.get(archiveName)).get(0);
    }

    protected String getHandleForCurrentlyDeployedArchive() {
        return this.getFirstHandleFor(this.currentlyDeployedArchiveName);
    }

    protected List<String> getHandlesForCurrentlyDeployedArchive() {
        return (List)this.war2Handles.get(this.currentlyDeployedArchiveName);
    }

    @Override
    protected boolean removeCurrent(String archiveName) {
        return !this.mostUsedPortletWARFileName.equals(archiveName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mostUsedPortletWARFileName = this.getMostUsedPortletWARFileName();
        this.deploy(this.mostUsedPortletWARFileName);
        this.producer.usingStrictModeChangedTo(true);
    }

    protected abstract String getMostUsedPortletWARFileName();

    @Override
    public void tearDown() throws Exception {
        this.undeploy(this.mostUsedPortletWARFileName);
        super.tearDown();
    }

    protected GetMarkup createMarkupRequestForCurrentlyDeployedPortlet() throws Exception {
        return this.createMarkupRequest(this.getHandleForCurrentlyDeployedArchive());
    }

    protected GetMarkup createMarkupRequest(String handle) throws RemoteException, InvalidRegistration, OperationFailed {
        GetMarkup getMarkup = this.createDefaultGetMarkup(handle);
        getMarkup.getMarkupParams().getMarkupCharacterSets().add("UTF-8");
        return getMarkup;
    }

    protected GetMarkup createDefaultGetMarkup(String handle) {
        PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)handle);
        RuntimeContext runtimeContext = this.createDefaultRuntimeContext();
        return WSRPTypeFactory.createGetMarkup(null, (PortletContext)portletContext, (RuntimeContext)runtimeContext, null, (MarkupParams)this.createDefaultMarkupParams());
    }

    protected PerformBlockingInteraction createDefaultPerformBlockingInteraction(String handle) {
        PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)handle);
        return WSRPTypeFactory.createPerformBlockingInteraction(null, (PortletContext)portletContext, (RuntimeContext)this.createDefaultRuntimeContext(), null, (MarkupParams)this.createDefaultMarkupParams(), (InteractionParams)this.createDefaultInteractionParams());
    }

    protected GetResource createGetResource(String archiveName, String resourceID) {
        PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)this.getFirstHandleFor(archiveName));
        RuntimeContext runtimeContext = this.createDefaultRuntimeContext();
        return WSRPTypeFactory.createGetResource(null, (PortletContext)portletContext, (RuntimeContext)runtimeContext, null, (ResourceParams)this.createResourceParams(resourceID));
    }

    protected ResourceParams createResourceParams(String resourceID) {
        return WSRPTypeFactory.createDefaultResourceParams((String)resourceID);
    }

    protected InteractionParams createDefaultInteractionParams() {
        return WSRPTypeFactory.createInteractionParams((StateChange)StateChange.READ_ONLY);
    }

    protected RuntimeContext createDefaultRuntimeContext() {
        return WSRPTypeFactory.createRuntimeContext((String)"wsrp:none", (String)"foo", (String)"ns");
    }

    protected MarkupParams createDefaultMarkupParams() {
        return WSRPTypeFactory.createMarkupParams((boolean)false, (List)WSRPConstants.getDefaultLocales(), (List)WSRPConstants.getDefaultMimeTypes(), (String)"wsrp:view", (String)"wsrp:normal");
    }

    protected String getPortletHandleFrom(String partialHandle) {
        List<String> handles = this.getHandlesForCurrentlyDeployedArchive();
        for (String handle : handles) {
            if (!handle.contains(partialHandle)) continue;
            return handle;
        }
        throw new IllegalArgumentException("Couldn't find a portlet handle matching '" + partialHandle + "' in " + this.currentlyDeployedArchiveName);
    }

    protected GetMarkup createMarkupRequest() throws Exception {
        return this.createMarkupRequestForCurrentlyDeployedPortlet();
    }

    protected void checkSessionForCurrentlyDeployedPortlet(MarkupResponse response) throws RemoteException, InvalidRegistration, OperationFailed {
    }
}

