/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.exports.ExportPersistenceManager;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportPortletData;
import org.gatein.exports.data.PersistedExportData;
import org.gatein.exports.impl.ExportManagerImpl;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.state.SimplePropertyMap;
import org.gatein.pc.portlet.state.producer.PortletState;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v2.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v2.V2ProducerBaseTest;
import org.gatein.wsrp.support.TestMockExportPersistenceManager;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.ClonePortlet;
import org.oasis.wsrp.v2.CopiedPortlet;
import org.oasis.wsrp.v2.CopyPortlets;
import org.oasis.wsrp.v2.CopyPortletsResponse;
import org.oasis.wsrp.v2.ExportPortlets;
import org.oasis.wsrp.v2.ExportPortletsResponse;
import org.oasis.wsrp.v2.ExportedPortlet;
import org.oasis.wsrp.v2.FailedPortlets;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.ImportPortlet;
import org.oasis.wsrp.v2.ImportPortlets;
import org.oasis.wsrp.v2.ImportPortletsFailed;
import org.oasis.wsrp.v2.ImportPortletsResponse;
import org.oasis.wsrp.v2.ImportedPortlet;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.ReleaseExport;
import org.oasis.wsrp.v2.SetExportLifetime;
import org.oasis.wsrp.v2.StateChange;
import org.oasis.wsrp.v2.UserContext;

@RunWith(value=Arquillian.class)
public class PortletManagementTestCase
extends NeedPortletHandleTest {
    private static final String TEST_BASIC_PORTLET_WAR = "test-markup-portlet.war";

    public PortletManagementTestCase() throws Exception {
        super("PortletManagementTestCase", TEST_BASIC_PORTLET_WAR);
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        return V2ProducerBaseTest.createDeployment();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testExport() throws Exception {
        try {
            String handle = this.getDefaultHandle();
            List<PortletContext> portletContexts = this.createPortletContextList(handle);
            ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            this.checkValidHandle(response, handle);
        }
        catch (Exception e) {
            System.out.println("An exception occurred when running testExport");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void testExportNonExistentHandle() throws Exception {
        String nonExistentHandle = "123FakeHandle";
        List<PortletContext> portletContexts = this.createPortletContextList(nonExistentHandle);
        ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
        ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
        this.checkInvalidHandle(response, nonExistentHandle);
    }

    @Test
    public void testExportNoRegistrationWhenRequired() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
        try {
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            PortletManagementTestCase.fail((String)"ExportPortlets should fail if registration is required and none is provided");
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testExportBadRegistrationHandle() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)"foo123");
        List<PortletContext> portletContexts = this.createPortletContextList(this.getDefaultHandle());
        boolean exportByValueRequired = true;
        Lifetime lifetime = null;
        UserContext userContext = null;
        ExportPortlets exportPortlets = WSRPTypeFactory.createExportPortlets((RegistrationContext)registrationContext, portletContexts, userContext, lifetime, (Boolean)exportByValueRequired);
        try {
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            PortletManagementTestCase.fail((String)"ExportPortlets should fail if registration is required and an invalid registration handle is provided");
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testExportRegistrationRequired() throws Exception {
        try {
            this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
            RegistrationData registrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMER", (String)"CONSUMERAGENT.0.0", (boolean)true);
            RegistrationContext registrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationData, null, null));
            List<PortletContext> portletContexts = this.createPortletContextList(this.getDefaultHandle());
            boolean exportByValueRequired = true;
            Lifetime lifetime = null;
            UserContext userContext = null;
            ExportPortlets exportPortlets = WSRPTypeFactory.createExportPortlets((RegistrationContext)registrationContext, portletContexts, userContext, lifetime, (Boolean)exportByValueRequired);
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            this.checkValidHandle(response, this.getDefaultHandle());
        }
        catch (Exception e) {
            System.out.println("An exception occured calling " + ((Object)((Object)this)).getClass() + " testExportRegistrationRequired");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void testExportNullExportContext() throws Exception {
        ExportPortlets exportPortlets = new ExportPortlets();
        try {
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            PortletManagementTestCase.fail((String)"Should have thrown a MissingParameters fault if no portlets passed for export.");
        }
        catch (MissingParameters missingParameters) {
            // empty catch block
        }
    }

    @Test
    public void testExportNullExportPortlets() throws Exception {
        try {
            ExportPortletsResponse response = this.producer.exportPortlets(null);
            PortletManagementTestCase.fail((String)"Should have failed if sending a null exportPortlet object");
        }
        catch (MissingParameters missingParameters) {
            // empty catch block
        }
    }

    @Test
    public void testExports() throws Exception {
        String nonExistentHandle = "123FakeHandle";
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(nonExistentHandle, handle);
        ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
        ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
        PortletManagementTestCase.assertNotNull((Object)response.getExportContext());
        PortletManagementTestCase.assertNull((Object)response.getLifetime());
        PortletManagementTestCase.assertFalse((boolean)response.getExportedPortlet().isEmpty());
        PortletManagementTestCase.assertFalse((boolean)response.getFailedPortlets().isEmpty());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getExportedPortlet().size());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getFailedPortlets().size());
        ExportedPortlet exportPortlet = (ExportedPortlet)response.getExportedPortlet().get(0);
        PortletManagementTestCase.assertEquals((String)handle, (String)exportPortlet.getPortletHandle());
        FailedPortlets failedPortlets = (FailedPortlets)response.getFailedPortlets().get(0);
        PortletManagementTestCase.assertEquals((String)"InvalidHandle", (String)failedPortlets.getErrorCode().getLocalPart());
        PortletManagementTestCase.assertEquals((int)1, (int)failedPortlets.getPortletHandles().size());
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getPortletHandles().contains(nonExistentHandle));
    }

    protected void checkInvalidHandle(ExportPortletsResponse response, String handle) throws Exception {
        PortletManagementTestCase.assertNotNull((Object)response.getExportContext());
        PortletManagementTestCase.assertNull((Object)response.getLifetime());
        PortletManagementTestCase.assertTrue((boolean)response.getExportedPortlet().isEmpty());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getFailedPortlets().size());
        FailedPortlets failedPortlet = (FailedPortlets)response.getFailedPortlets().get(0);
        PortletManagementTestCase.assertTrue((boolean)failedPortlet.getPortletHandles().contains(handle));
        PortletManagementTestCase.assertEquals((String)"InvalidHandle", (String)failedPortlet.getErrorCode().getLocalPart());
    }

    protected void checkValidHandle(ExportPortletsResponse response, String handle) throws Exception {
        PortletManagementTestCase.assertNotNull((Object)response.getExportContext());
        PortletManagementTestCase.assertNull((Object)response.getLifetime());
        PortletManagementTestCase.assertTrue((boolean)response.getFailedPortlets().isEmpty());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getExportedPortlet().size());
        ExportedPortlet exportPortlet = (ExportedPortlet)response.getExportedPortlet().get(0);
        PortletManagementTestCase.assertEquals((String)handle, (String)exportPortlet.getPortletHandle());
    }

    protected List<PortletContext> createPortletContextList(String ... portletHandles) {
        ArrayList<PortletContext> portletContexts = new ArrayList<PortletContext>();
        for (String portletHandle : portletHandles) {
            PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)portletHandle);
            portletContexts.add(portletContext);
        }
        return portletContexts;
    }

    protected ExportPortlets createSimpleExportPortlets(List<PortletContext> portletContexts) {
        boolean exportByValueRequired = true;
        Lifetime lifetime = null;
        UserContext userContext = null;
        RegistrationContext registrationContext = null;
        return WSRPTypeFactory.createExportPortlets(registrationContext, portletContexts, userContext, lifetime, (Boolean)exportByValueRequired);
    }

    @Test
    public void testImport() throws Exception {
        String importID = "foo";
        ArrayList<String> portletList = new ArrayList<String>();
        portletList.add(this.getDefaultHandle());
        byte[] importContext = new ExportContext().encodeAsBytes();
        ImportPortlet importPortlet = this.createSimpleImportPortlet(importID, this.getDefaultHandle());
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertEquals((int)1, (int)response.getImportedPortlets().size());
        ImportedPortlet portlet = (ImportedPortlet)response.getImportedPortlets().get(0);
        PortletManagementTestCase.assertEquals((String)importID, (String)portlet.getImportID());
        PortletContext portletContext = portlet.getNewPortletContext();
        GetMarkup markup = this.createMarkupRequest(portletContext.getPortletHandle());
        MarkupResponse markupResponse = this.producer.getMarkup(markup);
        PortletManagementTestCase.assertNotNull((Object)markupResponse.getMarkupContext());
        PortletManagementTestCase.assertEquals((String)"<p>symbol unset stock value: value unset</p>", (String)new String(markupResponse.getMarkupContext().getItemString()));
    }

    @Test
    public void testImportNoRegistrationWhenRequired() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        String importID = "foo";
        ArrayList<String> portletList = new ArrayList<String>();
        portletList.add(this.getDefaultHandle());
        byte[] importContext = new ExportContext().encodeAsBytes();
        ImportPortlet importPortlet = this.createSimpleImportPortlet(importID, this.getDefaultHandle());
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        try {
            ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
            PortletManagementTestCase.fail((String)"ImportPortlets should fail if registration is required and non is provided");
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testImportRegistrationRequired() throws Exception {
        try {
            this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
            RegistrationData registrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMER", (String)"CONSUMERAGENT.0.0", (boolean)true);
            RegistrationContext registrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationData, null, null));
            String importID = "foo";
            Lifetime lifetime = null;
            UserContext userContext = null;
            ArrayList<String> portletList = new ArrayList<String>();
            portletList.add(this.getDefaultHandle());
            ExportContext exportContextData = new ExportContext();
            byte[] importContext = exportContextData.encodeAsBytes();
            ImportPortlet importPortlet = this.createSimpleImportPortlet(importID, this.getDefaultHandle());
            List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
            ImportPortlets importPortlets = WSRPTypeFactory.createImportPortlets((RegistrationContext)registrationContext, (byte[])importContext, importPortletsList, userContext, lifetime);
            ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
            PortletManagementTestCase.assertEquals((int)1, (int)response.getImportedPortlets().size());
            ImportedPortlet portlet = (ImportedPortlet)response.getImportedPortlets().get(0);
            PortletManagementTestCase.assertEquals((String)importID, (String)portlet.getImportID());
            PortletContext portletContext = portlet.getNewPortletContext();
            GetMarkup markup = this.createMarkupRequest(portletContext.getPortletHandle());
            markup.setRegistrationContext(registrationContext);
            MarkupResponse markupResponse = this.producer.getMarkup(markup);
            PortletManagementTestCase.assertNotNull((Object)markupResponse.getMarkupContext());
            PortletManagementTestCase.assertEquals((String)"<p>symbol unset stock value: value unset</p>", (String)new String(markupResponse.getMarkupContext().getItemString()));
        }
        catch (Exception e) {
            System.out.println("An exception occured calling " + ((Object)((Object)this)).getClass() + " testImportRegistrationRequired");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void testImportBadRegistration() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)"FAkeREgistrationHAndle");
        String importID = "foo";
        Lifetime lifetime = null;
        UserContext userContext = null;
        ArrayList<String> portletList = new ArrayList<String>();
        portletList.add(this.getDefaultHandle());
        ExportContext exportContextData = new ExportContext();
        byte[] importContext = exportContextData.encodeAsBytes();
        ImportPortlet importPortlet = this.createSimpleImportPortlet(importID, this.getDefaultHandle());
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = WSRPTypeFactory.createImportPortlets((RegistrationContext)registrationContext, (byte[])importContext, importPortletsList, userContext, lifetime);
        try {
            ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
            PortletManagementTestCase.fail((String)"Should have failed when registration is required and an invalid registration handle is used.");
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testImportNullImportContext() throws Exception {
        String importId = "importInvalidPortletContext";
        ImportPortlet importPortlet = this.createSimpleImportPortlet(importId, this.getDefaultHandle());
        byte[] importContext = null;
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        try {
            this.producer.importPortlets(importPortlets);
            PortletManagementTestCase.fail((String)"Should have thrown an OperationFailedFault");
        }
        catch (OperationFailed e) {
            // empty catch block
        }
    }

    @Test
    public void testImportInvalidImportContext() throws Exception {
        String importId = "importInvalidPortletContext";
        ImportPortlet importPortlet = this.createSimpleImportPortlet(importId, this.getDefaultHandle());
        byte[] importContext = new byte[]{1, 2, 3, 102, 97, 107, 101};
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        try {
            this.producer.importPortlets(importPortlets);
            PortletManagementTestCase.fail((String)"Should have thrown an OperationFailedFault");
        }
        catch (OperationFailed e) {
            // empty catch block
        }
    }

    @Test
    public void testImportNullExportData() throws Exception {
        String importId = "nullExportData";
        ImportPortlet importPortlet = new ImportPortlet();
        importPortlet.setExportData(null);
        importPortlet.setImportID(importId);
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        byte[] importContext = new ExportContext().encodeAsBytes();
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertNotNull((Object)response.getImportFailed());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getImportFailed().size());
        PortletManagementTestCase.assertEquals((String)importId, (String)((String)((ImportPortletsFailed)response.getImportFailed().get(0)).getImportID().get(0)));
        PortletManagementTestCase.assertEquals((String)"OperationFailed", (String)((ImportPortletsFailed)response.getImportFailed().get(0)).getErrorCode().getLocalPart());
    }

    @Test
    public void testImportInvalidExportData() throws Exception {
        String importId = "invalidExportData";
        ImportPortlet importPortlet = new ImportPortlet();
        importPortlet.setExportData("fake_export_data_123".getBytes());
        importPortlet.setImportID(importId);
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ExportContext exportContextData = new ExportContext();
        byte[] importContext = exportContextData.encodeAsBytes();
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertNotNull((Object)response.getImportFailed());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getImportFailed().size());
        PortletManagementTestCase.assertEquals((String)importId, (String)((String)((ImportPortletsFailed)response.getImportFailed().get(0)).getImportID().get(0)));
        PortletManagementTestCase.assertEquals((String)"OperationFailed", (String)((ImportPortletsFailed)response.getImportFailed().get(0)).getErrorCode().getLocalPart());
    }

    @Test
    public void testImportNonExistantPortletData() throws Exception {
        String importId = "invalidExportData";
        ExportManagerImpl exportManager = new ExportManagerImpl();
        ExportPortletData exportPortletData = exportManager.createExportPortletData(null, "non_existant_portlet_handle", null);
        byte[] exportData = exportPortletData.encodeAsBytes();
        ImportPortlet importPortlet = WSRPTypeFactory.createImportPortlet((String)importId, (byte[])exportData);
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ExportContext exportContextData = new ExportContext();
        byte[] importContext = exportContextData.encodeAsBytes();
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertNotNull((Object)response.getImportFailed());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getImportFailed().size());
        PortletManagementTestCase.assertEquals((String)importId, (String)((String)((ImportPortletsFailed)response.getImportFailed().get(0)).getImportID().get(0)));
        PortletManagementTestCase.assertEquals((String)"InvalidHandle", (String)((ImportPortletsFailed)response.getImportFailed().get(0)).getErrorCode().getLocalPart());
    }

    @Test
    public void testImports() throws Exception {
        String importID = "foo";
        String nullImportID = "null";
        String invalidImportID = "invalid";
        ExportManagerImpl exportManager = new ExportManagerImpl();
        ExportPortletData exportPortletData = exportManager.createExportPortletData(null, this.getDefaultHandle(), null);
        byte[] exportData = exportPortletData.encodeAsBytes();
        byte[] nullExportData = null;
        ExportPortletData invalidExportPortletData = exportManager.createExportPortletData(null, "InvalidHandle", null);
        byte[] invalidExportData = invalidExportPortletData.encodeAsBytes();
        Lifetime lifetime = null;
        UserContext userContext = null;
        RegistrationContext registrationContext = null;
        ArrayList<String> portletList = new ArrayList<String>();
        portletList.add(this.getDefaultHandle());
        ExportContext exportContextData = new ExportContext();
        byte[] importContext = exportContextData.encodeAsBytes();
        ImportPortlet nullPortlet = new ImportPortlet();
        nullPortlet.setImportID(nullImportID);
        nullPortlet.setExportData(nullExportData);
        ImportPortlet importPortlet = WSRPTypeFactory.createImportPortlet((String)importID, (byte[])exportData);
        ImportPortlet invalidPortlet = WSRPTypeFactory.createImportPortlet((String)invalidImportID, (byte[])invalidExportData);
        ArrayList<ImportPortlet> importPortletsList = new ArrayList<ImportPortlet>();
        importPortletsList.add(invalidPortlet);
        importPortletsList.add(importPortlet);
        importPortletsList.add(nullPortlet);
        ImportPortlets importPortlets = WSRPTypeFactory.createImportPortlets(registrationContext, (byte[])importContext, importPortletsList, userContext, lifetime);
        ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertEquals((int)2, (int)response.getImportFailed().size());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getImportedPortlets().size());
        ImportedPortlet portlet = (ImportedPortlet)response.getImportedPortlets().get(0);
        PortletManagementTestCase.assertEquals((String)importID, (String)portlet.getImportID());
        PortletContext portletContext = portlet.getNewPortletContext();
        GetMarkup markup = this.createMarkupRequest(portletContext.getPortletHandle());
        MarkupResponse markupResponse = this.producer.getMarkup(markup);
        PortletManagementTestCase.assertNotNull((Object)markupResponse.getMarkupContext());
        PortletManagementTestCase.assertEquals((String)"<p>symbol unset stock value: value unset</p>", (String)markupResponse.getMarkupContext().getItemString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportWithState() throws Exception {
        try {
            this.undeploy(TEST_BASIC_PORTLET_WAR);
            String sessionPortletArchive = "test-portletstate-portlet.war";
            this.deploy(sessionPortletArchive);
            try {
                String originalHandle = this.getHandleForCurrentlyDeployedArchive();
                this.checkStatePortlet(originalHandle, "initial");
                PortletContext portletContext = this.performBlockingInteractionOnSessionPortlet(originalHandle, "new value", StateChange.CLONE_BEFORE_WRITE);
                PortletManagementTestCase.assertFalse((boolean)originalHandle.equals(portletContext.getPortletHandle()));
                this.checkStatePortlet(portletContext.getPortletHandle(), "new value");
                List<PortletContext> portletContexts = this.createPortletContextList(portletContext.getPortletHandle());
                ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
                ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
                PortletManagementTestCase.assertFalse((boolean)response.getExportedPortlet().isEmpty());
                List<PortletContext> portletContextsFromExport = this.getPortletContext(response);
                PortletManagementTestCase.assertNotNull((Object)portletContextsFromExport.isEmpty());
                PortletManagementTestCase.assertEquals((int)1, (int)portletContexts.size());
                PortletContext portletContextFromExport = portletContextsFromExport.get(0);
                PortletManagementTestCase.assertEquals((String)originalHandle, (String)portletContextFromExport.getPortletHandle());
                PortletManagementTestCase.assertNotNull((Object)portletContextFromExport.getPortletState());
                ImportPortletsResponse importResponse = this.createImportPortletsResponse("foo", portletContextFromExport);
                PortletManagementTestCase.assertEquals((int)1, (int)importResponse.getImportedPortlets().size());
                this.checkStatePortlet(((ImportedPortlet)importResponse.getImportedPortlets().get(0)).getNewPortletContext().getPortletHandle(), "new value");
            }
            finally {
                this.undeploy(sessionPortletArchive);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: an error occured " + ((Object)((Object)this)).getClass() + " testExportWithState");
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportWithState() throws Exception {
        this.undeploy(TEST_BASIC_PORTLET_WAR);
        String sessionPortletArchive = "test-portletstate-portlet.war";
        this.deploy(sessionPortletArchive);
        try {
            String importStringValue = "import value";
            byte[] portletState = this.createSessionByteValue(this.getHandleForCurrentlyDeployedArchive(), importStringValue);
            String importID = "foo";
            ArrayList<String> portletList = new ArrayList<String>();
            portletList.add(this.getDefaultHandle());
            byte[] importContext = new ExportContext().encodeAsBytes();
            ExportPortletData exportPortletData = new ExportPortletData(this.getHandleForCurrentlyDeployedArchive(), portletState);
            byte[] exportData = exportPortletData.encodeAsBytes();
            ImportPortlet importPortlet = WSRPTypeFactory.createImportPortlet((String)importID, (byte[])exportData);
            List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
            ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
            ImportPortletsResponse response = this.producer.importPortlets(importPortlets);
            ImportedPortlet importedPortlet = (ImportedPortlet)response.getImportedPortlets().get(0);
            PortletManagementTestCase.assertNotSame((Object)this.getHandleForCurrentlyDeployedArchive(), (Object)importedPortlet.getNewPortletContext().getPortletHandle());
            PortletManagementTestCase.assertNull((Object)importedPortlet.getNewPortletContext().getPortletState());
            this.checkStatePortlet(importedPortlet.getNewPortletContext().getPortletHandle(), importStringValue);
        }
        finally {
            this.undeploy(sessionPortletArchive);
        }
    }

    protected ImportPortletsResponse createImportPortletsResponse(String importID, PortletContext portletContext) throws Exception {
        byte[] importContext = new ExportContext().encodeAsBytes();
        ExportPortletData exportPortletData = new ExportPortletData(portletContext.getPortletHandle(), portletContext.getPortletState());
        byte[] exportData = exportPortletData.encodeAsBytes();
        ImportPortlet importPortlet = WSRPTypeFactory.createImportPortlet((String)importID, (byte[])exportData);
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(importContext, importPortletsList);
        return this.producer.importPortlets(importPortlets);
    }

    protected byte[] createSessionByteValue(String portletHandle, String value) throws Exception {
        HashMap properties = new HashMap();
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        properties.put("name", values);
        SimplePropertyMap property = new SimplePropertyMap(properties);
        PortletState sstate = new PortletState(portletHandle, (PropertyMap)property);
        StateConverterV0 stateConverter = new StateConverterV0();
        return (byte[])stateConverter.marshall(PortletStateType.OPAQUE, sstate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportWithoutSession() throws Exception {
        this.undeploy(TEST_BASIC_PORTLET_WAR);
        String sessionPortletArchive = "test-portletstate-portlet.war";
        this.deploy(sessionPortletArchive);
        try {
            String originalHandle = this.getHandleForCurrentlyDeployedArchive();
            this.checkStatePortlet(originalHandle, "initial");
            List<PortletContext> portletContexts = this.createPortletContextList(originalHandle);
            ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
            ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
            PortletManagementTestCase.assertFalse((boolean)response.getExportedPortlet().isEmpty());
            List<PortletContext> portletContextsFromExport = this.getPortletContext(response);
            PortletManagementTestCase.assertNotNull((Object)portletContextsFromExport.isEmpty());
            PortletManagementTestCase.assertEquals((int)1, (int)portletContexts.size());
            PortletContext portletContextFromExport = portletContextsFromExport.get(0);
            PortletManagementTestCase.assertEquals((String)originalHandle, (String)portletContextFromExport.getPortletHandle());
        }
        finally {
            this.undeploy(sessionPortletArchive);
        }
    }

    @Test
    public void testReleaseExportsThrowsNoErrors() throws Exception {
        this.producer.releaseExport(null);
        ReleaseExport releaseExport = new ReleaseExport();
        this.producer.releaseExport(releaseExport);
        releaseExport = new ReleaseExport();
        releaseExport.setExportContext(new byte[]{-12, 12, 25, 21, 53});
        this.producer.releaseExport(releaseExport);
        releaseExport = new ReleaseExport();
        RegistrationContext registrationContext = new RegistrationContext();
        registrationContext.setRegistrationHandle("badRegistrationHandle");
        releaseExport.setRegistrationContext(registrationContext);
        this.producer.releaseExport(releaseExport);
        releaseExport = new ReleaseExport();
        UserContext userContext = new UserContext();
        userContext.setUserContextKey("baduckey");
        releaseExport.setUserContext(userContext);
        this.producer.releaseExport(releaseExport);
    }

    @Test
    public void testReleaseExportsNoErrorsRequiresRegistraion() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        this.testReleaseExportsThrowsNoErrors();
    }

    @Test
    public void testExportPortletPM() throws Exception {
        this.exportPortletToPM();
    }

    @Test
    public void testReleaseExportPM() throws Exception {
        ExportPortletsResponse response = this.exportPortletToPM();
        ReleaseExport releaseExport = WSRPTypeFactory.createReleaseExport(null, (byte[])response.getExportContext(), null);
        this.producer.releaseExport(releaseExport);
        TestMockExportPersistenceManager persistenceManager = (TestMockExportPersistenceManager)this.producer.getExportManager().getPersistenceManager();
        PortletManagementTestCase.assertEquals((int)0, (int)persistenceManager.getExportContextKeys().size());
        PortletManagementTestCase.assertEquals((int)0, (int)persistenceManager.getExportPortletsKeys().size());
    }

    @Test
    public void testImportPortletPM() throws Exception {
        ExportPortletsResponse response = this.exportPortletToPM();
        String importID = "foo";
        ImportPortlet importPortlet = WSRPTypeFactory.createImportPortlet((String)importID, (byte[])((ExportedPortlet)response.getExportedPortlet().get(0)).getExportData());
        List<ImportPortlet> importPortletsList = this.createImportPortletList(importPortlet);
        ImportPortlets importPortlets = this.createSimpleImportPortlets(response.getExportContext(), importPortletsList);
        ImportPortletsResponse importResponse = this.producer.importPortlets(importPortlets);
        PortletManagementTestCase.assertEquals((int)1, (int)importResponse.getImportedPortlets().size());
        PortletManagementTestCase.assertEquals((String)importID, (String)((ImportedPortlet)importResponse.getImportedPortlets().get(0)).getImportID());
        PortletManagementTestCase.assertNotNull((Object)((ImportedPortlet)importResponse.getImportedPortlets().get(0)).getNewPortletContext().getPortletHandle());
    }

    protected ExportPortletsResponse exportPortletToPM() throws Exception {
        TestMockExportPersistenceManager persistenceManager = new TestMockExportPersistenceManager();
        this.producer.getExportManager().setPersistenceManager((ExportPersistenceManager)persistenceManager);
        ((ExportManagerImpl)this.producer.getExportManager()).setPreferExportByValue(false);
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
        exportPortlets.setExportByValueRequired(Boolean.valueOf(false));
        PortletManagementTestCase.assertEquals((int)0, (int)persistenceManager.getExportContextKeys().size());
        PortletManagementTestCase.assertEquals((int)0, (int)persistenceManager.getExportPortletsKeys().size());
        ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
        PortletManagementTestCase.assertEquals((int)1, (int)persistenceManager.getExportContextKeys().size());
        PortletManagementTestCase.assertEquals((int)1, (int)persistenceManager.getExportPortletsKeys().size());
        return response;
    }

    @Test
    public void testSetExportLifetimeNull() throws Exception {
        try {
            this.producer.setExportLifetime(null);
            PortletManagementTestCase.fail();
        }
        catch (OperationFailed operationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testSetExportLifetimeInvalidExportContext() throws Exception {
        try {
            SetExportLifetime setExportLifetime = WSRPTypeFactory.createSetExportLifetime(null, (byte[])new byte[]{-10, 24, 24, 54, 97, 102, 103}, null, null);
            this.producer.setExportLifetime(setExportLifetime);
            PortletManagementTestCase.fail();
        }
        catch (OperationFailed operationFailed) {
            // empty catch block
        }
    }

    @Test
    public void testSetExport() throws Exception {
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        ExportPortlets exportPortlets = this.createSimpleExportPortlets(portletContexts);
        ExportPortletsResponse response = this.producer.exportPortlets(exportPortlets);
        try {
            PersistedExportData exportData = new PersistedExportData("foo", "bar");
            SetExportLifetime setExportLifetime = WSRPTypeFactory.createSetExportLifetime(null, (byte[])exportData.encodeAsBytes(), null, null);
            this.producer.setExportLifetime(setExportLifetime);
            PortletManagementTestCase.fail();
        }
        catch (OperationFailed e) {
            // empty catch block
        }
    }

    protected List<PortletContext> getPortletContext(ExportPortletsResponse exportPortletsResponse) throws Exception {
        ArrayList<PortletContext> portletContexts = new ArrayList<PortletContext>();
        ExportManagerImpl exportManager = new ExportManagerImpl();
        ExportContext exportContext = exportManager.createExportContext(exportPortletsResponse.getExportContext());
        List exportedPortlets = exportPortletsResponse.getExportedPortlet();
        for (ExportedPortlet exportPortlet : exportedPortlets) {
            ExportPortletData exportPortletData;
            Lifetime lifetime = exportPortletsResponse.getLifetime();
            if (lifetime != null) {
                long currentTime = lifetime.getCurrentTime().toGregorianCalendar().getTime().getTime();
                long terminationTime = lifetime.getTerminationTime().toGregorianCalendar().getTime().getTime();
                long refreshDuration = lifetime.getRefreshDuration().getTimeInMillis(lifetime.getCurrentTime().toGregorianCalendar());
                exportPortletData = exportManager.createExportPortletData(exportContext, currentTime, terminationTime, refreshDuration, exportPortlet.getExportData());
            } else {
                exportPortletData = exportManager.createExportPortletData(exportContext, -1L, -1L, -1L, exportPortlet.getExportData());
            }
            String portletHandle = exportPortletData.getPortletHandle();
            byte[] portletState = exportPortletData.getPortletState();
            portletContexts.add(WSRPTypeFactory.createPortletContext((String)portletHandle, (byte[])portletState));
        }
        return portletContexts;
    }

    protected void checkStatePortlet(String handle, String expectedValue) throws Exception {
        GetMarkup getMarkupOriginalStateless = this.createMarkupRequest(handle);
        MarkupResponse responseOriginalStateless = this.producer.getMarkup(getMarkupOriginalStateless);
        PortletManagementTestCase.assertEquals((String)expectedValue, (String)responseOriginalStateless.getMarkupContext().getItemString());
    }

    protected PortletContext performBlockingInteractionOnSessionPortlet(String handle, String value, StateChange stateChange) throws Exception {
        PerformBlockingInteraction pbi = this.createDefaultPerformBlockingInteraction(handle);
        pbi.getInteractionParams().setPortletStateChange(stateChange);
        NamedString namedString = WSRPTypeFactory.createNamedString((String)"value", (String)value);
        pbi.getInteractionParams().getFormParameters().add(namedString);
        BlockingInteractionResponse response = this.producer.performBlockingInteraction(pbi);
        PortletContext portletContext = response.getUpdateResponse().getPortletContext();
        return portletContext;
    }

    protected ImportPortlet createSimpleImportPortlet(String importId, String handle) throws IOException {
        ExportPortletData exportPortletData = new ExportPortletData(handle, null);
        byte[] exportData = exportPortletData.encodeAsBytes();
        return WSRPTypeFactory.createImportPortlet((String)importId, (byte[])exportData);
    }

    protected List<ImportPortlet> createImportPortletList(ImportPortlet ... importPortlets) {
        ArrayList<ImportPortlet> importPortletList = new ArrayList<ImportPortlet>();
        for (ImportPortlet importPortlet : importPortlets) {
            importPortletList.add(importPortlet);
        }
        return importPortletList;
    }

    protected ImportPortlets createSimpleImportPortlets(byte[] importContext, List<ImportPortlet> importPortletsList) {
        Lifetime lifetime = null;
        UserContext userContext = null;
        RegistrationContext registrationContext = null;
        return WSRPTypeFactory.createImportPortlets(registrationContext, (byte[])importContext, importPortletsList, userContext, lifetime);
    }

    @Test
    public void testSimpleCopyPortletNullRegistrations() throws Exception {
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
        this.checkSimpleCopyPortletsResponse(response, this.createStringList(handle), this.createStringList(new String[0]));
        this.checkDefaultMarkup(((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle(), null);
    }

    @Test
    public void testSimpleCopyPortletFromRegistrationNull() throws Exception {
        try {
            RegistrationData toRegistrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMERB", (String)"CONSUMERAGENTB.0.0", (boolean)true);
            RegistrationContext toRegistrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)toRegistrationData, null, null));
            String handle = this.getDefaultHandle();
            List<PortletContext> portletContexts = this.createPortletContextList(handle);
            CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
            copyPortlets.setToRegistrationContext(toRegistrationContext);
            CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
            this.checkSimpleCopyPortletsResponse(response, this.createStringList(handle), this.createStringList(new String[0]));
            this.checkDefaultMarkup(((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle(), toRegistrationContext);
            try {
                this.checkDefaultMarkup(((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle(), null);
                PortletManagementTestCase.fail((String)"The null registration context should not be able to access this portlet");
            }
            catch (InvalidHandle e) {}
        }
        catch (Exception e) {
            System.out.println("ERROR: An exception occurred when running testSimpleCopyPortletFromRegistrationNull");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    @Test
    public void testSimpleCopyPortletToRegistrationNull() throws Exception {
        RegistrationData fromRegistrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMERA", (String)"CONSUMERAGENAT.0.0", (boolean)true);
        RegistrationContext fromRegistrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)fromRegistrationData, null, null));
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        copyPortlets.setFromRegistrationContext(fromRegistrationContext);
        CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
        this.checkSimpleCopyPortletsResponse(response, this.createStringList(handle), this.createStringList(new String[0]));
        this.checkDefaultMarkup(((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle(), fromRegistrationContext);
        try {
            this.checkDefaultMarkup(((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle(), null);
            PortletManagementTestCase.fail((String)"The null registration context should not be able to access this portlet");
        }
        catch (InvalidHandle e) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleCopyPortletWithRegistrations() throws Exception {
        RegistrationData fromRegistrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMERA", (String)"CONSUMERAGENTA.0.0", (boolean)true);
        RegistrationContext fromRegistrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)fromRegistrationData, null, null));
        RegistrationData toRegistrationData = WSRPTypeFactory.createRegistrationData((String)"CONSUMERB", (String)"CONSUMERAGENTB.0.0", (boolean)true);
        RegistrationContext toRegistrationContext = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)toRegistrationData, null, null));
        String handle = this.getDefaultHandle();
        List<PortletContext> portletContexts = this.createPortletContextList(handle);
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        copyPortlets.setFromRegistrationContext(fromRegistrationContext);
        copyPortlets.setToRegistrationContext(toRegistrationContext);
        CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
        this.checkSimpleCopyPortletsResponse(response, this.createStringList(handle), this.createStringList(new String[0]));
        String portletHandle = ((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle();
        this.checkDefaultMarkup(portletHandle, toRegistrationContext);
        try {
            this.checkDefaultMarkup(portletHandle, fromRegistrationContext);
            PortletManagementTestCase.fail((String)"The original registration context should not be able to access this portlet");
        }
        catch (InvalidHandle e) {
            // empty catch block
        }
        try {
            this.checkDefaultMarkup(portletHandle, null);
            PortletManagementTestCase.fail((String)"The null registration context should not be able to access this portlet");
        }
        catch (InvalidHandle e) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletNullRegistrationWithRR() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        List<PortletContext> portletContexts = this.createPortletContextList(this.getDefaultHandle());
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        try {
            this.producer.copyPortlets(copyPortlets);
            PortletManagementTestCase.fail((String)"Should not be allowed to call copy portlets without a registration if a registration is requried");
        }
        catch (InvalidRegistration invalidRegistration) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletNonRegisteredToRegistration() throws Exception {
        RegistrationContext invalidRegistrationContext = WSRPTypeFactory.createRegistrationContext((String)"non_registered_handle");
        List<PortletContext> portletContexts = this.createPortletContextList(this.getDefaultHandle());
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        copyPortlets.setToRegistrationContext(invalidRegistrationContext);
        try {
            this.producer.copyPortlets(copyPortlets);
            PortletManagementTestCase.fail();
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletNonRegisteredFromRegistration() throws Exception {
        RegistrationContext invalidRegistrationContext = WSRPTypeFactory.createRegistrationContext((String)"non_registered_handle");
        List<PortletContext> portletContexts = this.createPortletContextList(this.getDefaultHandle());
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        copyPortlets.setFromRegistrationContext(invalidRegistrationContext);
        try {
            this.producer.copyPortlets(copyPortlets);
            PortletManagementTestCase.fail();
        }
        catch (InvalidRegistration e) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletNullPortletContexts() throws Exception {
        Object portletContexts = null;
        CopyPortlets copyPortlets = new CopyPortlets();
        try {
            this.producer.copyPortlets(copyPortlets);
            PortletManagementTestCase.fail();
        }
        catch (MissingParameters missingParameters) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletsEmptyPortletContexts() throws Exception {
        ArrayList portletContexts = new ArrayList();
        CopyPortlets copyPortlets = new CopyPortlets();
        copyPortlets.getFromPortletContexts().addAll(portletContexts);
        try {
            this.producer.copyPortlets(copyPortlets);
            PortletManagementTestCase.fail();
        }
        catch (MissingParameters missingParameters) {
            // empty catch block
        }
    }

    @Test
    public void testCopyPortletsInvalidPortletContexts() throws Exception {
        String fakePortletContext1 = "fakePortletContext1";
        String fakePortletContext2 = "fakePortletContext2";
        List<PortletContext> portletContexts = this.createPortletContextList(fakePortletContext1, fakePortletContext2);
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
        PortletManagementTestCase.assertEquals((int)0, (int)response.getCopiedPortlets().size());
        PortletManagementTestCase.assertEquals((int)1, (int)response.getFailedPortlets().size());
        FailedPortlets failedPortlets = (FailedPortlets)response.getFailedPortlets().get(0);
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getPortletHandles().contains(fakePortletContext1));
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getPortletHandles().contains(fakePortletContext2));
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getErrorCode().getLocalPart().contains("InvalidHandle"));
    }

    @Test
    public void testCopyPortletsMixedPortletContexts() throws Exception {
        String fakePortletContext1 = "fakePortletContext1";
        String fakePortletContext2 = "fakePortletContext2";
        List<PortletContext> portletContexts = this.createPortletContextList(fakePortletContext1, this.getDefaultHandle(), fakePortletContext2);
        CopyPortlets copyPortlets = this.createSimpleCopyPortlets(portletContexts);
        CopyPortletsResponse response = this.producer.copyPortlets(copyPortlets);
        PortletManagementTestCase.assertEquals((int)1, (int)response.getFailedPortlets().size());
        FailedPortlets failedPortlets = (FailedPortlets)response.getFailedPortlets().get(0);
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getPortletHandles().contains(fakePortletContext1));
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getPortletHandles().contains(fakePortletContext2));
        PortletManagementTestCase.assertTrue((boolean)failedPortlets.getErrorCode().getLocalPart().contains("InvalidHandle"));
        PortletManagementTestCase.assertEquals((int)1, (int)response.getCopiedPortlets().size());
        PortletManagementTestCase.assertEquals((String)this.getDefaultHandle(), (String)((CopiedPortlet)response.getCopiedPortlets().get(0)).getFromPortletHandle());
        PortletManagementTestCase.assertFalse((boolean)((CopiedPortlet)response.getCopiedPortlets().get(0)).getNewPortletContext().getPortletHandle().equals(this.getDefaultHandle()));
    }

    protected CopyPortlets createSimpleCopyPortlets(List<PortletContext> portletContexts) {
        RegistrationContext toRegistrationContext = null;
        UserContext toUserContext = null;
        RegistrationContext fromRegistrationContext = null;
        UserContext fromUserContext = null;
        return WSRPTypeFactory.createCopyPortlets(toRegistrationContext, toUserContext, fromRegistrationContext, fromUserContext, portletContexts);
    }

    protected void checkSimpleCopyPortletsResponse(CopyPortletsResponse response, List<String> success, List<String> failure) {
        PortletManagementTestCase.assertEquals((int)success.size(), (int)response.getCopiedPortlets().size());
        for (CopiedPortlet copiedPortlet : response.getCopiedPortlets()) {
            PortletManagementTestCase.assertTrue((boolean)success.contains(copiedPortlet.getFromPortletHandle()));
        }
        PortletManagementTestCase.assertEquals((int)failure.size(), (int)response.getFailedPortlets().size());
        for (FailedPortlets failedPortlet : response.getFailedPortlets()) {
            PortletManagementTestCase.assertTrue((boolean)failure.containsAll(failedPortlet.getPortletHandles()));
        }
        for (CopiedPortlet copiedPortlet : response.getCopiedPortlets()) {
            PortletManagementTestCase.assertFalse((boolean)copiedPortlet.getFromPortletHandle().equals(copiedPortlet.getNewPortletContext().getPortletHandle()));
        }
    }

    protected void checkDefaultMarkup(String portletHandle, RegistrationContext registrationContext) throws Exception {
        GetMarkup getMarkup = this.createDefaultGetMarkup(portletHandle);
        getMarkup.setRegistrationContext(registrationContext);
        MarkupResponse response = this.producer.getMarkup(getMarkup);
        String defaultMarkup = "<p>symbol unset stock value: value unset</p>";
        MarkupContext markupContext = response.getMarkupContext();
        PortletManagementTestCase.assertNotNull((Object)markupContext);
        PortletManagementTestCase.assertEquals((String)"text/html", (String)markupContext.getMimeType());
        PortletManagementTestCase.assertTrue((boolean)markupContext.getItemString().contains(defaultMarkup));
    }

    protected List<String> createStringList(String ... names) {
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.add(names[i]);
        }
        return list;
    }

    @Test
    public void testClonePortletAvailabilityRR() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(true);
        this.checkClonePortletAvailability();
    }

    @Test
    public void testClonePortletAvailabilityNRR() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        this.checkClonePortletAvailability();
    }

    public void checkClonePortletAvailability() throws Exception {
        RegistrationData registrationDataA = WSRPTypeFactory.createRegistrationData((String)"CONSUMERA", (String)"CONSUMERAGENTA.0.0", (boolean)true);
        RegistrationContext registrationContextA = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationDataA, null, null));
        RegistrationData registrationDataB = WSRPTypeFactory.createRegistrationData((String)"CONSUMERB", (String)"CONSUMERAGENTB.0.0", (boolean)true);
        RegistrationContext registrationContextB = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationDataB, null, null));
        this.checkClonePortletAvailability(registrationContextA, registrationContextB);
    }

    public void checkClonePortletAvailability(RegistrationContext registrationContextA, RegistrationContext registrationContextB) throws Exception {
        PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)this.getDefaultHandle());
        ClonePortlet clonePortlet = WSRPTypeFactory.createClonePortlet((RegistrationContext)registrationContextA, (PortletContext)portletContext, null);
        PortletContext clonedPortletContext = this.producer.clonePortlet(clonePortlet);
        PortletManagementTestCase.assertFalse((boolean)portletContext.getPortletHandle().equals(clonedPortletContext.getPortletHandle()));
        GetMarkup getMarkupA = this.createDefaultGetMarkup(clonedPortletContext.getPortletHandle());
        getMarkupA.setRegistrationContext(registrationContextA);
        this.producer.getMarkup(getMarkupA);
        try {
            GetMarkup getMarkupB = this.createDefaultGetMarkup(clonedPortletContext.getPortletHandle());
            getMarkupB.setRegistrationContext(registrationContextB);
            this.producer.getMarkup(getMarkupB);
            PortletManagementTestCase.fail((String)"Should not be able to render a cloned portlet from a registration context which didn't create the clone.");
        }
        catch (InvalidHandle e) {
            // empty catch block
        }
    }

    @Test
    public void testClonePortletAvailabilityNonRegisteredA() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        RegistrationData registrationDataA = WSRPTypeFactory.createRegistrationData((String)"CONSUMERA", (String)"CONSUMERAGENTA.0.0", (boolean)true);
        RegistrationContext registrationContextA = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationDataA, null, null));
        this.checkClonePortletAvailability(registrationContextA, null);
    }

    @Test
    public void testClonePortletAvailabilityNonRegisteredB() throws Exception {
        this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements().setRegistrationRequired(false);
        RegistrationData registrationDataB = WSRPTypeFactory.createRegistrationData((String)"CONSUMERB", (String)"CONSUMERAGENTB.0.0", (boolean)true);
        RegistrationContext registrationContextB = this.producer.register(WSRPTypeFactory.createRegister((RegistrationData)registrationDataB, null, null));
        this.checkClonePortletAvailability(null, registrationContextB);
    }

    @Test
    public void testClonePortletAvailabilityNullRegistered() throws Exception {
        RegistrationContext registrationContextA = null;
        RegistrationContext registrationContextB = null;
        String handle = this.getDefaultHandle();
        PortletContext portletContext = WSRPTypeFactory.createPortletContext((String)this.getDefaultHandle());
        ClonePortlet clonePortlet = WSRPTypeFactory.createClonePortlet(registrationContextA, (PortletContext)portletContext, null);
        PortletContext clonedPortletContext = this.producer.clonePortlet(clonePortlet);
        PortletManagementTestCase.assertFalse((boolean)portletContext.getPortletHandle().equals(clonedPortletContext.getPortletHandle()));
        GetMarkup getMarkupA = this.createDefaultGetMarkup(clonedPortletContext.getPortletHandle());
        getMarkupA.setRegistrationContext(registrationContextA);
        this.producer.getMarkup(getMarkupA);
        GetMarkup getMarkupB = this.createDefaultGetMarkup(clonedPortletContext.getPortletHandle());
        getMarkupB.setRegistrationContext(registrationContextB);
        this.producer.getMarkup(getMarkupB);
    }

    @Override
    protected String getMostUsedPortletWARFileName() {
        return TEST_BASIC_PORTLET_WAR;
    }
}

