/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.api.servlet.ServletAccess;
import org.gatein.wsrp.portlet.utils.MockRequest;
import org.gatein.wsrp.protocol.v2.V2ProducerBaseTest;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockHttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.ParameterDescription;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;

@RunWith(value=Arquillian.class)
public class ServiceDescriptionTestCase
extends V2ProducerBaseTest {
    public ServiceDescriptionTestCase() throws Exception {
        super(ServiceDescriptionTestCase.class.getSimpleName());
    }

    @Deployment
    @OverProtocol(value="Servlet 2.5")
    public static Archive createDeployment() {
        return V2ProducerBaseTest.createDeployment();
    }

    @Override
    protected boolean removeCurrent(String archiveName) {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        MockRequest request = new MockRequest();
        request.setCoyoteRequest(new org.apache.coyote.Request());
        RequestFacade requestFacade = new RequestFacade((Request)request);
        ServletAccess.setRequestAndResponse((HttpServletRequest)requestFacade, (HttpServletResponse)MockHttpServletResponse.createMockResponse());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testServiceDescriptionFilteringEmptyHandleList() throws OperationFailed, ResourceSuspended, ModifyRegistrationRequired, InvalidRegistration {
        GetServiceDescription gsd = this.getNoRegistrationServiceDescriptionRequest();
        ServiceDescription original = this.producer.getServiceDescription(gsd);
        gsd.getPortletHandles().clear();
        ServiceDescriptionTestCase.assertEquals((Object)original.getOfferedPortlets(), (Object)this.producer.getServiceDescription(gsd).getOfferedPortlets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceDescriptionFilterInexistentFilter() throws Exception {
        GetServiceDescription gsd = this.getNoRegistrationServiceDescriptionRequest();
        gsd.getPortletHandles().add("Inexistent blah");
        try {
            this.deploy("test-basic-portlet.war");
            this.deploy("test-markup-portlet.war");
            this.deploy("test-session-portlet.war");
            ServiceDescription sd = this.producer.getServiceDescription(gsd);
            ServiceDescriptionTestCase.assertEquals((int)0, (int)sd.getOfferedPortlets().size());
        }
        finally {
            this.undeploy("test-basic-portlet.war");
            this.undeploy("test-markup-portlet.war");
            this.undeploy("test-session-portlet.war");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceDescriptionFiltering() throws Exception {
        try {
            GetServiceDescription gsd = this.getNoRegistrationServiceDescriptionRequest();
            this.deploy("test-basic-portlet.war");
            this.deploy("test-markup-portlet.war");
            this.deploy("test-session-portlet.war");
            ServiceDescription sd = this.producer.getServiceDescription(gsd);
            ServiceDescriptionTestCase.assertEquals((int)3, (int)sd.getOfferedPortlets().size());
            List handles = WSRPUtils.transform((List)sd.getOfferedPortlets(), (Function)new Function<PortletDescription, String>(){

                public String apply(PortletDescription from) {
                    return from.getPortletHandle();
                }
            });
            String filter = null;
            ArrayList<String> filteredHandles = new ArrayList<String>(2);
            for (String handle : handles) {
                if (handle.contains("test-basic-portlet")) {
                    filter = handle;
                    continue;
                }
                filteredHandles.add(handle);
            }
            gsd.getPortletHandles().add(filter);
            sd = this.producer.getServiceDescription(gsd);
            ServiceDescriptionTestCase.assertEquals((int)1, (int)sd.getOfferedPortlets().size());
            ServiceDescriptionTestCase.assertEquals((String)filter, (String)((PortletDescription)sd.getOfferedPortlets().get(0)).getPortletHandle());
            this.undeploy("test-basic-portlet.war");
            sd = this.producer.getServiceDescription(gsd);
            ServiceDescriptionTestCase.assertTrue((boolean)sd.getOfferedPortlets().isEmpty());
            gsd.getPortletHandles().clear();
            sd = this.producer.getServiceDescription(gsd);
            List offeredPortlets = sd.getOfferedPortlets();
            ServiceDescriptionTestCase.assertEquals((int)2, (int)offeredPortlets.size());
            ServiceDescriptionTestCase.assertTrue((((PortletDescription)offeredPortlets.get(0)).getPortletHandle().contains((CharSequence)filteredHandles.get(0)) && ((PortletDescription)offeredPortlets.get(1)).getPortletHandle().equals(filteredHandles.get(1)) || ((PortletDescription)offeredPortlets.get(1)).getPortletHandle().equals(filteredHandles.get(0)) && ((PortletDescription)offeredPortlets.get(0)).getPortletHandle().equals(filteredHandles.get(1)) ? 1 : 0) != 0);
        }
        finally {
            this.undeploy("test-basic-portlet.war");
            this.undeploy("test-markup-portlet.war");
            this.undeploy("test-session-portlet.war");
        }
    }

    @Test
    public void testSupportedOptions() throws OperationFailed, InvalidRegistration, ResourceSuspended, ModifyRegistrationRequired {
        ServiceDescription description = this.producer.getServiceDescription(this.getNoRegistrationServiceDescriptionRequest());
        ExtendedAssert.assertNotNull((Object)description);
        List options = description.getSupportedOptions();
        ExtendedAssert.assertTrue((boolean)ParameterValidation.existsAndIsNotEmpty((Collection)options));
        ExtendedAssert.assertTrue((boolean)options.contains("wsrp:events"));
        ExtendedAssert.assertTrue((boolean)options.contains("wsrp:import"));
        ExtendedAssert.assertTrue((boolean)options.contains("wsrp:export"));
        ExtendedAssert.assertTrue((boolean)options.contains("wsrp:copyPortlets"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventDescriptions() throws Exception {
        try {
            this.deploy("google-portlet.war");
            ServiceDescription description = this.producer.getServiceDescription(this.getNoRegistrationServiceDescriptionRequest());
            List eventDescriptions = description.getEventDescriptions();
            ExtendedAssert.assertNotNull((Object)eventDescriptions);
            ExtendedAssert.assertEquals((int)1, (int)eventDescriptions.size());
            QName zip = new QName("urn:jboss:portal:samples:event", "ZipEvent");
            EventDescription event = (EventDescription)eventDescriptions.get(0);
            ExtendedAssert.assertEquals((Object)zip, (Object)event.getName());
            ExtendedAssert.assertTrue((boolean)event.getAliases().isEmpty());
            ExtendedAssert.assertTrue((boolean)event.getLabel().getValue().contains(zip.toString()));
            List portlets = description.getOfferedPortlets();
            ExtendedAssert.assertEquals((int)2, (int)portlets.size());
            for (PortletDescription portlet : portlets) {
                if (!portlet.getPortletHandle().contains("GoogleMap")) continue;
                List publishedEvents = portlet.getPublishedEvents();
                ExtendedAssert.assertEquals((int)1, (int)publishedEvents.size());
                ExtendedAssert.assertEquals((Object)zip, publishedEvents.get(0));
                ExtendedAssert.assertTrue((boolean)portlet.getHandledEvents().isEmpty());
            }
            this.deploy("test-basic-portlet.war");
            description = this.producer.getServiceDescription(this.getNoRegistrationServiceDescriptionRequest());
            eventDescriptions = description.getEventDescriptions();
            portlets = description.getOfferedPortlets();
            QName foo = new QName("urn:jboss:gatein", "foo");
            ExtendedAssert.assertEquals((int)2, (int)eventDescriptions.size());
            for (EventDescription eventDesc : eventDescriptions) {
                QName name = eventDesc.getName();
                boolean isZip = zip.equals(name);
                boolean isFoo = foo.equals(name);
                if (isZip || isFoo) {
                    if (!isFoo) continue;
                    ExtendedAssert.assertEquals((Object)foo, (Object)eventDesc.getName());
                    ExtendedAssert.assertTrue((boolean)eventDesc.getLabel().getValue().contains(foo.toString()));
                    List aliases = eventDesc.getAliases();
                    ExtendedAssert.assertEquals((int)2, (int)aliases.size());
                    ExtendedAssert.assertTrue((boolean)aliases.contains(new QName("urn:jboss:gatein", "bar")));
                    ExtendedAssert.assertTrue((boolean)aliases.contains(new QName("urn:jboss:gatein", "baz")));
                    continue;
                }
                ExtendedAssert.fail((String)"Only 2 events should be ZipEvent or foo!");
            }
            for (PortletDescription portlet : portlets) {
                if (!portlet.getPortletHandle().contains("Simple Test Portlet")) continue;
                List events = portlet.getPublishedEvents();
                ExtendedAssert.assertEquals((int)2, (int)events.size());
                ExtendedAssert.assertTrue((boolean)events.contains(zip));
                ExtendedAssert.assertTrue((boolean)events.contains(foo));
                events = portlet.getHandledEvents();
                ExtendedAssert.assertEquals((int)1, (int)events.size());
                ExtendedAssert.assertTrue((boolean)events.contains(zip));
            }
        }
        finally {
            this.undeploy("google-portlet.war");
            this.undeploy("test-basic-portlet.war");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParameterDescriptions() throws Exception {
        try {
            this.deploy("test-basic-portlet.war");
            ServiceDescription description = this.producer.getServiceDescription(this.getNoRegistrationServiceDescriptionRequest());
            List portlets = description.getOfferedPortlets();
            ExtendedAssert.assertEquals((int)1, (int)portlets.size());
            PortletDescription portlet = (PortletDescription)portlets.get(0);
            QName fooparam = new QName("urn:jboss:gatein", "fooparam");
            QName zipcode = new QName("urn:jboss:portal:simple:google", "zipcode");
            List publicValueDescriptions = portlet.getNavigationalPublicValueDescriptions();
            ExtendedAssert.assertNotNull((Object)publicValueDescriptions);
            ExtendedAssert.assertEquals((int)2, (int)publicValueDescriptions.size());
            for (ParameterDescription param : publicValueDescriptions) {
                List names;
                String identifier = param.getIdentifier();
                if ("foo".equals(identifier)) {
                    names = param.getNames();
                    ExtendedAssert.assertTrue((boolean)names.contains(fooparam));
                    ExtendedAssert.assertTrue((boolean)names.contains(new QName("urn:jboss:gatein", "barparam")));
                    ExtendedAssert.assertTrue((boolean)names.contains(new QName("urn:jboss:gatein", "bazparam")));
                    ExtendedAssert.assertEquals((String)identifier, (String)param.getLabel().getValue());
                    ExtendedAssert.assertEquals((String)"Foo param", (String)param.getDescription().getValue());
                    continue;
                }
                if ("zipcode".equals(identifier)) {
                    names = param.getNames();
                    ExtendedAssert.assertEquals((int)1, (int)names.size());
                    ExtendedAssert.assertTrue((boolean)names.contains(zipcode));
                    continue;
                }
                ExtendedAssert.fail((String)("Unexpected parameter description: " + identifier));
            }
        }
        finally {
            this.undeploy("test-basic-portlet.war");
        }
    }
}

