/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPropertyValidator;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.producer.ProducerHolder;
import org.gatein.wsrp.producer.WSRPProducer;
import org.gatein.wsrp.producer.WSRPProducerBaseTest;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.processors.ProducerHelper;
import org.gatein.wsrp.producer.v2.WSRP2Producer;
import org.gatein.wsrp.protocol.v2.MarkupTestCase;
import org.gatein.wsrp.protocol.v2.NeedPortletHandleTest;
import org.gatein.wsrp.protocol.v2.PortletManagementTestCase;
import org.gatein.wsrp.protocol.v2.ServiceDescriptionTestCase;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.test.ExtendedAssert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.ServiceDescription;

public abstract class V2ProducerBaseTest
extends WSRPProducerBaseTest {
    private static final Function<PortletDescription, String> PORTLET_DESCRIPTION_TO_HANDLE = new Function<PortletDescription, String>(){

        public String apply(PortletDescription from) {
            return from.getPortletHandle();
        }
    };
    protected WSRP2Producer producer = ProducerHolder.getProducer((boolean)true);
    private static final String CONSUMER = "test-consumer";

    public V2ProducerBaseTest() throws Exception {
        this("V2ProducerBaseTest");
    }

    protected V2ProducerBaseTest(String name) throws Exception {
        super(name);
    }

    @Override
    protected WSRPProducer getProducer() {
        return this.producer;
    }

    @Override
    protected ProducerHelper getProducerHelper() {
        return (ProducerHelper)this.producer;
    }

    @Override
    protected Collection<String> getPortletHandles() throws Exception {
        GetServiceDescription getServiceDescription = WSRPTypeFactory.createGetServiceDescription(null, null);
        ServiceDescription serviceDescription = this.producer.getServiceDescription(getServiceDescription);
        List offered = serviceDescription.getOfferedPortlets();
        return Collections2.transform((Collection)offered, PORTLET_DESCRIPTION_TO_HANDLE);
    }

    protected GetServiceDescription getNoRegistrationServiceDescriptionRequest() {
        GetServiceDescription gs = WSRPTypeFactory.createGetServiceDescription(null, null);
        gs.getDesiredLocales().add("en-US");
        gs.getDesiredLocales().add("en");
        return gs;
    }

    protected RegistrationPropertyDescription configureRegistrationSettings(boolean requiresRegistration, boolean provideUnregisteredFullDescription) {
        ProducerRegistrationRequirements registrationRequirements = this.producer.getConfigurationService().getConfiguration().getRegistrationRequirements();
        registrationRequirements.setRegistrationRequired(requiresRegistration);
        registrationRequirements.setRegistrationRequiredForFullDescription(!provideUnregisteredFullDescription);
        if (requiresRegistration) {
            RegistrationPropertyDescription regProp = new RegistrationPropertyDescription("regProp", new QName("urn:oasis:names:tc:wsrp:v1:types", "LocalizedString", "ns1"));
            regProp.setDefaultLabel("Registration Property");
            registrationRequirements.addRegistrationProperty(regProp);
            DefaultRegistrationPolicy defaultRegistrationPolicy = new DefaultRegistrationPolicy();
            defaultRegistrationPolicy.setValidator((RegistrationPropertyValidator)new DefaultRegistrationPropertyValidator());
            registrationRequirements.setPolicy((RegistrationPolicy)defaultRegistrationPolicy);
            RegistrationManager registrationManager = this.producer.getRegistrationManager();
            registrationManager.setPolicy((RegistrationPolicy)defaultRegistrationPolicy);
            registrationRequirements.addRegistrationPropertyChangeListener((RegistrationPropertyChangeListener)registrationManager);
            try {
                registrationManager.createConsumer(CONSUMER);
            }
            catch (RegistrationException e) {
                ExtendedAssert.fail((String)("Couldn't create consumer. Cause: " + e.getLocalizedMessage()));
            }
            return regProp;
        }
        return null;
    }

    protected static Archive createDeployment() {
        EnterpriseArchive archive = (EnterpriseArchive)ShrinkWrap.createFromZipFile(EnterpriseArchive.class, (File)new File("target/test-archives/test-producer.ear"));
        JavaArchive testJar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClasses(new Class[]{V2ProducerBaseTest.class, WSRPProducerBaseTest.class});
        testJar = (JavaArchive)testJar.addClasses(new Class[]{MarkupTestCase.class, NeedPortletHandleTest.class, PortletManagementTestCase.class, ServiceDescriptionTestCase.class});
        archive = (EnterpriseArchive)archive.addAsLibraries(new Archive[]{testJar});
        WebArchive pcWebArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"producer-test-portlet-container.war");
        pcWebArchive.merge((Archive)((ExplodedImporter)((WebArchive)ShrinkWrap.create(WebArchive.class)).as(ExplodedImporter.class)).importDirectory("src/test/portlet-container-war").as(WebArchive.class));
        archive.addAsModule((Archive)pcWebArchive);
        return archive;
    }
}

