/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.support;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gatein.exports.ExportPersistenceManager;
import org.gatein.exports.data.ExportContext;
import org.gatein.exports.data.ExportPortletData;
import org.gatein.exports.data.PersistedExportData;

public class TestMockExportPersistenceManager
implements ExportPersistenceManager {
    public static final String PEC_TYPE = "P_EC";
    public static final double PEC_VERSION = 1.0;
    public static final String PED_TYPE = "P_ED";
    public static final double PED_VERSION = 1.0;
    Map<String, ExportContext> exportContexts = new HashMap<String, ExportContext>();
    Map<String, ExportPortletData> exportPortletDatas = new HashMap<String, ExportPortletData>();

    public ExportContext getExportContext(String refId) {
        return this.exportContexts.get(refId);
    }

    public ExportPortletData getExportPortletData(String exportContextId, String portletDataID) {
        ExportContext exportContext = this.exportContexts.get(exportContextId);
        if (exportContext.getPortlets().contains(portletDataID)) {
            return this.exportPortletDatas.get(portletDataID);
        }
        return null;
    }

    public Set<String> getExportContextKeys() {
        return this.exportContexts.keySet();
    }

    public Set<String> getExportPortletsKeys() {
        return this.exportPortletDatas.keySet();
    }

    public String getExportReferenceId(String type, double version, byte[] bytes) throws UnsupportedEncodingException {
        if (this.supports(type, version)) {
            PersistedExportData persistedExportData = PersistedExportData.create((byte[])bytes);
            return persistedExportData.getRefId();
        }
        return null;
    }

    public boolean removeExportContext(String refId) {
        if (this.exportContexts.containsKey(refId)) {
            List portlets = this.exportContexts.get(refId).getPortlets();
            for (String portlet : portlets) {
                this.exportPortletDatas.remove(portlet);
            }
            this.exportContexts.remove(refId);
            return true;
        }
        return false;
    }

    public boolean removeExportPortletData(String exportContextId, String exportDataId) {
        List portlets;
        if (this.exportContexts.containsKey(exportDataId) && (portlets = this.exportContexts.get(exportDataId).getPortlets()).contains(exportDataId)) {
            portlets.remove(exportContextId);
            this.exportPortletDatas.remove(exportDataId);
            return true;
        }
        return false;
    }

    public boolean supports(String type, double version) {
        return type.equals(PEC_TYPE) && version == 1.0 || type.equals(PED_TYPE) && version == 1.0;
    }

    public ExportContext updateExportContext(String refId, ExportContext updatedExportContext) {
        if (updatedExportContext != null && refId != null && this.exportContexts.containsKey(refId)) {
            this.exportContexts.put(refId, updatedExportContext);
            return updatedExportContext;
        }
        return null;
    }

    public ExportPortletData updateExportPortletData(String exportContextId, String exportPortletId, ExportPortletData updatedPortletData) {
        if (updatedPortletData != null && exportPortletId != null && exportContextId != null && this.exportContexts.containsKey(exportContextId)) {
            this.exportPortletDatas.put(exportPortletId, updatedPortletData);
            return updatedPortletData;
        }
        return null;
    }

    public byte[] encodeExportContext(String refId) throws IOException {
        PersistedExportData persistedExportData = new PersistedExportData(PEC_TYPE, refId);
        return persistedExportData.encodeAsBytes();
    }

    public byte[] encodeExportPortletData(String exportDataRefId) throws IOException {
        PersistedExportData persistedExportData = new PersistedExportData(PED_TYPE, exportDataRefId);
        return persistedExportData.encodeAsBytes();
    }

    public String storeExportContext(ExportContext exportContext) {
        if (exportContext != null) {
            String refId = UUID.randomUUID().toString();
            this.exportContexts.put(refId, exportContext);
            return refId;
        }
        return null;
    }

    public String storeExportPortletData(ExportContext exportContext, ExportPortletData exportPortletData) {
        if (exportPortletData != null && exportContext != null) {
            String refId = UUID.randomUUID().toString();
            exportContext.addPortlet(refId);
            this.exportPortletDatas.put(refId, exportPortletData);
            return refId;
        }
        return null;
    }
}

