/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.TypeUtils;
import com.googlecode.jtype.Types;
import com.googlecode.jtype.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class Generic<T> {
    private final Type type;

    protected Generic() {
        Type type = this.getActualTypeArgument();
        Generic.validateType(type);
        this.type = type;
    }

    Generic(Type type) {
        Generic.validateType(type);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Class<? super T> getRawType() {
        return TypeUtils.getErasedReferenceType(this.type);
    }

    public String toUnqualifiedString() {
        return TypeUtils.toUnqualifiedString(this.type);
    }

    public static <T> Generic<T> get(Class<T> klass) {
        return new DefaultGeneric(klass);
    }

    public static Generic<?> get(Type type) {
        return new DefaultGeneric(type);
    }

    public static <T> Generic<? extends T> get(Class<T> rawType, Type ... actualTypeArguments) {
        ParameterizedType paramType = Types.parameterizedType(rawType, actualTypeArguments);
        return Generic.get(paramType);
    }

    public static Generic<?> valueOf(String typeName) {
        return Generic.get(Types.valueOf(typeName));
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Generic)) {
            return false;
        }
        Generic generic = (Generic)object;
        return this.type.equals(generic.getType());
    }

    public String toString() {
        return TypeUtils.toString(this.type);
    }

    private static void validateType(Type type) {
        Utils.checkNotNull(type, "type");
        Utils.checkFalse(type instanceof TypeVariable, "Type variables are not supported: ", type);
        Utils.checkFalse(type instanceof WildcardType, "Wildcard types are not supported: ", type);
        Utils.checkTrue(type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType, "Unsupported type: ", type);
    }

    private Type getActualTypeArgument() {
        if (this.getClass().getSuperclass() != Generic.class) {
            throw new IllegalStateException("Generic must only be subclassed once");
        }
        Type superclass = this.getClass().getGenericSuperclass();
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    private static final class DefaultGeneric<T>
    extends Generic<T> {
        public DefaultGeneric(Type type) {
            super(type);
        }
    }
}

