/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.ClassSerializer;
import com.googlecode.jtype.ClassSerializers;
import com.googlecode.jtype.ClassUtils;
import com.googlecode.jtype.DefaultGenericArrayType;
import com.googlecode.jtype.DefaultParameterizedType;
import com.googlecode.jtype.DefaultTypeVariable;
import com.googlecode.jtype.DefaultWildcardType;
import com.googlecode.jtype.Types;
import com.googlecode.jtype.Utils;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class TypeUtils {
    private static final Map<Class<?>, Set<Class<?>>> SUBTYPES_BY_PRIMITIVE;

    private TypeUtils() {
        throw new AssertionError();
    }

    public static boolean isAssignable(Type supertype, Type type) {
        Utils.checkNotNull(supertype, "supertype");
        Utils.checkNotNull(type, "type");
        if (supertype.equals(type)) {
            return true;
        }
        if (supertype instanceof Class) {
            if (type instanceof Class) {
                return TypeUtils.isClassAssignable((Class)supertype, (Class)type);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.isAssignable(supertype, ((ParameterizedType)type).getRawType());
            }
            if (type instanceof TypeVariable) {
                return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type);
            }
            if (type instanceof GenericArrayType) {
                if (((Class)supertype).isArray()) {
                    return TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type));
                }
                return TypeUtils.isArraySupertype((Class)supertype);
            }
            return false;
        }
        if (supertype instanceof ParameterizedType) {
            if (type instanceof Class) {
                return TypeUtils.isSuperAssignable(supertype, type);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.isParameterizedTypeAssignable((ParameterizedType)supertype, (ParameterizedType)type);
            }
            return false;
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.isTypeVariableAssignable(supertype, (TypeVariable)type);
        }
        if (supertype instanceof GenericArrayType) {
            if (TypeUtils.isArray(type)) {
                return TypeUtils.isAssignable(TypeUtils.getComponentType(supertype), TypeUtils.getComponentType(type));
            }
            return false;
        }
        if (supertype instanceof WildcardType) {
            return TypeUtils.isWildcardTypeAssignable((WildcardType)supertype, type);
        }
        return false;
    }

    public static boolean isInstance(Type type, Object object) {
        return TypeUtils.getErasedReferenceType(type).isInstance(object);
    }

    public static Type getErasedType(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return TypeUtils.getErasedType(rawType);
        }
        if (TypeUtils.isArray(type)) {
            Type componentType = TypeUtils.getComponentType(type);
            Type erasedComponentType = TypeUtils.getErasedType(componentType);
            return TypeUtils.getArrayType(erasedComponentType);
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return TypeUtils.getErasedType(bounds[0]);
        }
        return type;
    }

    public static Class<?> getErasedReferenceType(Type type) {
        Utils.checkTrue(TypeUtils.isReferenceType(type), "type is not a reference type: ", type);
        return (Class)TypeUtils.getErasedType(type);
    }

    @Deprecated
    public static Class<?> getRawType(Type type) {
        return TypeUtils.getErasedReferenceType(type);
    }

    public static boolean isArray(Type type) {
        return type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType;
    }

    public static Type getComponentType(Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            return klass.isArray() ? klass.getComponentType() : null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static Type getArrayType(Type componentType) {
        Utils.checkNotNull(componentType, "componentType");
        if (componentType instanceof Class) {
            return ClassUtils.getArrayType((Class)componentType);
        }
        return Types.genericArrayType(componentType);
    }

    public static boolean isSimpleParameterizedType(Type type, Class<?> rawType) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(rawType, "rawType");
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type;
        Type paramRawType = paramType.getRawType();
        if (!(paramRawType instanceof Class)) {
            return false;
        }
        Class paramRawClass = (Class)paramRawType;
        if (!rawType.isAssignableFrom(paramRawClass)) {
            return false;
        }
        Type[] typeArgs = paramType.getActualTypeArguments();
        return typeArgs.length == 1;
    }

    public static Type getActualTypeArgument(Type type) {
        Utils.checkNotNull(type, "type");
        ParameterizedType paramType = (ParameterizedType)type;
        Type[] typeArgs = paramType.getActualTypeArguments();
        Utils.checkTrue(typeArgs.length == 1, "type must be a ParameterizedType with one actual type argument: ", type);
        return typeArgs[0];
    }

    public static Type getResolvedSuperclass(Type type) {
        Utils.checkNotNull(type, "type");
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        Type supertype = rawType.getGenericSuperclass();
        if (supertype == null) {
            return null;
        }
        return TypeUtils.resolveTypeVariables(supertype, type);
    }

    public static Type[] getResolvedInterfaces(Type type) {
        Utils.checkNotNull(type, "type");
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        Type[] interfaces = rawType.getGenericInterfaces();
        Type[] resolvedInterfaces = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            resolvedInterfaces[i] = TypeUtils.resolveTypeVariables(interfaces[i], type);
        }
        return resolvedInterfaces;
    }

    public static String toString(Type type) {
        return TypeUtils.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(Type type, ClassSerializer serializer) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.isArray()) {
                return TypeUtils.toString(klass.getComponentType(), serializer) + "[]";
            }
            return serializer.toString(klass);
        }
        if (type instanceof TypeVariable) {
            return DefaultTypeVariable.toString((TypeVariable)type, serializer);
        }
        if (type instanceof GenericArrayType) {
            return DefaultGenericArrayType.toString((GenericArrayType)type, serializer);
        }
        if (type instanceof ParameterizedType) {
            return DefaultParameterizedType.toString((ParameterizedType)type, serializer);
        }
        if (type instanceof WildcardType) {
            return DefaultWildcardType.toString((WildcardType)type, serializer);
        }
        return String.valueOf(type);
    }

    public static String toUnqualifiedString(Type type) {
        return TypeUtils.toString(type, ClassSerializers.UNQUALIFIED);
    }

    public static String toSimpleString(Type type) {
        return TypeUtils.toString(type, ClassSerializers.SIMPLE);
    }

    static StringBuilder appendBounds(StringBuilder builder, Type[] bounds, ClassSerializer serializer) {
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                builder.append(" & ");
            }
            builder.append(TypeUtils.toString(bounds[i], serializer));
        }
        return builder;
    }

    private static void putPrimitiveSubtypes(Map<Class<?>, Set<Class<?>>> subtypesByPrimitive, Class<?> primitiveType, Class<?> ... directSubtypes) {
        HashSet subtypes = new HashSet();
        for (Class<?> directSubtype : directSubtypes) {
            subtypes.add(directSubtype);
            subtypes.addAll((Collection)subtypesByPrimitive.get(directSubtype));
        }
        subtypesByPrimitive.put(primitiveType, Collections.unmodifiableSet(subtypes));
    }

    private static boolean isClassAssignable(Class<?> supertype, Class<?> type) {
        if (supertype.isPrimitive() && type.isPrimitive()) {
            return SUBTYPES_BY_PRIMITIVE.get(supertype).contains(type);
        }
        return supertype.isAssignableFrom(type);
    }

    private static boolean isParameterizedTypeAssignable(ParameterizedType supertype, ParameterizedType type) {
        Type[] typeArgs;
        Type rawType;
        Type rawSupertype = supertype.getRawType();
        if (!rawSupertype.equals(rawType = type.getRawType())) {
            if (rawSupertype instanceof Class && rawType instanceof Class && !((Class)rawSupertype).isAssignableFrom((Class)rawType)) {
                return false;
            }
            return TypeUtils.isSuperAssignable(supertype, type);
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (!(supertypeArg instanceof WildcardType ? !TypeUtils.isWildcardTypeAssignable((WildcardType)supertypeArg, typeArg) : !supertypeArg.equals(typeArg))) continue;
            return false;
        }
        return true;
    }

    private static boolean isTypeVariableAssignable(Type supertype, TypeVariable<?> type) {
        for (Type bound : type.getBounds()) {
            if (!TypeUtils.isAssignable(supertype, bound)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcardTypeAssignable(WildcardType supertype, Type type) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeUtils.isAssignable(upperBound, type)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeUtils.isAssignable(type, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSuperAssignable(Type supertype, Type type) {
        Type superclass = TypeUtils.getResolvedSuperclass(type);
        if (superclass != null && TypeUtils.isAssignable(supertype, superclass)) {
            return true;
        }
        for (Type interphace : TypeUtils.getResolvedInterfaces(type)) {
            if (!TypeUtils.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReferenceType(Type type) {
        return type == null || type instanceof Class || type instanceof ParameterizedType || type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    private static boolean isArraySupertype(Class<?> type) {
        return Object.class.equals(type) || Cloneable.class.equals(type) || Serializable.class.equals(type);
    }

    private static Type resolveTypeVariables(Type type, Type subtype) {
        if (!(type instanceof ParameterizedType)) {
            return type;
        }
        Map<Type, Type> actualTypeArgumentsByParameter = TypeUtils.getActualTypeArgumentsByParameter(type, subtype);
        Class<?> rawType = TypeUtils.getErasedReferenceType(type);
        return TypeUtils.parameterizeClass(rawType, actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameter(Type ... types) {
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (Type type : types) {
            actualTypeArgumentsByParameter.putAll(TypeUtils.getActualTypeArgumentsByParameterInternal(type));
        }
        return TypeUtils.normalize(actualTypeArgumentsByParameter);
    }

    private static Map<Type, Type> getActualTypeArgumentsByParameterInternal(Type type) {
        Type[] typeArguments;
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeParameters = TypeUtils.getErasedReferenceType(type).getTypeParameters();
        if (typeParameters.length != (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length) {
            throw new MalformedParameterizedTypeException();
        }
        LinkedHashMap<Type, Type> actualTypeArgumentsByParameter = new LinkedHashMap<Type, Type>();
        for (int i = 0; i < typeParameters.length; ++i) {
            actualTypeArgumentsByParameter.put(typeParameters[i], typeArguments[i]);
        }
        return actualTypeArgumentsByParameter;
    }

    private static ParameterizedType parameterizeClass(Class<?> type, Map<Type, Type> actualTypeArgumentsByParameter) {
        return TypeUtils.parameterizeClassCapture(type, actualTypeArgumentsByParameter);
    }

    private static <T> ParameterizedType parameterizeClassCapture(Class<T> type, Map<Type, Type> actualTypeArgumentsByParameter) {
        TypeVariable<Class<T>>[] typeParameters = type.getTypeParameters();
        Type[] actualTypeArguments = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<Class<T>> typeParameter = typeParameters[i];
            Type actualTypeArgument = actualTypeArgumentsByParameter.get(typeParameter);
            if (actualTypeArgument == null) {
                throw new IllegalArgumentException("Missing actual type argument for type parameter: " + typeParameter);
            }
            actualTypeArguments[i] = actualTypeArgument;
        }
        return Types.parameterizedType(TypeUtils.getErasedReferenceType(type), actualTypeArguments);
    }

    private static <K, V> Map<K, V> normalize(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            while (map.containsKey(value)) {
                value = map.get(value);
            }
            map.put(key, value);
        }
        return map;
    }

    static {
        HashMap subtypesByPrimitive = new HashMap();
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Void.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Boolean.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Byte.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Character.TYPE, new Class[0]);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Short.TYPE, Byte.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Integer.TYPE, Character.TYPE, Short.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Long.TYPE, Integer.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Float.TYPE, Long.TYPE);
        TypeUtils.putPrimitiveSubtypes(subtypesByPrimitive, Double.TYPE, Float.TYPE);
        SUBTYPES_BY_PRIMITIVE = Collections.unmodifiableMap(subtypesByPrimitive);
    }
}

