/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.internal.arjuna.utils.UuidProcessId;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class CoreEnvironmentService
implements Service<CoreEnvironmentBean> {
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketProcessBindingInjector = new InjectedValue();
    private final String nodeIdentifier;
    private final String path;
    private final String pathRef;
    private volatile PathManager.Callback.Handle callbackHandle;

    public CoreEnvironmentService(String nodeIdentifier, String path, String pathRef) {
        this.nodeIdentifier = nodeIdentifier;
        this.path = path;
        this.pathRef = pathRef;
    }

    public CoreEnvironmentBean getValue() throws IllegalStateException, IllegalArgumentException {
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        return coreEnvironmentBean;
    }

    public void start(StartContext context) throws StartException {
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        if (coreEnvironmentBean.getProcessImplementationClassName() == null) {
            UuidProcessId id = new UuidProcessId();
            coreEnvironmentBean.setProcessImplementation((Process)id);
        }
        coreEnvironmentBean.setNodeIdentifier(this.nodeIdentifier);
        SocketBinding binding = (SocketBinding)this.socketProcessBindingInjector.getOptionalValue();
        if (binding != null) {
            int port = binding.getPort();
            coreEnvironmentBean.setSocketProcessIdPort(port);
        }
        this.callbackHandle = ((PathManager)this.pathManagerInjector.getValue()).registerCallback(this.pathRef, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        coreEnvironmentBean.setVarDir(((PathManager)this.pathManagerInjector.getValue()).resolveRelativePathEntry(this.path, this.pathRef));
    }

    public void stop(StopContext context) {
        this.callbackHandle.remove();
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public Injector<SocketBinding> getSocketProcessBindingInjector() {
        return this.socketProcessBindingInjector;
    }

    public int getSocketProcessIdMaxPorts() {
        return this.getValue().getSocketProcessIdMaxPorts();
    }

    public void setSocketProcessIdMaxPorts(int socketProcessIdMaxPorts) {
        this.getValue().setSocketProcessIdMaxPorts(socketProcessIdMaxPorts);
    }

    public void setProcessImplementationClassName(String clazz) {
        this.getValue().setProcessImplementationClassName(clazz);
    }

    public void setProcessImplementation(Process instance) {
        this.getValue().setProcessImplementation(instance);
    }
}

