/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.jetty;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.gatein.wci.command.CommandServlet;
import org.gatein.wci.spi.WebAppContext;

public class Jetty8WebAppContext
implements WebAppContext {
    private ServletHolder commandServlet;
    private final ServletContextHandler contextHandler;
    private ServletContext servletContext;
    private String contextPath;
    private ClassLoader classLoader;

    public Jetty8WebAppContext(ServletContextHandler contextHandler) {
        this.contextHandler = contextHandler;
        this.servletContext = contextHandler.getServletContext();
        this.contextPath = contextHandler.getContextPath();
        this.classLoader = contextHandler.getClassLoader();
    }

    public void start() throws Exception {
        try {
            this.commandServlet = new ServletHolder();
            this.commandServlet.setName("CommandServlet");
            this.commandServlet.setInitOrder(0);
            this.commandServlet.setClassName(CommandServlet.class.getName());
            this.contextHandler.addServlet(this.commandServlet, "/jetty8gateinservlet");
        }
        catch (Exception ex) {
            this.clean();
        }
    }

    public void stop() {
        this.clean();
    }

    private void clean() {
        if (this.commandServlet != null) {
            try {
                this.commandServlet.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }

    public boolean invalidateSession(String sessId) {
        HttpSession session = this.contextHandler.getSessionHandler().getSessionManager().getHttpSession(sessId);
        if (session != null) {
            session.invalidate();
            return true;
        }
        return false;
    }
}

