/*
 * Decompiled with CFR 0.152.
 */
package org.josso;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.util.config.ConfigurationContext;

public class ConfigurationContextImpl
implements ConfigurationContext {
    private File file;
    private boolean updatable;
    private boolean backupConfiguration;
    private static final Log logger = LogFactory.getLog(ConfigurationContextImpl.class);

    public ConfigurationContextImpl(File f, boolean updatable, boolean backupConfiguration) {
        this(f, updatable);
        this.backupConfiguration = backupConfiguration;
    }

    public ConfigurationContextImpl(File f, boolean updatable) {
        this(f);
        this.updatable = this.updatable && updatable;
    }

    public ConfigurationContextImpl(File f) {
        this.file = f;
        boolean bl = this.updatable = this.file != null && this.file.exists() && this.file.canRead() && this.file.canWrite() && !this.file.isDirectory();
        if (this.file != null && !this.file.exists()) {
            logger.warn((Object)("Configuration file does not exists : " + f.getAbsolutePath()));
        }
    }

    public boolean isConfigurationUpdatable() {
        return this.updatable;
    }

    public File getConfigurationFile() {
        return this.file;
    }

    public boolean isBackupEnabled() {
        return this.backupConfiguration;
    }
}

