/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.gateway.protocol.SSOProtocolManager;
import org.josso.gateway.protocol.handler.ProtocolHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOProtocolManagerImpl
implements SSOProtocolManager {
    private static final Log logger = LogFactory.getLog(SSOProtocolManagerImpl.class);
    protected HashMap<String, ProtocolHandler> handlers = new HashMap();

    @Override
    public void addHandler(String name, ProtocolHandler handler) {
        this.handlers.put(name, handler);
    }

    @Override
    public ProtocolHandler retreiveHandler(String name) {
        return this.handlers.get(name);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
        this.handlers = null;
    }

    @Override
    public boolean dispatchRequest(HttpServletRequest request, HttpServletResponse response) {
        for (ProtocolHandler ph : this.handlers.values()) {
            if (!ph.acceptJob(request, response)) continue;
            return ph.doJob(request, response);
        }
        return true;
    }

    @Override
    public void setHandlers(List<ProtocolHandler> handlers) {
        for (ProtocolHandler handler : handlers) {
            this.handlers.put(handler.getClass().getName(), handler);
        }
    }

    @Override
    public List<ProtocolHandler> getHandlers() {
        return new ArrayList<ProtocolHandler>(this.handlers.values());
    }
}

