/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.tag;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.jboss.portletbridge.component.PortletParam;
import org.jboss.portletbridge.component.PortletProperty;

public abstract class AbstractUrlRenderer
extends Renderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        MimeResponse mimeResponse = (MimeResponse)externalContext.getResponse();
        Map attributes = component.getAttributes();
        Boolean escapeXML = (Boolean)attributes.get("escapeXml");
        Boolean secure = (Boolean)attributes.get("secure");
        String varName = (String)attributes.get("var");
        try {
            BaseURL url = this.createUrl(mimeResponse);
            if (null != secure) {
                url.setSecure(secure.booleanValue());
            }
            this.setParameters(url, component);
            List children = component.getChildren();
            if (null != children) {
                for (UIComponent child : children) {
                    if (child instanceof PortletParam) {
                        PortletParam param = (PortletParam)child;
                        url.setParameter(param.getName(), (String)param.getValue());
                        continue;
                    }
                    if (!(child instanceof PortletProperty)) continue;
                    PortletProperty prop = (PortletProperty)child;
                    url.addProperty(prop.getName(), (String)prop.getValue());
                }
            }
            String urlStr = this.encodePortletUrl(url, null != escapeXML ? escapeXML : true);
            if (null != varName) {
                externalContext.getRequestMap().put(varName, url);
            } else {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                responseWriter.write(urlStr);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
    }

    protected abstract BaseURL createUrl(MimeResponse var1);

    protected abstract void setParameters(BaseURL var1, UIComponent var2) throws Exception;

    protected String encodePortletUrl(BaseURL portletURL, boolean escape) throws IOException {
        StringWriter out = new StringWriter();
        portletURL.write((Writer)out, escape);
        return out.toString();
    }

    protected void setCommonParameters(PortletURL url, UIComponent component) throws Exception {
        PortletRequest request;
        Map publicParameterMap;
        Map attributes = component.getAttributes();
        String windowState = (String)attributes.get("windowState");
        String portletMode = (String)attributes.get("portletMode");
        Boolean copyCurrentRenderParameters = (Boolean)attributes.get("copyCurrentRenderParameters");
        if (null != windowState) {
            url.setWindowState(new WindowState(windowState));
        }
        if (null != portletMode) {
            url.setPortletMode(new PortletMode(portletMode));
        }
        if (null != copyCurrentRenderParameters && copyCurrentRenderParameters.booleanValue() && null != (publicParameterMap = (request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getPublicParameterMap())) {
            url.setParameters(publicParameterMap);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

