/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;

public final class FacesMessageWrapper
implements Serializable {
    private static final long serialVersionUID = -4624330730994746304L;
    private LinkedHashMap<String, List<BridgeMessage>> messages = new LinkedHashMap();

    public void addMessage(String clientId, FacesMessage message) {
        List<BridgeMessage> list = this.messages.get(clientId);
        if (null == list) {
            list = new ArrayList<BridgeMessage>();
            this.messages.put(clientId, list);
        }
        list.add(this.convertToBridgeMsg(message));
    }

    public List<FacesMessage> getMessages(String clientId) {
        List<BridgeMessage> list = this.messages.get(clientId);
        if (null != list) {
            return this.convertToFacesMsgs(list);
        }
        return Collections.emptyList();
    }

    public Set<String> getClientIds() {
        return this.messages.keySet();
    }

    private BridgeMessage convertToBridgeMsg(FacesMessage message) {
        BridgeMessage bridgeMsg = new BridgeMessage();
        bridgeMsg.detail = message.getDetail();
        bridgeMsg.summary = message.getSummary();
        bridgeMsg.rendered = message.isRendered();
        bridgeMsg.severityOrdinal = message.getSeverity().getOrdinal();
        return bridgeMsg;
    }

    private List<FacesMessage> convertToFacesMsgs(List<BridgeMessage> list) {
        ArrayList<FacesMessage> facesMsgs = new ArrayList<FacesMessage>(list.size());
        for (BridgeMessage msg : list) {
            int ordinal;
            FacesMessage facesMsg = new FacesMessage(msg.summary, msg.detail);
            if (msg.rendered) {
                facesMsg.rendered();
            }
            if ((ordinal = msg.severityOrdinal) == FacesMessage.SEVERITY_INFO.getOrdinal()) {
                facesMsg.setSeverity(FacesMessage.SEVERITY_INFO);
            } else if (ordinal == FacesMessage.SEVERITY_WARN.getOrdinal()) {
                facesMsg.setSeverity(FacesMessage.SEVERITY_WARN);
            } else if (ordinal == FacesMessage.SEVERITY_ERROR.getOrdinal()) {
                facesMsg.setSeverity(FacesMessage.SEVERITY_ERROR);
            } else if (ordinal == FacesMessage.SEVERITY_FATAL.getOrdinal()) {
                facesMsg.setSeverity(FacesMessage.SEVERITY_FATAL);
            }
            facesMsgs.add(facesMsg);
        }
        return facesMsgs;
    }

    class BridgeMessage
    implements Serializable {
        private static final long serialVersionUID = 4801706664074825462L;
        int severityOrdinal;
        String summary = null;
        String detail = null;
        boolean rendered;

        BridgeMessage() {
        }
    }
}

