/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.crsh.cmdline.annotations.Man;
import org.crsh.cmdline.annotations.Usage;

public final class Description {
    private final String usage;
    private final String man;

    public Description() {
        this.man = "";
        this.usage = "";
    }

    Description(Description child, Description parent) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.usage = child.usage.length() > 0 ? child.usage : parent.usage;
        this.man = child.man.length() > 0 ? child.man : parent.man;
    }

    Description(String usage, String man) {
        if (usage == null) {
            throw new NullPointerException();
        }
        if (man == null) {
            throw new NullPointerException();
        }
        this.usage = usage;
        this.man = man;
    }

    public Description(AnnotatedElement annotated) {
        this(annotated.getAnnotations());
    }

    Description(Annotation ... annotations) {
        if (annotations == null) {
            throw new NullPointerException();
        }
        String usage = "";
        String man = "";
        for (Annotation annotation : annotations) {
            if (annotation instanceof Usage) {
                usage = ((Usage)annotation).value();
                continue;
            }
            if (!(annotation instanceof Man)) continue;
            man = ((Man)annotation).value();
        }
        this.usage = usage;
        this.man = man;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getMan() {
        return this.man;
    }

    String getBestEffortMan() {
        if (this.man.length() > 0) {
            return this.man;
        }
        return this.usage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Description) {
            Description that = (Description)obj;
            return this.usage.equals(that.usage) && this.man.equals(that.man);
        }
        return false;
    }
}

