/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.HashMap;
import java.util.Map;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.matcher.tokenizer.Termination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCompletion<T>
extends Completion {
    private final ClassDescriptor<T> descriptor;
    private final String mainName;
    private final String prefix;
    private final Termination termination;

    MethodCompletion(ClassDescriptor<T> descriptor, String mainName, String prefix, Termination termination) {
        this.descriptor = descriptor;
        this.mainName = mainName;
        this.prefix = prefix;
        this.termination = termination;
    }

    @Override
    protected Map<String, String> complete() throws CmdCompletionException {
        HashMap<String, String> completions = new HashMap<String, String>();
        for (MethodDescriptor<T> m : this.descriptor.getMethods()) {
            String name = m.getName();
            if (!name.startsWith(this.prefix) || name.equals(this.mainName)) continue;
            completions.put(name.substring(this.prefix.length()), this.termination.getEnd());
        }
        return completions;
    }
}

