/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.remote.RemoteViewInjectionSource;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public class EJBViewDescription
extends ViewDescription {
    private final MethodIntf methodIntf;
    private final boolean hasJNDIBindings;
    private final boolean ejb2xView;

    public EJBViewDescription(ComponentDescription componentDescription, String viewClassName, MethodIntf methodIntf, boolean ejb2xView) {
        super(componentDescription, viewClassName, !ejb2xView && methodIntf != MethodIntf.HOME && methodIntf != MethodIntf.LOCAL_HOME);
        this.methodIntf = methodIntf;
        this.ejb2xView = ejb2xView;
        this.hasJNDIBindings = this.initHasJNDIBindings(methodIntf);
        this.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.putPrivateData(MethodIntf.class, (Object)EJBViewDescription.this.getMethodIntf());
            }
        });
    }

    public MethodIntf getMethodIntf() {
        return this.methodIntf;
    }

    public ViewConfiguration createViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ProxyFactory<?> proxyFactory) {
        return new EJBViewConfiguration(viewClass, componentConfiguration, this.getServiceName(), proxyFactory, this.getMethodIntf());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EJBViewDescription that = (EJBViewDescription)((Object)o);
        if (this.hasJNDIBindings != that.hasJNDIBindings) {
            return false;
        }
        if (this.methodIntf != that.methodIntf) {
            return false;
        }
        if (!this.getViewClassName().equals(that.getViewClassName())) {
            return false;
        }
        if (this.getComponentDescription() != that.getComponentDescription()) {
            return false;
        }
        return super.equals(o);
    }

    protected InjectionSource createInjectionSource(ServiceName serviceName) {
        if (this.methodIntf != MethodIntf.REMOTE && this.methodIntf != MethodIntf.HOME) {
            return super.createInjectionSource(serviceName);
        }
        EJBComponentDescription componentDescription = this.getComponentDescription();
        EEModuleDescription desc = componentDescription.getModuleDescription();
        String earApplicationName = desc.getEarApplicationName();
        return new RemoteViewInjectionSource(serviceName, earApplicationName, desc.getModuleName(), desc.getDistinctName(), componentDescription.getComponentName(), this.getViewClassName(), componentDescription.isStateful());
    }

    public EJBComponentDescription getComponentDescription() {
        return (EJBComponentDescription)super.getComponentDescription();
    }

    public ServiceName getServiceName() {
        return super.getServiceName().append(new String[]{this.methodIntf.toString()});
    }

    public int hashCode() {
        int result = this.methodIntf.hashCode();
        result = 31 * result + (this.hasJNDIBindings ? 1 : 0);
        result = 31 * result + this.getViewClassName().hashCode();
        result = 31 * result + this.getComponentDescription().getComponentName().hashCode();
        return result;
    }

    public boolean hasJNDIBindings() {
        return this.hasJNDIBindings;
    }

    private boolean initHasJNDIBindings(MethodIntf methodIntf) {
        if (methodIntf == MethodIntf.MESSAGE_ENDPOINT) {
            return false;
        }
        if (methodIntf == MethodIntf.SERVICE_ENDPOINT) {
            return false;
        }
        return methodIntf != MethodIntf.TIMER;
    }

    public boolean isEjb2xView() {
        return this.ejb2xView;
    }
}

