/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class DescriptorBasedEJBClientContextService
implements Service<EJBClientContext> {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "dd-based-ejb-client-context"});
    private static final Logger logger = Logger.getLogger(DescriptorBasedEJBClientContextService.class);
    private static final long DEFAULT_CONNECTION_TIMEOUT = 5000L;
    private final Map<ServiceName, InjectedValue<AbstractOutboundConnectionService>> remotingOutboundConnections = new HashMap<ServiceName, InjectedValue<AbstractOutboundConnectionService>>();
    private final InjectedValue<LocalEjbReceiver> localEjbReceiverInjectedValue = new InjectedValue();
    private final EJBClientConfiguration ejbClientConfiguration;
    private volatile EJBClientContext ejbClientContext;

    public DescriptorBasedEJBClientContextService(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        EJBClientContext context = EJBClientContext.create((EJBClientConfiguration)this.ejbClientConfiguration);
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)((Object)this.localEjbReceiverInjectedValue.getOptionalValue());
        if (localEjbReceiver != null) {
            context.registerEJBReceiver((EJBReceiver)localEjbReceiver);
            logger.debug((Object)("Added a local EJB receiver to descriptor based EJB client context named " + startContext.getController().getName()));
        }
        ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
        Collection<Connection> connections = this.createRemotingConnections((ServiceRegistry)serviceRegistry, context);
        for (Connection connection : connections) {
            context.registerConnection(connection);
        }
        logger.debug((Object)("Added " + connections.size() + " remoting EJB receivers to descriptor based EJB client context named " + startContext.getController().getName()));
        this.ejbClientContext = context;
    }

    public synchronized void stop(StopContext context) {
        this.ejbClientContext = null;
    }

    public EJBClientContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.ejbClientContext;
    }

    public void addRemotingConnectionDependency(ServiceBuilder<EJBClientContext> serviceBuilder, ServiceName serviceName) {
        InjectedValue value = new InjectedValue();
        serviceBuilder.addDependency(serviceName, AbstractOutboundConnectionService.class, (Injector)value);
        this.remotingOutboundConnections.put(serviceName, (InjectedValue<AbstractOutboundConnectionService>)value);
    }

    public Injector<LocalEjbReceiver> getLocalEjbReceiverInjector() {
        return this.localEjbReceiverInjectedValue;
    }

    private Collection<Connection> createRemotingConnections(ServiceRegistry serviceRegistry, EJBClientContext context) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Map.Entry<ServiceName, InjectedValue<AbstractOutboundConnectionService>> entry : this.remotingOutboundConnections.entrySet()) {
            InjectedValue<AbstractOutboundConnectionService> injectedValue = entry.getValue();
            AbstractOutboundConnectionService outboundConnectionService = (AbstractOutboundConnectionService)injectedValue.getValue();
            String connectionName = outboundConnectionService.getConnectionName();
            logger.debug((Object)("Creating remoting EJB receiver for connection " + connectionName));
            try {
                IoFuture futureConnection = outboundConnectionService.connect();
                Connection connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                connections.add(connection);
            }
            catch (Exception e) {
                logger.debug((Object)("Failed to create a connection for " + connectionName + ". A reconnect handler will be added to the client context"), (Throwable)e);
                OutboundConnectionReconnectHandler reconnectHandler = new OutboundConnectionReconnectHandler(serviceRegistry, entry.getKey(), context);
                context.registerReconnectHandler((ReconnectHandler)reconnectHandler);
            }
        }
        return connections;
    }

    private class OutboundConnectionReconnectHandler
    implements ReconnectHandler {
        private final ServiceRegistry serviceRegistry;
        private final ServiceName outboundConnectionServiceName;
        private final EJBClientContext clientContext;
        private volatile int reconnectAttemptCount;

        OutboundConnectionReconnectHandler(ServiceRegistry serviceRegistry, ServiceName outboundConnectionServiceName, EJBClientContext clientContext) {
            this.outboundConnectionServiceName = outboundConnectionServiceName;
            this.serviceRegistry = serviceRegistry;
            this.clientContext = clientContext;
        }

        public void reconnect() throws IOException {
            ++this.reconnectAttemptCount;
            ServiceController serviceController = this.serviceRegistry.getService(this.outboundConnectionServiceName);
            if (serviceController == null) {
                logger.debug((Object)("Unregistering " + this + " since " + this.outboundConnectionServiceName + " is no longer available"));
                this.clientContext.unregisterReconnectHandler((ReconnectHandler)this);
                return;
            }
            AbstractOutboundConnectionService outboundConnectionService = (AbstractOutboundConnectionService)serviceController.getValue();
            try {
                IoFuture futureConnection = outboundConnectionService.connect();
                Connection connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                logger.debug((Object)("Successful reconnect attempt#" + this.reconnectAttemptCount + " to outbound connection " + this.outboundConnectionServiceName));
                this.clientContext.unregisterReconnectHandler((ReconnectHandler)this);
                RemotingConnectionEJBReceiver receiver = new RemotingConnectionEJBReceiver(connection, (ReconnectHandler)this, OptionMap.EMPTY);
                this.clientContext.registerEJBReceiver((EJBReceiver)receiver);
            }
            catch (Exception e) {
                logger.debug((Object)("Reconnect attempt#" + this.reconnectAttemptCount + " failed for outbound connection " + this.outboundConnectionServiceName), (Throwable)e);
            }
        }
    }
}

