/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.xnio.Option;
import org.xnio.OptionMap;

class EJBClientCommonConnectionConfig
implements EJBClientConfiguration.CommonConnectionCreationConfiguration {
    private static final Logger logger = Logger.getLogger(EJBClientCommonConnectionConfig.class);
    private OptionMap connectionCreationOptions = OptionMap.EMPTY;
    private OptionMap channelCreationOptions = OptionMap.EMPTY;
    private long connectionTimeout = 5000L;
    private CallbackHandlerProvider callbackHandlerProvider;

    EJBClientCommonConnectionConfig() {
    }

    public OptionMap getConnectionCreationOptions() {
        return this.connectionCreationOptions;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandlerProvider == null ? new AnonymousCallbackHandler() : this.callbackHandlerProvider.getCallbackHandler();
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public OptionMap getChannelCreationOptions() {
        return this.channelCreationOptions;
    }

    protected void setChannelCreationOptions(OptionMap channelCreationOptions) {
        this.channelCreationOptions = channelCreationOptions;
    }

    protected void setConnectionCreationOptions(OptionMap connectionCreationOptions) {
        this.connectionCreationOptions = connectionCreationOptions;
    }

    protected void setConnectionTimeout(long timeout) {
        this.connectionTimeout = timeout;
    }

    protected void setCallbackHandler(ServiceRegistry serviceRegistry, String username, String securityRealmName) {
        this.callbackHandlerProvider = new CallbackHandlerProvider(serviceRegistry, username, securityRealmName);
    }

    protected static OptionMap getOptionMapFromProperties(Properties properties, ClassLoader classLoader) {
        OptionMap.Builder optionMapBuilder = OptionMap.builder();
        for (String propertyName : properties.stringPropertyNames()) {
            try {
                Option option = Option.fromString((String)propertyName, (ClassLoader)classLoader);
                optionMapBuilder.parse(option, properties.getProperty(propertyName), classLoader);
            }
            catch (IllegalArgumentException e) {
                EjbLogger.EJB3_LOGGER.failedToCreateOptionForProperty(propertyName, e.getMessage());
            }
        }
        return optionMapBuilder.getMap();
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName("anonymous");
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    rcb.setText(rcb.getDefaultText());
                    continue;
                }
                throw EjbLogger.ROOT_LOGGER.unsupportedCallback(current);
            }
        }
    }

    private class CallbackHandlerProvider {
        private final ServiceRegistry serviceRegistry;
        private final String userName;
        private final String securityRealmName;
        private final ServiceName securityRealmServiceName;

        CallbackHandlerProvider(ServiceRegistry serviceRegistry, String userName, String securityRealm) {
            this.serviceRegistry = serviceRegistry;
            this.userName = userName;
            this.securityRealmName = securityRealm;
            this.securityRealmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm});
        }

        CallbackHandler getCallbackHandler() {
            CallbackHandlerFactory cbhFactory;
            ServiceController securityRealmController = this.serviceRegistry.getService(this.securityRealmServiceName);
            if (securityRealmController == null) {
                return new AnonymousCallbackHandler();
            }
            SecurityRealm securityRealm = (SecurityRealm)securityRealmController.getValue();
            if (securityRealm != null && (cbhFactory = securityRealm.getSecretCallbackHandlerFactory()) != null && this.userName != null) {
                return cbhFactory.getCallbackHandler(this.userName);
            }
            return new AnonymousCallbackHandler();
        }
    }
}

