/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataOutput;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.network.ClientMapping;
import org.jboss.ejb.client.remoting.PackedInteger;

class ClusterTopologyWriter {
    private static final byte HEADER_COMPLETE_CLUSTER_TOPOLOGY = 21;
    private static final byte HEADER_CLUSTER_REMOVED = 22;
    private static final byte HEADER_NEW_NODES_ADDED = 23;
    private static final byte HEADER_NODES_REMOVED = 24;

    ClusterTopologyWriter() {
    }

    void writeCompleteClusterTopology(DataOutput output, Collection<Registry<String, List<ClientMapping>>> clientMappingsRegistries) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null dataoutput");
        }
        if (clientMappingsRegistries == null || clientMappingsRegistries.isEmpty()) {
            return;
        }
        output.write(21);
        PackedInteger.writePackedInteger((DataOutput)output, (int)clientMappingsRegistries.size());
        for (Registry<String, List<ClientMapping>> registry : clientMappingsRegistries) {
            output.writeUTF(registry.getName());
            this.writeClusterNodes(output, registry.getName(), registry.getEntries());
        }
    }

    void writeClusterRemoved(DataOutput output, Collection<Registry<String, List<ClientMapping>>> registries) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null dataoutput");
        }
        if (registries == null || registries.isEmpty()) {
            return;
        }
        output.write(22);
        PackedInteger.writePackedInteger((DataOutput)output, (int)registries.size());
        for (Registry<String, List<ClientMapping>> registry : registries) {
            output.writeUTF(registry.getName());
        }
    }

    void writeNewNodesAdded(DataOutput output, String clusterName, Map<String, List<ClientMapping>> clientMappings) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null dataoutput");
        }
        if (clientMappings.isEmpty()) {
            return;
        }
        output.write(23);
        PackedInteger.writePackedInteger((DataOutput)output, (int)1);
        output.writeUTF(clusterName);
        this.writeClusterNodes(output, clusterName, clientMappings);
    }

    void writeNodesRemoved(DataOutput output, String clusterName, Set<String> removedNodes) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null dataoutput");
        }
        if (removedNodes == null || removedNodes.isEmpty()) {
            return;
        }
        output.write(24);
        PackedInteger.writePackedInteger((DataOutput)output, (int)1);
        output.writeUTF(clusterName);
        int removedNodesCount = removedNodes.size();
        PackedInteger.writePackedInteger((DataOutput)output, (int)removedNodesCount);
        for (String node : removedNodes) {
            output.writeUTF(node);
        }
    }

    private void writeClusterNodes(DataOutput output, String clusterName, Map<String, List<ClientMapping>> clientMappings) throws IOException {
        int memberCount = clientMappings.size();
        PackedInteger.writePackedInteger((DataOutput)output, (int)memberCount);
        for (Map.Entry<String, List<ClientMapping>> entry : clientMappings.entrySet()) {
            String nodeName = entry.getKey();
            output.writeUTF(nodeName);
            List<ClientMapping> clientMappingsForNode = entry.getValue();
            if (clientMappingsForNode == null || clientMappingsForNode.isEmpty()) {
                throw new IllegalStateException("No client-mapping entries found for node " + nodeName + " in cluster " + clusterName);
            }
            PackedInteger.writePackedInteger((DataOutput)output, (int)clientMappingsForNode.size());
            for (ClientMapping clientMapping : clientMappingsForNode) {
                InetAddress clientNetworkAddress = clientMapping.getSourceNetworkAddress();
                int netMask = clientMapping.getSourceNetworkMaskBits();
                int netMaskAndIPFamilyDifferentiator = clientNetworkAddress instanceof Inet4Address ? netMask << 1 | 1 : netMask << 1;
                PackedInteger.writePackedInteger((DataOutput)output, (int)netMaskAndIPFamilyDifferentiator);
                output.write(clientNetworkAddress.getAddress());
                output.writeUTF(clientMapping.getDestinationAddress());
                output.writeShort(clientMapping.getDestinationPort());
            }
        }
    }
}

