/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public final class ReadAheadCache {
    private static final Object NULL_VALUE = new Object();
    private final JDBCStoreManager manager;
    private final Logger log;
    private TransactionLocal listMapTxLocal;
    private ListCache listCache;
    private int listCacheMax;

    public ReadAheadCache(JDBCStoreManager manager) {
        this.manager = manager;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public void create() {
        this.listCacheMax = ((JDBCEntityBridge)this.manager.getEntityBridge()).getListCacheMax();
        this.listCache = new ListCache(this.listCacheMax);
    }

    public void start() {
        this.listMapTxLocal = new TransactionLocal(this.manager.getComponent().getTransactionManager()){

            protected Object initialValue() {
                return new HashMap();
            }

            public Transaction getTransaction() {
                try {
                    return this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw CmpMessages.MESSAGES.errorGettingCurrentTransaction(e);
                }
            }
        };
        this.listCache.start();
    }

    public void stop() {
        this.listCache.clear();
    }

    public void destroy() {
        this.listCache = null;
    }

    public void addFinderResults(List results, JDBCReadAheadMetaData readahead) {
        if (this.listCacheMax == 0 || results.size() < 2) {
            return;
        }
        Map listMap = this.getListMap();
        if (listMap == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Add finder results: entity=" + this.manager.getEntityBridge().getEntityName() + " results=" + results + " readahead=" + readahead));
        }
        if (!readahead.isNone()) {
            this.listCache.add(results);
        }
        HashSet<List> dereferencedResults = new HashSet<List>();
        Iterator iter = results.iterator();
        int i = 0;
        while (iter.hasNext()) {
            EntityMapEntry entry;
            Object pk = iter.next();
            EntityMapEntry oldInfo = listMap.put(pk, entry = readahead.isNone() ? new EntityMapEntry(0, Collections.singletonList(pk), readahead) : new EntityMapEntry(i, results, readahead));
            if (oldInfo != null) {
                dereferencedResults.add(oldInfo.results);
            }
            ++i;
        }
        if (dereferencedResults.isEmpty()) {
            return;
        }
        iter = dereferencedResults.iterator();
        while (iter.hasNext()) {
            List dereferencedList = (List)iter.next();
            boolean listHasReference = false;
            Iterator iter2 = dereferencedList.iterator();
            while (!listHasReference && iter2.hasNext()) {
                EntityMapEntry entry = (EntityMapEntry)listMap.get(iter2.next());
                if (entry == null || entry.results != dereferencedList) continue;
                listHasReference = true;
            }
            if (!listHasReference) continue;
            iter.remove();
        }
        if (dereferencedResults.isEmpty()) {
            return;
        }
        for (List list : dereferencedResults) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Removing dereferenced results: " + list));
            }
            this.listCache.remove(list);
        }
    }

    private void removeFinderResult(List results) {
        Map listMap = this.getListMap();
        if (listMap == null) {
            return;
        }
        this.listCache.remove(results);
        if (!listMap.isEmpty()) {
            Iterator iter = listMap.values().iterator();
            while (iter.hasNext()) {
                EntityMapEntry entry = (EntityMapEntry)iter.next();
                if (entry.results != results) continue;
                iter.remove();
            }
        }
    }

    public EntityReadAheadInfo getEntityReadAheadInfo(Object pk) {
        Map listMap = this.getListMap();
        if (listMap == null) {
            return new EntityReadAheadInfo((List)Collections.singletonList(pk));
        }
        EntityMapEntry entry = (EntityMapEntry)this.getListMap().get(pk);
        if (entry != null) {
            JDBCReadAheadMetaData readahead;
            if (!entry.readahead.isNone()) {
                this.listCache.promote(entry.results);
            }
            if ((readahead = entry.readahead) == null) {
                readahead = this.manager.getMetaData().getReadAhead();
            }
            int from = entry.index;
            int to = Math.min(entry.results.size(), entry.index + readahead.getPageSize());
            List loadKeys = entry.results.subList(from, to);
            return new EntityReadAheadInfo(loadKeys, readahead);
        }
        return new EntityReadAheadInfo((List)Collections.singletonList(pk));
    }

    public boolean load(CmpEntityBeanContext ctx) {
        Map preloadDataMap;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("load data: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked()));
        }
        if ((preloadDataMap = this.getPreloadDataMap(ctx.getPrimaryKeyUnchecked(), false)) == null || preloadDataMap.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No preload data found: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked()));
            }
            return false;
        }
        boolean cleanReadAhead = this.manager.getMetaData().isCleanReadAheadOnLoad();
        boolean loaded = false;
        JDBCCMRFieldBridge onlyOneSingleValuedCMR = null;
        Iterator iter = preloadDataMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object field = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw CmpMessages.MESSAGES.preloadedValueNotFound();
            }
            if (cleanReadAhead) {
                iter.remove();
            }
            if (value == NULL_VALUE) {
                value = null;
            }
            if (field instanceof JDBCCMPFieldBridge) {
                JDBCCMPFieldBridge cmpField = (JDBCCMPFieldBridge)field;
                if (!cmpField.isLoaded(ctx)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Preloading data: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked() + " cmpField=" + cmpField.getFieldName()));
                    }
                    cmpField.setInstanceValue(ctx, value);
                    cmpField.setClean(ctx);
                    loaded = true;
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("CMPField already loaded: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked() + " cmpField=" + cmpField.getFieldName()));
                continue;
            }
            if (!(field instanceof JDBCCMRFieldBridge)) continue;
            JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)field;
            if (!cmrField.isLoaded(ctx)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Preloading data: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked() + " cmrField=" + cmrField.getFieldName()));
                }
                cmrField.load(ctx, (List)value);
                JDBCStoreManager relatedManager = (JDBCStoreManager)cmrField.getRelatedCMRField().getManager();
                ReadAheadCache relatedReadAheadCache = relatedManager.getReadAheadCache();
                relatedReadAheadCache.addFinderResults((List)value, cmrField.getReadAhead());
                if (loaded) continue;
                if (cmrField.isSingleValued() && onlyOneSingleValuedCMR == null) {
                    onlyOneSingleValuedCMR = cmrField;
                    continue;
                }
                loaded = true;
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("CMRField already loaded: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + ctx.getPrimaryKeyUnchecked() + " cmrField=" + cmrField.getFieldName()));
        }
        if (cleanReadAhead) {
            this.manager.removeEntityTxData(new PreloadKey(ctx.getPrimaryKeyUnchecked()));
        }
        return loaded;
    }

    public Collection getCachedCMRValue(Object pk, JDBCCMRFieldBridge cmrField) {
        Map preloadDataMap = this.getPreloadDataMap(pk, true);
        return (Collection)preloadDataMap.get(cmrField);
    }

    public void addPreloadData(Object pk, JDBCFieldBridge field, Object fieldValue) {
        if (field instanceof JDBCCMRFieldBridge) {
            if (fieldValue == null) {
                fieldValue = Collections.EMPTY_LIST;
            } else if (!(fieldValue instanceof Collection)) {
                fieldValue = Collections.singletonList(fieldValue);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Add preload data: entity=" + this.manager.getEntityBridge().getEntityName() + " pk=" + pk + " field=" + field.getFieldName()));
        }
        if (fieldValue == null) {
            fieldValue = NULL_VALUE;
        }
        Map preloadDataMap = this.getPreloadDataMap(pk, true);
        Object overridden = preloadDataMap.put(field, fieldValue);
        if (this.log.isTraceEnabled() && overridden != null) {
            this.log.trace((Object)("Overriding cached value " + overridden + " with " + (fieldValue == NULL_VALUE ? null : fieldValue) + ". pk=" + pk + ", field=" + field.getFieldName()));
        }
    }

    public void removeCachedData(Object primaryKey) {
        Map listMap;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing cached data for " + primaryKey));
        }
        if ((listMap = this.getListMap()) == null) {
            return;
        }
        this.manager.removeEntityTxData(new PreloadKey(primaryKey));
        EntityMapEntry oldInfo = (EntityMapEntry)listMap.remove(primaryKey);
        if (oldInfo == null || oldInfo.readahead.isNone()) {
            return;
        }
        for (EntityMapEntry entry : listMap.values()) {
            if (entry.results != oldInfo.results) continue;
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing dereferenced finder results: " + oldInfo.results));
        }
        this.listCache.remove(oldInfo.results);
    }

    public Map getPreloadDataMap(Object entityPrimaryKey, boolean create) {
        HashMap preloadDataMap;
        PreloadKey preloadKey = new PreloadKey(entityPrimaryKey);
        SoftReference ref = (SoftReference)this.manager.getEntityTxData(preloadKey);
        if (ref != null && (preloadDataMap = (HashMap)ref.get()) != null) {
            return preloadDataMap;
        }
        if (ref != null) {
            this.manager.removeEntityTxData(preloadKey);
        }
        if (!create) {
            return null;
        }
        preloadDataMap = new HashMap();
        ref = new SoftReference(preloadDataMap);
        this.manager.putEntityTxData(preloadKey, ref);
        return preloadDataMap;
    }

    private Map getListMap() {
        return (Map)this.listMapTxLocal.get();
    }

    private static final class IdentityObject {
        private final Object object;

        public IdentityObject(Object object) {
            if (object == null) {
                throw CmpMessages.MESSAGES.objectIsNull();
            }
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean equals(Object object) {
            return this.object == object;
        }

        public int hashCode() {
            return this.object.hashCode();
        }

        public String toString() {
            return this.object.toString();
        }
    }

    public static final class EntityReadAheadInfo {
        private final List loadKeys;
        private final JDBCReadAheadMetaData readahead;

        private EntityReadAheadInfo(List loadKeys) {
            this(loadKeys, (JDBCReadAheadMetaData)null);
        }

        private EntityReadAheadInfo(List loadKeys, JDBCReadAheadMetaData r) {
            this.loadKeys = loadKeys;
            this.readahead = r;
        }

        public List getLoadKeys() {
            return this.loadKeys;
        }

        public JDBCReadAheadMetaData getReadAhead() {
            return this.readahead;
        }
    }

    private static final class EntityMapEntry {
        public final int index;
        public final List results;
        public final JDBCReadAheadMetaData readahead;

        private EntityMapEntry(int index, List results, JDBCReadAheadMetaData readahead) {
            this.index = index;
            this.results = results;
            this.readahead = readahead;
        }
    }

    private static final class PreloadKey {
        private final Object entityPrimaryKey;

        public PreloadKey(Object entityPrimaryKey) {
            if (entityPrimaryKey == null) {
                throw CmpMessages.MESSAGES.entityPrimaryKeyIsNull();
            }
            this.entityPrimaryKey = entityPrimaryKey;
        }

        public boolean equals(Object object) {
            if (object instanceof PreloadKey) {
                PreloadKey preloadKey = (PreloadKey)object;
                return preloadKey.entityPrimaryKey.equals(this.entityPrimaryKey);
            }
            return false;
        }

        public int hashCode() {
            return this.entityPrimaryKey.hashCode();
        }

        public String toString() {
            return "PreloadKey: entityId=" + this.entityPrimaryKey;
        }
    }

    private final class ListCache {
        private TransactionLocal cacheTxLocal;
        private final int max;

        public ListCache(int max) {
            if (max < 0) {
                throw CmpMessages.MESSAGES.listCacheMaxIsNegative(max);
            }
            this.max = max;
        }

        public void add(List list) {
            if (this.max == 0) {
                return;
            }
            LinkedList cache = this.getCache();
            if (cache == null) {
                return;
            }
            cache.addFirst(new IdentityObject(list));
            while (cache.size() > this.max) {
                IdentityObject object = (IdentityObject)cache.removeLast();
                this.ageOut((List)object.getObject());
            }
        }

        public void promote(List list) {
            if (this.max == 0) {
                return;
            }
            LinkedList cache = this.getCache();
            if (cache == null) {
                return;
            }
            IdentityObject object = new IdentityObject(list);
            if (cache.remove(object)) {
                cache.addFirst(object);
            }
        }

        public void remove(List list) {
            if (this.max == 0) {
                return;
            }
            LinkedList cache = this.getCache();
            if (cache != null) {
                cache.remove(new IdentityObject(list));
            }
        }

        public void clear() {
            if (this.max == 0) {
                return;
            }
        }

        private void ageOut(List list) {
            ReadAheadCache.this.removeFinderResult(list);
        }

        private LinkedList getCache() {
            return (LinkedList)this.cacheTxLocal.get();
        }

        public void start() {
            this.cacheTxLocal = new TransactionLocal(ReadAheadCache.this.manager.getComponent().getTransactionManager()){

                protected Object initialValue() {
                    return new LinkedList();
                }

                public Transaction getTransaction() {
                    try {
                        return this.transactionManager.getTransaction();
                    }
                    catch (SystemException e) {
                        throw CmpMessages.MESSAGES.errorGettingCurrentTransaction(e);
                    }
                }
            };
        }
    }
}

