/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.ComplianceServicesImpl;
import com.iplanet.am.sdk.ldap.NamingAttributeManager;
import com.iplanet.am.util.Cache;
import com.iplanet.ums.Guid;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSEntry;
import java.util.HashMap;
import java.util.Map;

public class SearchFilterManager {
    private static final String ROOT_SUFFIX_DN = new DN(SMSEntry.getAMSdkBaseDN()).toRFCString().toLowerCase();
    private static Debug debug = CommonUtils.getDebugInstance();
    private static final String USER_SEARCH_TEMPLATE = "BasicUserSearch";
    private static final String ROLE_SEARCH_TEMPLATE = "BasicManagedRoleSearch";
    private static final String FILTERED_ROLE_SEARCH_TEMPLATE = "BasicFilteredRoleSearch";
    private static final String GROUP_SEARCH_TEMPLATE = "BasicGroupSearch";
    private static final String DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicDynamicGroupSearch";
    private static final String ORGANIZATION_SEARCH_TEMPLATE = "BasicOrganizationSearch";
    private static final String PEOPLE_CONTAINER_SEARCH_TEMPLATE = "BasicPeopleContainerSearch";
    private static final String ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE = "BasicOrganizationalUnitSearch";
    private static final String ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE = "BasicAssignableDynamicGroupSearch";
    private static final String GROUP_CONTAINER_SEARCH_TEMPLATE = "BasicGroupContainerSearch";
    private static final String RESOURCE_SEARCH_TEMPLATE = "BasicResourceSearch";
    private static final String DEFAULT_USER_SEARCH_FILTER = "(objectclass=inetorgperson)";
    private static final String DEFAULT_ROLE_SEARCH_FILTER = "(objectclass=nsmanagedroledefinition)";
    private static final String DEFAULT_FILTERED_ROLE_SEARCH_FILTER = "(&(objectclass=nsfilteredroledefinition)(!(cn=ContainerDefaultTemplateRole)))";
    private static final String DEFAULT_GROUP_SEARCH_FILTER = "(objectclass=groupofuniquenames)";
    private static final String DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=iplanet-am-managed-assignable-group)";
    private static final String DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER = "(objectclass=groupofurls)";
    private static final String DEFAULT_ORGANIZATION_SEARCH_FILTER = "(objectclass=organization)";
    private static final String DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER = "(objectclass=nsManagedPeopleContainer)";
    private static final String DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER = "(objectclass=organizationalunit)";
    private static final String DEFAULT_GROUP_CONTAINER_SEARCH_FILTER = "(objectclass=iplanet-am-managed-group-container)";
    public static Map searchtemplateMap = new HashMap();
    private static Cache searchfilterMap = new Cache(1000);

    static String getSearchFilterFromTemplate(int objectType, String orgDN, String searchTemplateName) {
        SearchTemplate searchTemp;
        block7: {
            searchTemp = null;
            try {
                String searchTempName;
                String string = searchTempName = searchTemplateName == null ? SearchFilterManager.getSearchTemplateName(objectType) : searchTemplateName;
                if (searchTempName == null) {
                    debug.warning("SearchFilterManager.getSearchFilterFromTemplate(): Search template name is null. Unable to retrieve search filter. Returning <empty> value.");
                    return "";
                }
                TemplateManager mgr = TemplateManager.getTemplateManager();
                Guid orgGuid = orgDN == null ? null : new Guid(orgDN);
                searchTemp = mgr.getSearchTemplate(searchTempName, orgGuid, 2);
            }
            catch (UMSException ue) {
                if (!debug.messageEnabled()) break block7;
                debug.message("SearchFilterManager.getSearchFilterFromTemplate() Got Exception", (Throwable)ue);
            }
        }
        String filter = searchTemp != null ? searchTemp.getSearchFilter() : "(objectclass=*)";
        if (!filter.startsWith("(") || !filter.endsWith(")")) {
            filter = "(" + filter + ")";
        }
        if (debug.messageEnabled()) {
            if (searchTemp != null) {
                debug.message("SearchFilterManager.getSearchFilterFromTemplate() SearchTemplate Name = " + searchTemp.getName() + ", objectType = " + objectType + ", orgDN = " + orgDN + ", Obtained Filter = " + searchTemp.getSearchFilter() + ", Modified Filter = " + filter);
            } else {
                debug.message("SearchFilterManager.getSearchFilterFromTemplate() Filter = " + filter);
            }
        }
        return filter;
    }

    private static String modifyFilter(String filter, int objectType) {
        switch (objectType) {
            case 6: 
            case 8: {
                StringBuffer sb = new StringBuffer();
                sb.append("(&").append(filter);
                sb.append("(objectClass=ldapsubentry)").append("(!(cn=");
                sb.append("ContainerDefaultTemplateRole");
                sb.append(")))");
                return sb.toString();
            }
        }
        return filter;
    }

    public static String getSearchFilter(int objectType, String orgDN, String searchTemplateName, boolean ignoreComplianceFilter) {
        String cacheKey;
        String filter;
        String organizationDN = new DN(orgDN).toRFCString();
        if (orgDN != null && organizationDN.equals(ROOT_SUFFIX_DN)) {
            orgDN = null;
        }
        if ((filter = (String)searchfilterMap.get(cacheKey = new Integer(objectType).toString() + ":" + searchTemplateName + ":" + organizationDN)) == null) {
            filter = SearchFilterManager.getSearchFilterFromTemplate(objectType, orgDN, searchTemplateName);
            searchfilterMap.put(cacheKey, filter);
        }
        filter = SearchFilterManager.modifyFilter(filter, objectType);
        filter = SearchFilterManager.addAdminGroupFilters(filter, orgDN, objectType);
        filter = SearchFilterManager.addComplianceModeFilters(filter, objectType, ignoreComplianceFilter);
        return filter;
    }

    private static String addAdminGroupFilters(String originalFilter, String orgDN, int objectType) {
        block7: {
            try {
                if (!ComplianceServicesImpl.isAdminGroupsEnabled(orgDN)) {
                    String modifiedFilter = originalFilter;
                    switch (objectType) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            StringBuffer sb = new StringBuffer();
                            sb.append("(&").append(originalFilter).append("(!(");
                            sb.append(NamingAttributeManager.getNamingAttribute(12));
                            sb.append("=serviceadministrators))").append("(!(");
                            sb.append(NamingAttributeManager.getNamingAttribute(12));
                            sb.append("=servicehelpdeskadministrators)))");
                            modifiedFilter = sb.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SearchFilterManager.addAdminGroupFilters() - objectType = " + objectType + ", orgDN = " + orgDN + ", Original filter: " + originalFilter + ", Modified filter = " + modifiedFilter);
                    }
                    return modifiedFilter;
                }
            }
            catch (AMException ae) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("SearchFilterManager.addAdminGroupFilters() Unable to determine if \"Admin Groups\" option is enabled or disabled. Exception : ", (Throwable)ae);
            }
        }
        return originalFilter;
    }

    private static String addComplianceModeFilters(String originalFilter, int objectType, boolean ignoreComplianceFilter) {
        block9: {
            try {
                String modifiedFilter = originalFilter;
                if (!ignoreComplianceFilter && ComplianceServicesImpl.isComplianceUserDeletionEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    switch (objectType) {
                        case 1: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetuserstatus=deleted)))");
                            modifiedFilter = sb.toString();
                            break;
                        }
                        case 2: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetdomainstatus=deleted)))");
                            modifiedFilter = sb.toString();
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            sb.append("(&").append(originalFilter);
                            sb.append("(!(inetgroupstatus=deleted)))");
                            modifiedFilter = sb.toString();
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SearchFilterManager.addComplainceModeFilters() - objectType = " + objectType + ", Original Filter = " + originalFilter + ", Modified Filter = " + modifiedFilter);
                    }
                    return modifiedFilter;
                }
            }
            catch (AMException ae) {
                if (!debug.warningEnabled()) break block9;
                debug.warning("SearchFilterManager.addComplianceModeFilters() Unable to determine if \"User Compliance deletion mode\" is enabled or disabled. Exception : ", (Throwable)ae);
            }
        }
        return originalFilter;
    }

    private static String getSearchTemplateName(int objectType) {
        String st = (String)CommonUtils.searchtemplateMap.get(Integer.toString(objectType));
        if (st != null) {
            return st;
        }
        switch (objectType) {
            case 1: {
                return USER_SEARCH_TEMPLATE;
            }
            case 6: {
                return ROLE_SEARCH_TEMPLATE;
            }
            case 8: {
                return FILTERED_ROLE_SEARCH_TEMPLATE;
            }
            case 9: {
                return GROUP_SEARCH_TEMPLATE;
            }
            case 11: {
                return DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 2: {
                return ORGANIZATION_SEARCH_TEMPLATE;
            }
            case 5: {
                return PEOPLE_CONTAINER_SEARCH_TEMPLATE;
            }
            case 3: {
                return ORGANIZATIONAL_UNIT_SEARCH_TEMPLATE;
            }
            case 12: {
                return ASSIGNABLE_DYNAMIC_GROUP_SEARCH_TEMPLATE;
            }
            case 4: {
                return GROUP_CONTAINER_SEARCH_TEMPLATE;
            }
            case 21: {
                return RESOURCE_SEARCH_TEMPLATE;
            }
        }
        debug.warning("SearchFilterManager.getSearchTemplateName(): Unknown object type is passed. Returning null value");
        return null;
    }

    private static String getDefaultSearchFilter(int objectType) {
        switch (objectType) {
            case 1: {
                return DEFAULT_USER_SEARCH_FILTER;
            }
            case 6: {
                return DEFAULT_ROLE_SEARCH_FILTER;
            }
            case 8: {
                return DEFAULT_FILTERED_ROLE_SEARCH_FILTER;
            }
            case 9: {
                return DEFAULT_GROUP_SEARCH_FILTER;
            }
            case 12: {
                return DEFAULT_ASSIGNABLE_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 11: {
                return DEFAULT_DYNAMIC_GROUP_SEARCH_FILTER;
            }
            case 2: {
                return DEFAULT_ORGANIZATION_SEARCH_FILTER;
            }
            case 5: {
                return DEFAULT_PEOPLE_CONTAINER_SEARCH_FILTER;
            }
            case 3: {
                return DEFAULT_ORGANIZATIONAL_UNIT_SEARCH_FILTER;
            }
            case 4: {
                return DEFAULT_GROUP_CONTAINER_SEARCH_FILTER;
            }
        }
        debug.warning("SearchFilterManager.getDefaultSearchFilter(): Unknown object type is passed. Returning <empty> value");
        return "";
    }

    public static String getSearchFilter(int objectType, String orgDN) {
        return SearchFilterManager.getSearchFilter(objectType, orgDN, null, true);
    }

    public static String getGlobalSearchFilter(int objectType) {
        return SearchFilterManager.getGlobalSearchFilter(objectType, null);
    }

    public static String getGlobalSearchFilter(int objectType, String searchTemplateName) {
        return SearchFilterManager.getSearchFilter(objectType, null, searchTemplateName, true);
    }
}

