/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACITargetExpression;
import com.iplanet.services.ldap.aci.ACR;
import com.iplanet.services.ldap.aci.ACRParser;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import java.util.ArrayList;
import java.util.Collection;

class ACIParser {
    ACIParser() {
    }

    static ACI parseACI(String aciText) throws ACIParseException {
        ACI aci = new ACI();
        aci.setACIText(aciText);
        if (aciText == null) {
            throw new ACIParseException("Malformed aci");
        }
        aciText = aciText.trim();
        int length = aciText.length();
        if (aciText.length() == 0) {
            throw new ACIParseException("Malformed aci:aci is blank");
        }
        if (aciText.charAt(0) != '(' || aciText.charAt(length - 1) != ')') {
            throw new ACIParseException("Malformed aci: aci not enclosed in parenthesis");
        }
        ArrayList topLevelSubExpressions = ACIParser.getSubExpressions(aciText);
        if (topLevelSubExpressions.size() > 5) {
            throw new ACIParseException("Malformed aci: more than 5 toplevel subexpressions");
        }
        for (int i = 0; i < topLevelSubExpressions.size(); ++i) {
            String subExpression = (String)topLevelSubExpressions.get(i);
            if (subExpression.length() < 6) {
                throw new ACIParseException("Malformed aci:too short to be valid");
            }
            String lcSubExpression = subExpression.substring(1).toLowerCase().trim();
            if (lcSubExpression.indexOf("target") == 0) {
                ACITargetExpression aciTargetExpression = ACITargetExpression.valueOf(subExpression);
                if (aciTargetExpression.getKeyword().equals("target")) {
                    if (aciTargetExpression.getOperator().equals("=")) {
                        aci.setTarget(aciTargetExpression.getValue());
                        continue;
                    }
                    throw new ACIParseException("Unsupported operator for : target");
                }
                if (aciTargetExpression.getKeyword().equals("targetfilter")) {
                    if (aciTargetExpression.getOperator().equals("=")) {
                        aci.setTargetFilter(aciTargetExpression.getValue());
                        continue;
                    }
                    throw new ACIParseException("Unsupported operator for : targetfilter");
                }
                if (aciTargetExpression.getKeyword().equals("targetattrfilters")) {
                    if (aciTargetExpression.getOperator().equals("=")) {
                        aci.setTargetAttrFilters(aciTargetExpression.getValue());
                        continue;
                    }
                    throw new ACIParseException("Unsupported operator for : targetattrfilters");
                }
                if (aciTargetExpression.getKeyword().equals("targetattr")) {
                    boolean exclusive = false;
                    QualifiedCollection qc = null;
                    Collection collection = null;
                    if (aciTargetExpression.getOperator().equals("=")) {
                        exclusive = false;
                        collection = ACIParser.getTokens(aciTargetExpression.getValue(), "||");
                        qc = new QualifiedCollection(collection, exclusive);
                        aci.setTargetAttributes(qc);
                        continue;
                    }
                    if (aciTargetExpression.getOperator().equals("!=")) {
                        exclusive = true;
                        collection = ACIParser.getTokens(aciTargetExpression.getValue(), "||");
                        qc = new QualifiedCollection(collection, exclusive);
                        aci.setTargetAttributes(qc);
                        continue;
                    }
                    throw new ACIParseException("Unsupported operator for : targetattr");
                }
                throw new ACIParseException("Unsupported keyword : " + aciTargetExpression.getKeyword());
            }
            if (lcSubExpression.indexOf("version") == 0) {
                ACR acr = ACRParser.parse(subExpression);
                aci.setACR(acr);
                continue;
            }
            throw new ACIParseException("Malformed aci:invalid toplevel subexpression");
        }
        if (aci.getPermissions() == null) {
            throw new ACIParseException("permissions not defined");
        }
        return aci;
    }

    static ArrayList getSubExpressions(String text) throws ACIParseException {
        int i;
        ArrayList<String> subExpressions = new ArrayList<String>();
        int length = (text = text.trim()).length();
        if (length <= 0) {
            return subExpressions;
        }
        if (text.charAt(0) != '(' || text.charAt(length - 1) != ')') {
            throw new ACIParseException("Unmatched parenthesis");
        }
        boolean quoted = false;
        int parenthCount = 0;
        for (i = 0; i < length; ++i) {
            if (text.charAt(i) == '\"') {
                quoted = !quoted;
            } else if (!quoted && text.charAt(i) == '(') {
                ++parenthCount;
            } else if (!quoted && text.charAt(i) == ')') {
                --parenthCount;
            }
            if (parenthCount == 0) break;
        }
        if (parenthCount != 0) {
            throw new ACIParseException("Unmatched \" or parenthesis ");
        }
        subExpressions.add(text.substring(0, i + 1));
        if (i + 1 < length) {
            subExpressions.addAll(ACIParser.getSubExpressions(text.substring(i + 1)));
        }
        return subExpressions;
    }

    static Collection getTokens(String text, String separator) {
        int index = 0;
        int startIndex = 0;
        int tokenSize = separator.length();
        ArrayList<String> tokens = new ArrayList<String>();
        while ((index = text.indexOf(separator, startIndex)) != -1) {
            tokens.add(text.substring(startIndex, index).trim());
            startIndex = index + tokenSize;
        }
        tokens.add(text.substring(startIndex));
        return tokens;
    }
}

