/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.datastore;

import com.sun.identity.authentication.modules.datastore.DataStorePrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceConfig;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class DataStore
extends AMLoginModule {
    ResourceBundle bundle = null;
    protected String validatedUserID;
    private String userName;
    private String userPassword;
    private ServiceConfig sc;
    private int currentState;
    private String currentConfigName;
    private static String AUTHLEVEL = "sunAMAuthDataStoreAuthLevel";
    private Map sharedState;
    public Map currentConfig;
    protected Debug debug = Debug.getInstance((String)this.amAuthDataStore);
    protected String amAuthDataStore = "amAuthDataStore";
    protected Principal userPrincipal;

    public void init(Subject subject, Map sharedState, Map options) {
        this.sc = (ServiceConfig)options.get("ServiceConfig");
        this.currentConfig = options;
        this.currentConfigName = (String)options.get("moduleInstanceName");
        String authLevel = CollectionHelper.getMapAttr((Map)options, (String)AUTHLEVEL);
        if (authLevel != null) {
            try {
                this.setAuthLevel(Integer.parseInt(authLevel));
            }
            catch (Exception e) {
                this.debug.error("Unable to set auth level " + authLevel, (Throwable)e);
            }
        }
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(this.amAuthDataStore, locale);
        if (this.debug.messageEnabled()) {
            this.debug.message("DataStore resbundle locale=" + locale);
        }
        this.sharedState = sharedState;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        this.currentState = state;
        int retVal = 0;
        Callback[] idCallbacks = new Callback[2];
        try {
            if (this.currentState == 1) {
                if (callbacks != null && callbacks.length == 0) {
                    this.userName = (String)this.sharedState.get(this.getUserKey());
                    this.userPassword = (String)this.sharedState.get(this.getPwdKey());
                    if (this.userName == null || this.userPassword == null) {
                        return 1;
                    }
                    NameCallback nameCallback = new NameCallback("dummy");
                    nameCallback.setName(this.userName);
                    idCallbacks[0] = nameCallback;
                    PasswordCallback passwordCallback = new PasswordCallback("dummy", false);
                    passwordCallback.setPassword(this.userPassword.toCharArray());
                    idCallbacks[1] = passwordCallback;
                } else {
                    idCallbacks = callbacks;
                    this.userName = ((NameCallback)callbacks[0]).getName();
                    this.userPassword = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
                }
                if (this.userPassword == null || this.userPassword.length() == 0) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("DataStore.process: Password is null/empty");
                    }
                    throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
                }
                this.storeUsernamePasswd(this.userName, this.userPassword);
                AMIdentityRepository idrepo = this.getAMIdentityRepository(this.getRequestOrg());
                boolean success = idrepo.authenticate(idCallbacks);
                if (!success) {
                    throw new AuthLoginException(this.amAuthDataStore, "authFailed", null);
                }
            } else {
                this.setFailureID(this.userName);
                throw new AuthLoginException(this.amAuthDataStore, "authFailed", null);
            }
            retVal = -1;
            this.validatedUserID = this.userName;
        }
        catch (IdRepoException ex) {
            this.debug.message("idRepo Exception");
            this.setFailureID(this.userName);
            throw new AuthLoginException(this.amAuthDataStore, "authFailed", null, ex);
        }
        return retVal;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new DataStorePrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.userName = null;
        this.userPassword = null;
        this.sc = null;
        this.sharedState = null;
        this.currentConfig = null;
        this.amAuthDataStore = null;
    }
}

