/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class LDAPCallbacks {
    private CallbackHandler callbackHandler;
    private static Debug debug = null;
    private String passwd;
    private String username;
    private String oldPassword;
    private String newPassword;
    private String confirmPassword;
    private ResourceBundle bundle;

    public LDAPCallbacks(CallbackHandler callbackHandler, ResourceBundle bundle) {
        this.callbackHandler = callbackHandler;
        this.bundle = bundle;
    }

    public void setLoginScreen() throws LoginException {
        this.loginCallbacks();
    }

    public void setPwdExpiryScreen() throws LoginException {
        this.chgPwdCallback();
    }

    public void sendMessage(int type, String msg) throws LoginException {
        this.messageCallback(type, msg);
    }

    protected String getUserName() {
        return this.username;
    }

    protected String getUserPWD() {
        return this.passwd;
    }

    protected String getOldPWD() {
        return this.oldPassword;
    }

    protected String getNewPWD() {
        return this.newPassword;
    }

    protected String getConfirmPWD() {
        return this.confirmPassword;
    }

    private void loginCallbacks() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        Callback[] callbacks = new Callback[]{new TextOutputCallback(0, "LDAP Authentication"), new NameCallback("Enter Username :"), new PasswordCallback("Enter Password :", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = new String(((NameCallback)callbacks[1]).getName());
            this.passwd = this.charToString(((PasswordCallback)callbacks[2]).getPassword(), callbacks[2]);
        }
        catch (IOException ioe) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException();
        }
    }

    private void chgPwdCallback() throws LoginException {
        Object pwd = null;
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        Callback[] callbacks = new Callback[]{new TextOutputCallback(0, "Change Password"), new PasswordCallback("EnterOld Password", false), new PasswordCallback("Enter New Password", false), new PasswordCallback("Confirm Password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.oldPassword = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
            this.newPassword = this.charToString(((PasswordCallback)callbacks[2]).getPassword(), callbacks[2]);
            this.confirmPassword = this.charToString(((PasswordCallback)callbacks[3]).getPassword(), callbacks[3]);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    private void messageCallback(int msgType, String msg) throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        try {
            Callback[] callbacks = new Callback[]{new TextOutputCallback(msgType, msg)};
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(this.bundle.getString("NoCallbackHandler"));
        }
        catch (IllegalArgumentException ill) {
            debug.message("message type missing");
            throw new LoginException(this.bundle.getString("IllegalArgs"));
        }
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthLDAP");
        }
    }
}

