/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.wizard;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.Crypt;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.config.wizard.LDAPStoreWizardPage;
import com.sun.identity.config.wizard.Wizard;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.util.DN;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import net.sf.click.control.ActionLink;

public class Step3
extends LDAPStoreWizardPage {
    public static final String LDAP_STORE_SESSION_KEY = "wizardCustomConfigStore";
    public ActionLink validateSMHostLink = new ActionLink("validateSMHost", (Object)this, "validateSMHost");
    public ActionLink validateRootSuffixLink = new ActionLink("validateRootSuffix", (Object)this, "validateRootSuffix");
    public ActionLink setReplicationLink = new ActionLink("setReplication", (Object)this, "setReplication");
    public ActionLink validateHostNameLink = new ActionLink("validateHostName", (Object)this, "validateHostName");
    public ActionLink validateConfigStoreHost = new ActionLink("validateConfigStoreHost", (Object)this, "validateConfigStoreHost");
    public ActionLink setConfigType = new ActionLink("setConfigType", (Object)this, "setConfigType");
    public ActionLink validateLocalPortLink = new ActionLink("validateLocalPort", (Object)this, "validateLocalPort");
    public ActionLink validateEncKey = new ActionLink("validateEncKey", (Object)this, "validateEncKey");
    private static final String QUOTE = "\"";
    private static final String SEPARATOR = "\" : \"";
    private String localRepPort;

    public void onInit() {
        String val = this.getAttribute("rootSuffix", Wizard.defaultRootSuffix);
        this.addModel("rootSuffix", val);
        val = this.getAttribute("encryptionKey", AMSetupServlet.getRandomString());
        this.addModel("encryptionKey", val);
        val = this.getAttribute("configStorePort", this.getAvailablePort(50389));
        this.addModel("configStorePort", val);
        this.addModel("localConfigPort", val);
        this.localRepPort = this.getAttribute("localRepPort", this.getAvailablePort(58989));
        this.addModel("localRepPort", this.localRepPort);
        val = this.getAttribute("existingPort", this.getAvailablePort(50389));
        this.addModel("existingPort", val);
        val = this.getAttribute("existingRepPort", this.getAvailablePort(58990));
        this.addModel("existingRepPort", val);
        val = this.getAttribute("configStoreSSL", "SIMPLE");
        this.addModel("configStoreSSL", val);
        if (val.equals("SSL")) {
            this.addModel("selectConfigStoreSSL", "checked=\"checked\"");
        } else {
            this.addModel("selectConfigStoreSSL", "");
        }
        val = this.getAttribute("DATA_STORE", "embedded");
        this.addModel("DATA_STORE", val);
        if (val.equals("embedded")) {
            this.addModel("selectEmbedded", "checked=\"checked\"");
            this.addModel("selectExternal", "");
        } else {
            this.addModel("selectEmbedded", "");
            this.addModel("selectExternal", "checked=\"checked\"");
        }
        val = this.getAttribute("configStoreHost", "localhost");
        this.addModel("configStoreHost", val);
        val = this.getAttribute("configStorePassword", Wizard.defaultPassword);
        this.addModel("configStorePassword", val);
        val = this.getAttribute("configStoreLoginId", Wizard.defaultUserName);
        this.addModel("configStoreLoginId", val);
        val = this.getAttribute("DS_EMB_REPL_FLAG", "");
        if (val.equals("embReplFlag")) {
            this.addModel("FIRST_INSTANCE", "1");
            this.addModel("selectFirstSetup", "");
            this.addModel("selectExistingSetup", "checked=\"checked\"");
        } else {
            this.addModel("FIRST_INSTANCE", "0");
            this.addModel("selectFirstSetup", "checked=\"checked\"");
            this.addModel("selectExistingSetup", "");
        }
        super.onInit();
    }

    public boolean setConfigType() {
        String type = this.toString("type");
        if (type.equals("remote")) {
            type = "dirServer";
        } else {
            type = "embedded";
            this.getContext().setSessionAttribute("configStoreHost", (Object)"localhost");
        }
        this.getContext().setSessionAttribute("DATA_STORE", (Object)type);
        return true;
    }

    public boolean setReplication() {
        String type = this.toString("multi");
        if (type.equals("enable")) {
            type = "embReplFlag";
        }
        this.getContext().setSessionAttribute("DS_EMB_REPL_FLAG", (Object)type);
        return true;
    }

    public boolean validateRootSuffix() {
        String rootsuffix = this.toString("rootSuffix");
        if (rootsuffix == null || rootsuffix.trim().length() == 0) {
            this.writeToResponse(this.getLocalizedString("missing.required.field"));
        } else if (!DN.isDN((String)rootsuffix)) {
            this.writeToResponse(this.getLocalizedString("invalid.dn"));
        } else {
            this.writeToResponse("true");
            this.getContext().setSessionAttribute("rootSuffix", (Object)rootsuffix);
        }
        this.setPath(null);
        return false;
    }

    public boolean validateLocalPort() {
        String port = this.toString("port");
        if (port == null) {
            this.writeToResponse(this.getLocalizedString("missing.required.field"));
        } else {
            try {
                int val = Integer.parseInt(port);
                if (val < 1 || val > 65535) {
                    this.writeToResponse(this.getLocalizedString("invalid.port.number"));
                } else {
                    boolean ok = false;
                    String type = (String)this.getContext().getSessionAttribute("DATA_STORE");
                    if (type == null || type.equals("embedded")) {
                        String host = (String)this.getContext().getSessionAttribute("configStoreHost");
                        if (host == null) {
                            host = "localhost";
                        }
                        if (AMSetupServlet.canUseAsPort(host, val)) {
                            ok = true;
                        } else {
                            this.writeToResponse(this.getLocalizedString("invalid.port.used"));
                        }
                    } else {
                        ok = true;
                    }
                    if (ok) {
                        this.getContext().setSessionAttribute("configStorePort", (Object)port);
                        this.writeToResponse("ok");
                    }
                }
            }
            catch (NumberFormatException e) {
                this.writeToResponse(this.getLocalizedString("invalid.port.number"));
            }
            catch (NullPointerException ne) {
                this.writeToResponse(this.getLocalizedString("invalid.port.number"));
            }
        }
        this.setPath(null);
        return false;
    }

    public boolean validateEncKey() {
        String key = this.toString("encKey");
        if (key == null) {
            this.writeToResponse(this.getLocalizedString("missing.required.field"));
        } else {
            this.getContext().setSessionAttribute("encryptionKey", (Object)key);
            if (key.length() < 10) {
                this.writeToResponse(this.getLocalizedString("enc.key.need.10.chars"));
            } else {
                this.writeToResponse("true");
            }
        }
        this.setPath(null);
        return false;
    }

    public boolean validateConfigStoreHost() {
        String host = this.toString("configStoreHost");
        if (host == null) {
            this.writeToResponse("missing.required.field");
        } else {
            this.getContext().setSessionAttribute("configStoreHost", (Object)host);
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (address.isReachable(300)) {
                this.writeToResponse("ok");
            } else {
                this.writeToResponse(this.getLocalizedString("contact.host.failed"));
            }
        }
        catch (UnknownHostException uhe) {
            this.writeToResponse(this.getLocalizedString("contact.host.unknown"));
        }
        catch (IOException ioe) {
            this.writeToResponse(this.getLocalizedString("contact.host.unreachable"));
        }
        catch (NullPointerException ne) {
            this.writeToResponse(this.getLocalizedString("contact.host.failed"));
        }
        this.setPath(null);
        return false;
    }

    public boolean validateHostName() {
        StringBuffer sb = new StringBuffer();
        String hostName = this.toString("hostName");
        if (hostName == null) {
            this.addObject(sb, "code", "100");
            this.addObject(sb, "message", this.getLocalizedString("missing.required.field"));
        } else {
            String admin = "amadmin";
            String password = (String)this.getContext().getSessionAttribute("ADMIN_PWD");
            try {
                Map data = AMSetupServlet.getRemoteServerInfo(hostName, admin, password);
                if (data != null && !data.isEmpty()) {
                    this.addObject(sb, "code", "100");
                    this.addObject(sb, "message", this.getLocalizedString("ok.string"));
                    this.setupDSParams(data);
                    String key = (String)data.get("enckey");
                    this.getContext().setSessionAttribute("encryptionKey", (Object)key);
                    this.getContext().setSessionAttribute("ENCLDAPUSERPASSWD", (Object)((String)data.get("ENCLDAPUSERPASSWD")));
                    String embedded = (String)data.get("dsisembedded");
                    this.addObject(sb, "embedded", embedded);
                    String host = (String)data.get("dshost");
                    if (embedded.equals("true")) {
                        this.getContext().setSessionAttribute("configStoreHost", (Object)this.getHostName());
                        this.addObject(sb, "configStoreHost", this.getHostName());
                        this.getContext().setSessionAttribute("DATA_STORE", (Object)"embedded");
                        this.getContext().setSessionAttribute("DS_EMB_REPL_FLAG", (Object)"embReplFlag");
                        String replAvailable = (String)data.get("dsreplportavailable");
                        if (replAvailable == null) {
                            replAvailable = "false";
                        }
                        this.addObject(sb, "replication", replAvailable);
                        String existingRep = (String)data.get("dsreplport");
                        this.getContext().setSessionAttribute("existingRepPort", (Object)existingRep);
                        this.addObject(sb, "replicationPort", existingRep);
                        String existingServerid = (String)data.get("existingserverid");
                        this.getContext().setSessionAttribute("existingserverid", (Object)existingServerid);
                        this.addObject(sb, "existingserverid", existingServerid);
                        this.getContext().setSessionAttribute("configStorePassword", (Object)password);
                    } else {
                        this.getContext().setSessionAttribute("configStorePort", (Object)((String)data.get("dsport")));
                        this.getContext().setSessionAttribute("configStoreHost", (Object)host);
                        this.addObject(sb, "configStoreHost", host);
                        String dsprot = (String)data.get("dsprotocol");
                        String dsSSL = "ldaps".equals(dsprot) ? "SSL" : "SIMPLE";
                        this.getContext().setSessionAttribute("configStoreSSL", (Object)dsSSL);
                        this.addObject(sb, "configStoreSSL", dsSSL);
                        String dspwd = (String)data.get("dspwd");
                        this.getContext().setSessionAttribute("configStorePassword", (Object)Crypt.decode((String)dspwd, (AMEncryption)Crypt.getHardcodedKeyEncryptor()));
                    }
                    String existing = (String)data.get("dsport");
                    this.getContext().setSessionAttribute("existingPort", (Object)existing);
                    this.addObject(sb, "existingPort", existing);
                    this.getContext().setSessionAttribute("existingStorePort", (Object)existing);
                    this.addObject(sb, "existingStorePort", existing);
                    this.getContext().setSessionAttribute("existingHost", (Object)host);
                    this.getContext().setSessionAttribute("existingStoreHost", (Object)host);
                    this.addObject(sb, "existingStoreHost", host);
                    this.getContext().setSessionAttribute("localRepPort", (Object)this.localRepPort);
                }
            }
            catch (ConfigurationException c) {
                String code = c.getErrorCode();
                String message = this.getLocalizedString(code);
                if (code == null) {
                    code = "999";
                    message = c.getMessage();
                }
                this.addObject(sb, "code", code);
                this.addObject(sb, "message", message);
            }
            catch (ConfiguratorException c) {
                String code = c.getErrorCode();
                String message = this.getLocalizedString(code);
                if (code == null) {
                    code = "999";
                    message = c.getMessage();
                }
                this.addObject(sb, "code", code);
                this.addObject(sb, "message", message);
            }
        }
        sb.append(" }");
        this.writeToResponse(sb.toString());
        this.setPath(null);
        return false;
    }

    private void addObject(StringBuffer sb, String key, String value) {
        if (sb.length() < 1) {
            sb.append("{ ");
        } else {
            sb.append(",");
        }
        sb.append(QUOTE).append(key).append(SEPARATOR).append(value).append(QUOTE);
    }

    private void setupDSParams(Map data) {
        String tmp = (String)data.get("dsbasedn");
        this.getContext().setSessionAttribute("rootSuffix", (Object)tmp);
        tmp = (String)data.get("dsmgr");
        this.getContext().setSessionAttribute("configStoreLoginId", (Object)tmp);
        tmp = (String)data.get("dspwd");
        this.getContext().setSessionAttribute("configStorePassword", (Object)tmp);
        this.getContext().setSessionAttribute("DATA_STORE", (Object)"dirServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean validateSMHost() {
        ctx = this.getContext();
        strSSL = (String)ctx.getSessionAttribute("configStoreSSL");
        ssl = strSSL != null && strSSL.equals("SSL") != false;
        host = (String)ctx.getSessionAttribute("configStoreHost");
        if (host == null) {
            host = "localhost";
        }
        if ((strPort = (String)ctx.getSessionAttribute("configStorePort")) == null) {
            strPort = this.getAvailablePort(50389);
        }
        port = Integer.parseInt(strPort);
        bindDN = (String)ctx.getSessionAttribute("configStoreLoginId");
        rootSuffix = (String)ctx.getSessionAttribute("rootSuffix");
        bindPwd = (String)ctx.getSessionAttribute("configStorePassword");
        if (bindDN == null) {
            bindDN = "cn=Directory Manager";
        }
        if (rootSuffix == null) {
            rootSuffix = "dc=opensso,dc=java,dc=net";
        }
        ld = null;
        try {
            ld = ssl != false ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            ld.setConnectTimeout(300);
            ld.connect(3, host, port, bindDN, bindPwd);
            filter = "cn=\"" + rootSuffix + "\"";
            attrs = new String[]{""};
            ld.search(rootSuffix, 0, filter, attrs, false);
            this.writeToResponse("ok");
        }
        catch (LDAPException lex) {
            switch (lex.getLDAPResultCode()) {
                case 91: {
                    this.writeToResponse(this.getLocalizedString("ldap.connect.error"));
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 81: {
                    this.writeToResponse(this.getLocalizedString("ldap.server.down"));
                    ** break;
lbl37:
                    // 1 sources

                    break;
                }
                case 34: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.dn"));
                    ** break;
lbl41:
                    // 1 sources

                    break;
                }
                case 32: {
                    this.writeToResponse(this.getLocalizedString("ldap.nosuch.object"));
                    ** break;
lbl45:
                    // 1 sources

                    break;
                }
                case 49: {
                    this.writeToResponse(this.getLocalizedString("ldap.invalid.credentials"));
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                case 53: {
                    this.writeToResponse(this.getLocalizedString("ldap.unwilling"));
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                case 48: {
                    this.writeToResponse(this.getLocalizedString("ldap.inappropriate"));
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 19: {
                    this.writeToResponse(this.getLocalizedString("ldap.constraint"));
                    ** break;
lbl61:
                    // 1 sources

                    break;
                }
                default: {
                    this.writeToResponse(this.getLocalizedString("cannot.connect.to.SM.datastore"));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.writeToResponse(this.getLocalizedString("cannot.connect.to.SM.datastore"));
        }
        finally {
            if (ld != null) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException ex) {}
            }
        }
        this.setPath(null);
        return false;
    }
}

