/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.base.model.AMServiceProfileModel;
import com.sun.identity.console.base.model.AMServiceProfileModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class AMServiceProfileViewBeanBase
extends AMPrimaryMastHeadViewBean {
    private static final String PGTITLE = "pgtitle";
    public static final String SERVICE_NAME = "serviceName";
    public static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    protected CCPageTitleModel ptModel;
    protected boolean initialized;
    protected boolean submitCycle;
    protected AMPropertySheetModel propertySheetModel;
    protected String serviceName;

    public AMServiceProfileViewBeanBase(String name, String url, String serviceName) {
        super(name);
        this.setDefaultDisplayURL(url);
        if (serviceName != null) {
            this.initialize(serviceName);
        }
    }

    public void setRequestContext(RequestContext rc) {
        super.setRequestContext(rc);
        if (this.serviceName != null) {
            this.initialize(this.serviceName);
        }
    }

    protected void initialize(String serviceName) {
        if (!this.initialized) {
            this.initialized = true;
            this.serviceName = serviceName;
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        if (this.propertySheetModel != null) {
            this.propertySheetModel.registerChildren((ContainerViewBase)this);
        }
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name))));
        return view;
    }

    public void setSubmitCycle(boolean cycle) {
        this.submitCycle = cycle;
    }

    protected boolean isSubmitCycle() {
        return this.submitCycle;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (this.propertySheetModel != null) {
            Map map;
            if (!this.submitCycle && (map = this.getAttributeValues()) != null) {
                AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
                ps.setAttributeValues(map, this.getModel());
            }
        } else {
            this.disableButton("button1", true);
            this.disableButton("button2", true);
            this.setInlineAlertMessage("info", "message.information", "propertysheet.no.attributes.message");
        }
    }

    public boolean beginPropertyDisplay(ChildDisplayEvent event) {
        return this.propertySheetModel != null;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        try {
            return new AMServiceProfileModelImpl(req, this.serviceName, this.getPageSessionAttributes());
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            return null;
        }
    }

    protected void createPageTitleModel() {
        this.createThreeButtonPageTitleModel();
    }

    protected void createTwoButtonPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            this.ptModel.setPageTitleText(model.getPageTitle());
            this.ptModel.setValue("button1", (Object)"button.save");
            this.ptModel.setValue("button2", (Object)"button.reset");
        }
    }

    protected void createThreeButtonPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            this.ptModel.setPageTitleText(model.getPageTitle());
            this.ptModel.setValue("button1", (Object)"button.save");
            this.ptModel.setValue("button2", (Object)"button.reset");
            this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
        }
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("breadcrumbs.services.config");
    }

    protected void createPropertyModel() {
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            try {
                this.propertySheetModel = new AMPropertySheetModel(this.getPropertySheetXML(model));
                this.propertySheetModel.clear();
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected String getPropertySheetXML(AMServiceProfileModel model) throws AMConsoleException {
        String realmName = (String)this.getPageSessionAttribute("CurrentProfileView");
        return model.getPropertySheetXML(realmName, ((Object)((Object)this)).getClass().getName(), this.serviceName);
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            try {
                Map values = this.getValues();
                this.onBeforeSaveProfile(values);
                model.setAttributeValues(values);
                this.setInlineAlertMessage("info", "message.information", "message.updated");
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.onBeforeResetProfile();
        this.propertySheetModel.clear();
        this.forwardTo();
    }

    protected Map getValues() throws ModelControlException, AMConsoleException {
        Map values = null;
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            values = ps.getAttributeValues(model.getAttributeValues(), model);
        }
        return values;
    }

    protected boolean onBeforeSaveProfile(Map attrValues) {
        return true;
    }

    protected void onBeforeResetProfile() {
    }

    public void handleDynLinkRequest(RequestInvocationEvent event) {
        this.submitCycle = true;
        RequestContext requestContext = this.getRequestContext();
        HttpServletRequest req = requestContext.getRequest();
        String attrName = req.getParameter("attrname");
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        if (model != null) {
            try {
                String url = this.appendPgSession(model.getPropertiesViewBean(attrName));
                requestContext.getResponse().sendRedirect(url);
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.forwardTo();
        }
    }

    protected Map getAttributeValues() {
        AMServiceProfileModel model = (AMServiceProfileModel)this.getModel();
        return model != null ? model.getAttributeValues() : Collections.EMPTY_MAP;
    }

    protected String getServiceNameForAccessControl() {
        return this.serviceName;
    }
}

