/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMTableTiledView;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.policy.RuleOpViewBeanBase;
import com.sun.identity.policy.ActionSchema;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCEditableListModel;
import com.sun.web.ui.view.editablelist.CCEditableList;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCSelectableList;
import java.util.Set;

public class ActionTiledView
extends AMTableTiledView {
    public ActionTiledView(View parent, CCActionTableModel model, String name) {
        super(parent, model, name);
        CCAddRemoveModel addRemoveModel = new CCAddRemoveModel();
        addRemoveModel.setShowMoveUpDownButtons("false");
        model.setModel("tblActionsSelectableListValue", (Object)addRemoveModel);
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        super.endDisplay((DisplayEvent)event);
        boolean display = true;
        int rowIndex = this.model.getRowIndex();
        if (rowIndex < this.model.getNumRows()) {
            String childName = event.getChildName();
            ActionSchema actionSchema = this.getActionSchema(rowIndex);
            AMDisplayType.getInstance();
            int type = AMDisplayType.getDisplayType(actionSchema);
            AMDisplayType.getInstance();
            int syntax = AMDisplayType.getDisplaySyntax(actionSchema);
            if (childName.indexOf("tblActionsRadioValue") != -1) {
                display = this.displayRadioAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsCheckBoxValue") != -1) {
                display = this.displayBooleanAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsPasswordValue") != -1) {
                display = this.displayPasswordAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsTextAreaValue") != -1) {
                display = this.displayTextAreaAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsTextValue") != -1) {
                display = this.displayTextFieldAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsDropDownMenuValue") != -1) {
                display = this.displaySingleChoiceAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsSelectableListValue") != -1) {
                display = this.displayMultipleChoiceAction(actionSchema, childName, type, syntax);
            } else if (childName.indexOf("tblActionsEditableListValue") != -1) {
                display = this.displayEditableListAction(actionSchema, childName, type, syntax);
            }
        }
        return display;
    }

    private ActionSchema getActionSchema(int i) {
        RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
        return parentVB.getActionSchema(i);
    }

    private boolean displayRadioAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display = false;
        RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
        String serviceType = (String)parentVB.propertySheetModel.getValue("tfServiceType");
        if (type == 0 && syntax == 6) {
            CCRadioButton rb = (CCRadioButton)this.getChild(childName);
            OptionList optList = parentVB.getChoiceValues(serviceType, actionSchema);
            rb.setOptions(optList);
            if (optList != null && optList.size() > 0) {
                Set set = parentVB.isSubmitCycle() ? parentVB.getCurrentActionValues(actionSchema) : parentVB.getDefaultActionValues(actionSchema);
                String value = set == null || set.isEmpty() ? optList.getValue(0) : (String)set.iterator().next();
                rb.setValue((Object)value);
                display = true;
            }
        }
        return display;
    }

    private boolean displaySingleChoiceAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display = false;
        RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
        String serviceType = (String)parentVB.propertySheetModel.getValue("tfServiceType");
        if (type == 1) {
            CCDropDownMenu list = (CCDropDownMenu)this.getChild(childName);
            OptionList optList = parentVB.getChoiceValues(serviceType, actionSchema);
            list.setOptions(optList);
            if (optList != null && optList.size() > 0) {
                if (!parentVB.isSubmitCycle()) {
                    Set set = parentVB.getDefaultActionValues(actionSchema);
                    String value = set == null || set.isEmpty() ? optList.getValue(0) : (String)set.iterator().next();
                    list.setValue((Object)value);
                }
                display = true;
            }
        }
        return display;
    }

    private boolean displayEditableListAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display;
        boolean bl = display = type == 3;
        if (display) {
            CCEditableList child = (CCEditableList)this.getChild(childName);
            child.resetStateData();
            CCEditableListModel m = (CCEditableListModel)this.model.getModel(childName);
            RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
            Set defaultValues = RuleOpViewBeanBase.getValues(m.getOptionList());
            if (defaultValues == null || defaultValues.isEmpty()) {
                defaultValues = parentVB.getDefaultActionValues(actionSchema);
                m.setOptionList(parentVB.createOptionList(defaultValues));
            }
        }
        return display;
    }

    private boolean displayMultipleChoiceAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display = false;
        RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
        String serviceType = (String)parentVB.propertySheetModel.getValue("tfServiceType");
        if (type == 2) {
            CCSelectableList child = (CCSelectableList)this.getChild(childName);
            child.resetStateData();
            CCAddRemoveModel addRemoveModel = (CCAddRemoveModel)this.model.getModel(childName);
            Set defaultValues = RuleOpViewBeanBase.getValues(addRemoveModel.getSelectedOptionList());
            if (defaultValues == null || defaultValues.isEmpty()) {
                defaultValues = parentVB.getDefaultActionValues(actionSchema);
            }
            OptionList optList = parentVB.getChoiceValues(serviceType, actionSchema);
            int sz = optList.size();
            OptionList availList = new OptionList();
            for (int i = 0; i < sz; ++i) {
                Option opt = optList.get(i);
                if (defaultValues.contains(opt.getValue())) continue;
                availList.add(opt);
            }
            addRemoveModel.setAvailableOptionList(availList);
            addRemoveModel.setSelectedOptionList(parentVB.createOptionList(defaultValues));
            display = true;
        }
        return display;
    }

    private boolean displayTextFieldAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display;
        boolean bl = display = type == 0 && syntax == 2;
        if (display) {
            this.setDisplayDefaultValue(actionSchema, childName);
        }
        return display;
    }

    private boolean displayBooleanAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display;
        boolean bl = display = type == 0 && syntax == 1;
        if (display) {
            RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
            Set set = !parentVB.isSubmitCycle() ? parentVB.getCurrentActionValues(actionSchema) : parentVB.getDefaultActionValues(actionSchema);
            String value = set != null && !set.isEmpty() ? (String)set.iterator().next() : "false";
            CCCheckBox cb = (CCCheckBox)this.getChild(childName);
            cb.setValue((Object)(value.equals("true") ? "true" : "false"));
        }
        return display;
    }

    private boolean displayPasswordAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display = syntax == 3 || syntax == 4;
        boolean bl = display = display && type == 0;
        if (display) {
            RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
            this.setDisplayDefaultValue(actionSchema, childName);
        }
        return display;
    }

    private boolean displayTextAreaAction(ActionSchema actionSchema, String childName, int type, int syntax) {
        boolean display;
        boolean bl = display = type == 0 && syntax == 5;
        if (display) {
            RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
            this.setDisplayDefaultValue(actionSchema, childName);
        }
        return display;
    }

    private void setDisplayDefaultValue(ActionSchema actionSchema, String childName) {
        RuleOpViewBeanBase parentVB = (RuleOpViewBeanBase)this.getParentViewBean();
        Set set = parentVB.getDefaultActionValues(actionSchema);
        if (set != null && !set.isEmpty()) {
            this.model.setValue(childName, (Object)((String)set.iterator().next()));
        }
    }
}

