/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.service;

import com.iplanet.dpro.parser.ParseOutput;
import com.iplanet.services.comm.share.Response;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.s1is.LogSSOTokenDetails;
import com.sun.identity.log.service.Log;
import com.sun.identity.log.service.LogOperation;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerLoggingHdlrEntryImpl;
import com.sun.identity.monitoring.SsoServerLoggingSvcImpl;
import com.sun.identity.shared.encode.Base64;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class LogRecWrite
implements LogOperation,
ParseOutput {
    String _logname;
    String _loggedBySid;
    Vector _records = new Vector();

    public Response execute() {
        Object[] parameters;
        Map logInfoMap;
        String msg;
        Level level;
        Logger logger;
        SsoServerLoggingHdlrEntryImpl slei;
        Response res;
        block19: {
            res = new Response("OK");
            SsoServerLoggingSvcImpl slsi = null;
            slei = null;
            if (Agent.isRunning()) {
                slsi = (SsoServerLoggingSvcImpl)Agent.getLoggingSvcMBean();
                slei = slsi.getHandler("Remote Handler");
            }
            logger = (Logger)Logger.getLogger(this._logname);
            if (Debug.messageEnabled()) {
                Debug.message("LogRecWrite: exec: logname = " + this._logname);
            }
            level = Level.parse(((com.sun.identity.log.service.LogRecord)this._records.elementAt((int)0)).level);
            msg = ((com.sun.identity.log.service.LogRecord)this._records.elementAt((int)0)).msg;
            logInfoMap = ((com.sun.identity.log.service.LogRecord)this._records.elementAt((int)0)).logInfoMap;
            parameters = ((com.sun.identity.log.service.LogRecord)this._records.elementAt((int)0)).parameters;
            try {
                msg = new String(Base64.decode((String)msg));
            }
            catch (RuntimeException ex) {
                if (!Debug.messageEnabled()) break block19;
                Debug.message("LogRecWrite: message is not base64 encoded");
            }
        }
        LogRecord rec = new LogRecord(level, msg);
        if (logInfoMap != null) {
            String loginIDSid = (String)logInfoMap.get("LoginIDSid");
            if (loginIDSid != null && loginIDSid.length() > 0) {
                SSOToken loginIDToken = null;
                try {
                    SSOTokenManager ssom = SSOTokenManager.getInstance();
                    loginIDToken = ssom.createSSOToken(loginIDSid);
                }
                catch (SSOException e) {
                    if (Debug.warningEnabled()) {
                        Debug.warning("LogService::process(): SSOException", (Throwable)((Object)e));
                    }
                    rec.setLogInfoMap(logInfoMap);
                }
                if (loginIDToken != null) {
                    rec = LogSSOTokenDetails.logSSOTokenInfo(rec, loginIDToken);
                    Set keySet = logInfoMap.keySet();
                    Iterator i = keySet.iterator();
                    String key = null;
                    String value = null;
                    while (i.hasNext()) {
                        block20: {
                            key = (String)i.next();
                            value = (String)logInfoMap.get(key);
                            if (value == null || value.length() <= 0) continue;
                            if (key.equalsIgnoreCase("Data")) {
                                try {
                                    value = new String(Base64.decode((String)value));
                                }
                                catch (RuntimeException ex) {
                                    if (!Debug.messageEnabled()) break block20;
                                    Debug.message("LogRecWrite: data is not base64 encoded");
                                }
                            }
                        }
                        rec.addLogInfo(key, value);
                    }
                }
            } else {
                rec.setLogInfoMap(logInfoMap);
            }
        }
        rec.setParameters(parameters);
        SSOToken loggedByToken = null;
        try {
            SSOTokenManager ssom = SSOTokenManager.getInstance();
            loggedByToken = ssom.createSSOToken(this._loggedBySid);
        }
        catch (SSOException ssoe) {
            Debug.error("LogRecWrite: exec:SSOException: ", (Throwable)((Object)ssoe));
        }
        if (Agent.isRunning()) {
            slei.incHandlerRequestCount(1);
        }
        logger.log(rec, loggedByToken);
        if (Agent.isRunning()) {
            slei.incHandlerSuccessCount(1);
        }
        return res;
    }

    public void process(String name, Vector elems, Hashtable atts, String pcdata) {
        this._logname = ((Log)elems.elementAt((int)0))._logname;
        this._loggedBySid = ((Log)elems.elementAt((int)0))._loggedBySid;
        for (int i = 1; i < elems.size(); ++i) {
            com.sun.identity.log.service.LogRecord lr = (com.sun.identity.log.service.LogRecord)elems.elementAt(i);
            this._records.addElement(lr);
        }
    }
}

