/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SsoServerAuthModulesEntryImpl;
import com.sun.identity.monitoring.SsoServerAuthSvc;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import javax.management.MBeanServer;

public class SsoServerAuthSvcImpl
extends SsoServerAuthSvc {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerAuthSvcImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerAuthSvcImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        this.SsoServerAuthFailureRate = new Long(0L);
        this.SsoServerAuthSuccessRate = new Long(0L);
        this.SsoServerAuthFailureCount = new Long(0L);
        this.SsoServerAuthSuccessCount = new Long(0L);
    }

    public void incSsoServerAuthenticationFailureCount() {
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerAuthFailureCount;
        this.SsoServerAuthFailureCount = ++li;
    }

    public void incSsoServerAuthenticationSuccessCount() {
        if (!Agent.isRunning()) {
            return;
        }
        long li = this.SsoServerAuthSuccessCount;
        this.SsoServerAuthSuccessCount = ++li;
    }

    public void incModuleCounter(String moduleName, boolean success, String orgDN) {
        String classMethod = "SsoServerAuthSvcImpl.incModuleCounter:";
        String rName = Agent.getRealmNameFromDN(orgDN);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "\n" + "    AgentIsRunning = " + Agent.isRunning() + "\n" + "    moduleName = " + moduleName + "\n" + "    realmName = " + rName + "\n" + "    success = " + success + "\n" + "    orgDN = " + orgDN);
        }
        if (debug.warningEnabled()) {
            debug.warning(classMethod + "\n" + "    AgentIsRunning = " + Agent.isRunning() + "\n" + "    moduleName = " + moduleName + "\n" + "    realmName = " + rName + "\n" + "    success = " + success + "\n" + "    orgDN = " + orgDN);
        }
        if (!Agent.isRunning()) {
            return;
        }
        if (rName == null) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "no realm configuration for org " + orgDN + " set up yet.");
            }
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "no realm configuration for org " + orgDN + " set up yet.");
            }
            return;
        }
        if (moduleName != null && moduleName.length() > 0) {
            String rlmAuthInst = rName + "|" + moduleName;
            SsoServerAuthModulesEntryImpl mei = Agent.getAuthModuleEntry(rlmAuthInst);
            if (mei == null) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "did not find auth module instance for " + moduleName + " in realm " + rName);
                }
                return;
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "got auth module instance for " + rlmAuthInst);
            }
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "got auth module instance for " + rlmAuthInst);
            }
            if (success) {
                mei.incModuleSuccessCount();
                this.incSsoServerAuthenticationSuccessCount();
            } else {
                mei.incModuleFailureCount();
                this.incSsoServerAuthenticationFailureCount();
            }
        } else if (debug.warningEnabled()) {
            debug.warning(classMethod + "no module name provided");
        }
    }
}

