/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ReferralTypeManager;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Referrals
implements Cloneable {
    private String name;
    private String description;
    private Map referrals = new HashMap();
    private static String REFERRALS_ELEMENT_BEGIN = "<Referrals name=\"";
    private static String REFERRALS_DESCRIPTION = "\" description=\"";
    private static String REFERRALS_ELEMENT_END = "</Referrals>";
    private static String REFERRAL_ELEMENT = "<Referral name=\"";
    private static String REFERRAL_TYPE = "\" type=\"";
    private static String REFERRAL_ELEMENT_END = "</Referral>";
    private static String ATTR_VALUE_BEGIN = "<AttributeValuePair><Attribute name=\"Values\"/>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_END = "</AttributeValuePair>";
    private static String REFERRAL_VALUES_ATTR_NAME = "Values";

    protected Referrals() {
        this((String)null, (String)null);
    }

    protected Referrals(PolicyManager pm, Node referralsNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        if (!referralsNode.getNodeName().equalsIgnoreCase("Referrals")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid referrals xml blob given to construct referrals");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_referrals_root_node", null, "", 8);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)referralsNode, (String)"name");
        if (this.name == null) {
            this.name = "Referrals:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)referralsNode, (String)"description")) == null) {
            this.description = "";
        }
        ReferralTypeManager rtm = pm.getReferralTypeManager();
        for (Node referralNode : XMLUtils.getChildNodes((Node)referralsNode, (String)"Referral")) {
            String referralType = XMLUtils.getNodeAttributeValue((Node)referralNode, (String)"type");
            if (referralType == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("referral type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_referrals_root_node", null, "", 8);
            }
            Referral referral = rtm.getReferral(referralType);
            NodeList attrValuePairNodes = referralNode.getChildNodes();
            int numAttrValuePairNodes = attrValuePairNodes.getLength();
            for (int j = 0; j < numAttrValuePairNodes; ++j) {
                Node attrValuePairNode = attrValuePairNodes.item(j);
                if (XMLUtils.getNamedChildNode((Node)attrValuePairNode, (String)"Attribute", (String)"name", (String)REFERRAL_VALUES_ATTR_NAME) == null) continue;
                referral.setValues(XMLUtils.getAttributeValuePair((Node)attrValuePairNode));
            }
            String referralName = XMLUtils.getNodeAttributeValue((Node)referralNode, (String)"name");
            this.addReferral(referralName, referral);
        }
    }

    public Referrals(String name, String description) {
        this.name = name == null ? "Referrals:" + ServiceTypeManager.generateRandomName() : name;
        this.description = description == null ? "" : description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name == null ? "Referrals:" + ServiceTypeManager.generateRandomName() : name;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public Set getReferralNames() {
        return this.referrals.keySet();
    }

    public Referral getReferral(String referralName) throws NameNotFoundException {
        Referral answer = (Referral)this.referrals.get(referralName);
        if (answer == null) {
            Object[] objs = new String[]{referralName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, referralName, 8);
        }
        return answer;
    }

    public void addReferral(Referral referral) throws NameAlreadyExistsException {
        this.addReferral(null, referral);
    }

    public void addReferral(String referralName, Referral referral) throws NameAlreadyExistsException {
        if (referralName == null) {
            referralName = "Referral:" + ServiceTypeManager.generateRandomName();
        }
        if (this.referrals.containsKey(referralName)) {
            Object[] objs = new String[]{referralName};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objs, referralName, 8);
        }
        this.referrals.put(referralName, referral);
    }

    public void replaceReferral(String referralName, Referral referral) throws NameNotFoundException {
        if (!this.referrals.containsKey(referralName)) {
            Object[] objs = new String[]{referralName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, referralName, 8);
        }
        this.referrals.put(referralName, referral);
    }

    public Referral removeReferral(String referralName) {
        return (Referral)this.referrals.remove(referralName);
    }

    public Referral removeReferral(Referral referral) {
        String referralName = this.getReferralName(referral);
        if (referralName != null) {
            return this.removeReferral(referralName);
        }
        return null;
    }

    public String getReferralName(Referral referral) {
        String answer = null;
        for (String referralName : this.referrals.keySet()) {
            if (!referral.equals(this.referrals.get(referralName))) continue;
            answer = referralName;
            break;
        }
        return answer;
    }

    public boolean equals(Object o) {
        Iterator iter = null;
        if (o instanceof Referrals) {
            Referrals s = (Referrals)o;
            iter = this.referrals.entrySet().iterator();
            while (iter.hasNext()) {
                Object ss = iter.next().getValue();
                if (s.referrals.containsValue(ss)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        Referrals answer = null;
        try {
            answer = (Referrals)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            PolicyManager.debug.error("Referrals: clone failed", (Throwable)cnse);
        }
        answer.name = this.name;
        answer.description = this.description;
        answer.referrals = new HashMap();
        for (Object item : this.referrals.keySet()) {
            answer.referrals.put(item, this.referrals.get(item));
        }
        return answer;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\n").append(REFERRALS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(REFERRALS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        for (String referralName : this.referrals.keySet()) {
            Referral referral = (Referral)this.referrals.get(referralName);
            sb.append("\n").append(REFERRAL_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)referralName)).append(REFERRAL_TYPE).append(XMLUtils.escapeSpecialCharacters((String)ReferralTypeManager.referralTypeName(referral))).append("\">");
            Set v = referral.getValues();
            if (v != null && !v.isEmpty()) {
                sb.append("\n").append(ATTR_VALUE_BEGIN);
                Iterator values = v.iterator();
                while (values.hasNext()) {
                    sb.append("\n").append(VALUE_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)((String)values.next()))).append(VALUE_END);
                }
                sb.append("\n").append(ATTR_VALUE_END);
            }
            sb.append("\n").append(REFERRAL_ELEMENT_END);
        }
        sb.append("\n").append(REFERRALS_ELEMENT_END);
        return sb.toString();
    }

    PolicyDecision getPolicyDecision(SSOToken token, String resourceType, String resourceName, Set actionNames, Map envParameters) throws SSOException, NameNotFoundException, PolicyException {
        PolicyDecision mergedPolicyDecision = null;
        ServiceType serviceType = ServiceTypeManager.getServiceTypeManager().getServiceType(resourceType);
        Set referralNames = this.getReferralNames();
        for (String referralName : referralNames) {
            Referral referral = this.getReferral(referralName);
            if (referral instanceof OrgReferral) continue;
            PolicyDecision policyDecision = referral.getPolicyDecision(token, resourceType, resourceName, actionNames, envParameters);
            if (mergedPolicyDecision == null) {
                mergedPolicyDecision = policyDecision;
            } else {
                PolicyEvaluator.mergePolicyDecisions(serviceType, policyDecision, mergedPolicyDecision);
            }
            actionNames.removeAll(PolicyEvaluator.getFinalizedActions(serviceType, mergedPolicyDecision));
            if (!actionNames.isEmpty()) continue;
            break;
        }
        return mergedPolicyDecision;
    }

    boolean isEmpty() {
        return this.referrals.isEmpty();
    }

    Set getResourceNames(SSOToken token, String serviceTypeName, String resourceName) throws PolicyException, SSOException {
        HashSet resourceNames = new HashSet();
        Set referralNames = this.getReferralNames();
        for (String referralName : referralNames) {
            Referral referral = this.getReferral(referralName);
            if (referral instanceof OrgReferral) continue;
            Set rResourceNames = referral.getResourceNames(token, serviceTypeName, resourceName);
            resourceNames.addAll(rResourceNames);
        }
        return resourceNames;
    }
}

