/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.ShutdownPriority;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModification;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.servlet.ServletContext;
import org.opends.guitools.replicationcli.ReplicationCliMain;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.SaltedSHA512PasswordStorageScheme;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.tools.RebuildIndex;
import org.opends.server.tools.dsconfig.DSConfig;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.util.EmbeddedUtils;

public class EmbeddedOpenDS {
    private static boolean serverStarted = false;
    static final String[] preferredTransforms = new String[]{"RSA/ECB/OAEPWithSHA1AndMGF1Padding", "RSA/ /OAEPPADDINGSHA-1", "RSA/ECB/OAEPWithSHA-1AndMGF-1Padding", "RSA/ECB/PKCS1Padding"};
    static final String OPENDS_TRANSFORMATION = "OPENDS_TRANSFORMATION";
    static final String replDN = "cn=all-servers,cn=Server Groups,cn=admin data";

    public static boolean isStarted() {
        return serverStarted;
    }

    public static void setup(Map map, ServletContext servletCtx) throws Exception {
        SetupProgress.reportStart("emb.installingemb.null", null);
        String xform = EmbeddedOpenDS.getSupportedTransformation();
        if (xform == null) {
            SetupProgress.reportEnd("emb.noxform", null);
            throw new Exception("No transformation found");
        }
        map.put(OPENDS_TRANSFORMATION, xform);
        Object[] params = new Object[]{xform};
        SetupProgress.reportEnd("emb.success.param", params);
        String basedir = (String)map.get("BASE_DIR");
        String odsRoot = basedir + "/" + "opends";
        new File(basedir).mkdir();
        new File(odsRoot).mkdir();
        String[] subDirectories = new String[]{"adminDb", "bak", "bin", "changelogDb", "classes", "config", "db", "db_verify", "ldif", "lib", "locks", "logs", "db_rebuild", "db_unindexed", "db_index_test", "db_import_test", "config/schema", "config/upgrade"};
        for (int i = 0; i < subDirectories.length; ++i) {
            new File(odsRoot, subDirectories[i]).mkdir();
        }
        String[] files = new String[]{"config/upgrade/schema.ldif.5097", "config/upgrade/config.ldif.5097", "config/config.ldif", "config/admin-backend.ldif", "config/famsuffix.ldif", "config/schema/00-core.ldif", "config/schema/01-pwpolicy.ldif", "config/schema/02-config.ldif", "config/schema/03-changelog.ldif", "config/schema/03-rfc2713.ldif", "config/schema/03-rfc2714.ldif", "config/schema/03-rfc2739.ldif", "config/schema/03-rfc2926.ldif", "config/schema/03-rfc3112.ldif", "config/schema/03-rfc3712.ldif", "config/schema/03-uddiv3.ldif", "config/schema/04-rfc2307bis.ldif"};
        for (int i = 0; i < files.length; ++i) {
            int len;
            String file = "/WEB-INF/template/opends/" + files[i];
            InputStreamReader fin = new InputStreamReader(AMSetupServlet.getResourceAsStream(servletCtx, file));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
            OutputStreamWriter fout = null;
            try {
                fout = new FileWriter(odsRoot + "/" + files[i]);
                String inpStr = sbuf.toString();
                fout.write(ServicesDefaultValues.tagSwap(inpStr));
                continue;
            }
            catch (IOException e) {
                Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setup(): Error loading ldifs", (Throwable)e);
                throw e;
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        Object[] params2 = new Object[]{odsRoot};
        SetupProgress.reportStart("emb.installingemb", params2);
        EmbeddedOpenDS.startServer(odsRoot);
        if (!EmbeddedOpenDS.isMultiServer(map)) {
            SetupProgress.reportStart("emb.creatingfamsuffix", null);
            EmbeddedOpenDS.shutdownServer("to load ldif");
            EmbeddedOpenDS.loadLDIF(odsRoot, odsRoot + "/config/famsuffix.ldif");
            EmbeddedOpenDS.startServer(odsRoot);
        }
    }

    private static String getSupportedTransformation() {
        for (int i = 0; i < preferredTransforms.length; ++i) {
            try {
                Cipher.getInstance(preferredTransforms[i]);
                return preferredTransforms[i];
            }
            catch (NoSuchAlgorithmException ex) {
                continue;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer(String odsRoot) throws Exception {
        if (EmbeddedOpenDS.isStarted()) {
            return;
        }
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        debug.message("EmbeddedOpenDS.startServer(" + odsRoot + ")");
        DirectoryEnvironmentConfig config = new DirectoryEnvironmentConfig();
        config.setServerRoot(new File(odsRoot));
        config.setForceDaemonThreads(true);
        config.setConfigClass(ConfigFileHandler.class);
        config.setConfigFile(new File(odsRoot + "/config", "config.ldif"));
        debug.message("EmbeddedOpenDS.startServer:starting DS Server...");
        EmbeddedUtils.startServer((DirectoryEnvironmentConfig)config);
        debug.message("...EmbeddedOpenDS.startServer:DS Server started.");
        for (int sleepcount = 0; !EmbeddedUtils.isRunning() && sleepcount < 60; ++sleepcount) {
            SetupProgress.reportStart("emb.waitingforstarted", null);
            Thread.sleep(1000L);
        }
        if (EmbeddedUtils.isRunning()) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        serverStarted = true;
        ShutdownManager shutdownMan = ShutdownManager.getInstance();
        if (shutdownMan.acquireValidLock()) {
            try {
                shutdownMan.addShutdownListener(new ShutdownListener(){

                    public void shutdown() {
                        try {
                            EmbeddedOpenDS.shutdownServer("Graceful Shutdown");
                        }
                        catch (Exception ex) {
                            Debug debug = Debug.getInstance((String)"amSetupServlet");
                            debug.error("EmbeddedOpenDS:shutdown hook failed", (Throwable)ex);
                        }
                    }
                }, ShutdownPriority.LOWEST);
            }
            finally {
                shutdownMan.releaseLockAndNotify();
            }
        }
    }

    public static void shutdownServer(String reason) throws Exception {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        if (EmbeddedOpenDS.isStarted()) {
            debug.message("EmbeddedOpenDS.shutdown server...");
            DirectoryServer.shutDown((String)"com.sun.identity.setup.EmbeddedOpenDS", (Message)Message.EMPTY);
            for (int sleepcount = 0; DirectoryServer.isRunning() && sleepcount < 60; ++sleepcount) {
                Thread.sleep(1000L);
            }
            serverStarted = false;
            debug.message("EmbeddedOpenDS.shutdown server success.");
        }
    }

    public static void setupReplication(Map map) throws Exception {
        SetupProgress.reportStart("emb.creatingreplica", null);
        int ret = EmbeddedOpenDS.setupReplicationEnable(map);
        if (ret != 0) {
            Object[] params = new Object[]{Integer.toString(ret)};
            SetupProgress.reportEnd("emb.failed.param", params);
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setupReplication. Error setting up replication");
            throw new ConfiguratorException("configurator.embreplfailed");
        }
        ret = EmbeddedOpenDS.setupReplicationInitialize(map);
        SetupProgress.reportEnd("emb.success", null);
        Debug.getInstance((String)"amSetupServlet").message("EmbeddedOpenDS.setupReplication: replication setup succeeded.");
    }

    public static int setupReplicationEnable(Map map) {
        int ret;
        String[] enableCmd = new String[]{"enable", "--no-prompt", "--host1", "host1val", "--port1", "port1ival", "--bindDN1", "cn=Directory Manager", "--bindPassword1", "xxxxxxxx", "--replicationPort1", "8989", "--host2", "host2val", "--port2", "port2ival", "--bindDN2", "cn=Directory Manager", "--bindPassword2", "xxxxxxxx", "--replicationPort2", "8989", "--adminUID", "admin", "--adminPassword", "xxxxxxxx", "--baseDN", "dc=example,dc=com"};
        enableCmd[3] = (String)map.get("DS_EMB_REPL_HOST2");
        enableCmd[5] = (String)map.get("DS_EMB_REPL_PORT2");
        enableCmd[11] = (String)map.get("DS_EMB_REPL_REPLPORT2");
        enableCmd[13] = (String)map.get("DIRECTORY_SERVER");
        enableCmd[15] = (String)map.get("DIRECTORY_PORT");
        enableCmd[21] = (String)map.get("DS_EMB_REPL_REPLPORT1");
        enableCmd[27] = (String)map.get("ROOT_SUFFIX");
        Object[] params = new Object[]{EmbeddedOpenDS.concat(enableCmd)};
        SetupProgress.reportStart("emb.replcommand", params);
        enableCmd[9] = (String)map.get("DS_DIRMGRPASSWD");
        enableCmd[19] = (String)map.get("DS_DIRMGRPASSWD");
        enableCmd[25] = (String)map.get("DS_DIRMGRPASSWD");
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        if (debug.messageEnabled()) {
            debug.message("EmbeddedOpenDS.setupReplicationEnable: Host 1 " + enableCmd[3]);
            debug.message("EmbeddedOpenDS.setupReplicationEnable: Host 2 " + enableCmd[13]);
            debug.message("EmbeddedOpenDS.setupReplicationEnable: Port 1 " + enableCmd[5]);
            debug.message("EmbeddedOpenDS.setupReplicationEnable: Port 2 " + enableCmd[15]);
        }
        if ((ret = ReplicationCliMain.mainCLI((String[])enableCmd, (boolean)false, (OutputStream)SetupProgress.getOutputStream(), (OutputStream)SetupProgress.getOutputStream(), null)) == 0) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        return ret;
    }

    public static int setupReplicationInitialize(Map map) {
        String[] initializeCmd = new String[]{"initialize", "--no-prompt", "--baseDN", "dc=opensso,dc=java,dc=net", "--adminUID", "admin", "--adminPassword", "xxxxxxxx", "--hostSource", "localhost", "--portSource", "50389", "--hostDestination", "localhost", "--portDestination", "51389", "--trustAll"};
        initializeCmd[3] = (String)map.get("ROOT_SUFFIX");
        initializeCmd[9] = (String)map.get("DS_EMB_REPL_HOST2");
        initializeCmd[11] = (String)map.get("DS_EMB_REPL_PORT2");
        initializeCmd[13] = (String)map.get("DIRECTORY_SERVER");
        initializeCmd[15] = (String)map.get("DIRECTORY_PORT");
        Object[] params = new Object[]{EmbeddedOpenDS.concat(initializeCmd)};
        SetupProgress.reportStart("emb.replcommand", params);
        initializeCmd[7] = (String)map.get("DS_DIRMGRPASSWD");
        int ret = ReplicationCliMain.mainCLI((String[])initializeCmd, (boolean)false, (OutputStream)SetupProgress.getOutputStream(), (OutputStream)SetupProgress.getOutputStream(), null);
        if (ret == 0) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        return ret;
    }

    public static int getReplicationStatus(String port, String passwd, OutputStream oo, OutputStream err) {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        String[] statusCmd = new String[]{"status", "--no-prompt", "-h", "localhost", "-p", port, "--adminUID", "admin", "--adminPassword", passwd, "-s"};
        if (debug.messageEnabled()) {
            String dbgcmd = EmbeddedOpenDS.concat(statusCmd).replaceAll(passwd, "****");
            debug.message("EmbeddedOpenDS:getReplicationStatus:exec dsreplication :" + dbgcmd);
        }
        int ret = ReplicationCliMain.mainCLI((String[])statusCmd, (boolean)false, (OutputStream)oo, (OutputStream)err, null);
        if (debug.messageEnabled()) {
            debug.message("EmbeddedOpenDS:getReplicationStatus:dsreplication ret:" + ret);
        }
        return ret;
    }

    public static boolean isMultiServer(Map map) {
        String replFlag = (String)map.get("DS_EMB_REPL_FLAG");
        return replFlag != null && replFlag.startsWith("embReplFlag");
    }

    private static String concat(String[] args) {
        String ret = "";
        for (int i = 0; i < args.length; ++i) {
            ret = ret + args[i] + " ";
        }
        return ret;
    }

    public static void loadLDIF(String odsRoot, String ldif) {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        try {
            debug.message("EmbeddedOpenDS:loadLDIF(" + ldif + ")");
            String[] args1 = new String[]{"-C", "org.opends.server.extensions.ConfigFileHandler", "-f", odsRoot + "/config/config.ldif", "-n", "userRoot", "-l", ldif, "-Q"};
            ImportLDIF.mainImportLDIF((String[])args1);
            debug.message("EmbeddedOpenDS:loadLDIF Success");
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS:loadLDIF:ex=" + ex);
        }
    }

    public static String hash(String p) {
        String str = null;
        try {
            byte[] bb = p.getBytes();
            str = SaltedSHA512PasswordStorageScheme.encodeOffline((byte[])bb);
        }
        catch (Exception ex) {
            Debug debug = Debug.getInstance((String)"amSetupServlet");
            debug.error("EmbeddedOpenDS.hash failed : ex=" + ex);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReplicationPort(String username, String password, String hostname, String port) {
        String replDN = "cn=replication server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config";
        String[] attrs = new String[]{"ds-cfg-replication-port"};
        String replPort = null;
        LDAPConnection ld = null;
        try {
            Enumeration en;
            LDAPAttribute la;
            LDAPEntry le;
            username = "cn=Directory Manager";
            LDAPConnection lc = EmbeddedOpenDS.getLDAPConnection(hostname, port, username, password);
            if (lc != null && (le = lc.read("cn=replication server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config", attrs)) != null && (la = le.getAttribute(attrs[0])) != null && (en = la.getStringValues()) != null && en.hasMoreElements()) {
                replPort = (String)en.nextElement();
            }
        }
        catch (Exception ex) {
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.getReplicationPort(). Error getting replication port:", (Throwable)ex);
        }
        finally {
            EmbeddedOpenDS.disconnectDServer(ld);
        }
        return replPort;
    }

    public static boolean syncReplicatedServers(Set currServerSet, String port, String passwd) {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        debug.message("EmbeddedOPenDS:syncReplication:start processing.");
        String[] args = new String[]{"-p", port, "-h", "localhost", "-D", "cn=directory manager", "-w", passwd, "list-replication-server", "--provider-name", "Multimaster Synchronization", "--property", "replication-server", "--property", "replication-port", "--no-prompt"};
        if (debug.messageEnabled()) {
            String dbgcmd = EmbeddedOpenDS.concat(args).replaceAll(passwd, "****");
            debug.message("EmbeddedOpenDS:syncReplication:exec dsconfig:" + dbgcmd);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream boe = new ByteArrayOutputStream();
        DSConfig.main((String[])args, (boolean)false, (OutputStream)bos, (OutputStream)boe);
        String str = bos.toString();
        String stre = boe.toString();
        if (stre.length() > 0) {
            debug.error("EmbeddedOpenDS:syncReplication: stderr is not empty:" + stre);
        }
        BufferedReader brd = new BufferedReader(new StringReader(str));
        String line = null;
        try {
            line = brd.readLine();
            line = brd.readLine();
            line = brd.readLine();
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS:syncReplication:Failed:", (Throwable)ex);
        }
        if (line == null) {
            debug.error("EmbeddedOpenDS:syncReplication:cmd failed" + str);
            return false;
        }
        try {
            int lastcolon = line.lastIndexOf(58);
            int stcolon = line.indexOf(58, line.indexOf(58) + 1);
            String replservers = line.substring(stcolon + 1, lastcolon);
            StringTokenizer stok = new StringTokenizer(replservers, ",");
            ArrayList<String> cmdlist = new ArrayList<String>();
            cmdlist.add("-p");
            cmdlist.add(port);
            cmdlist.add("-h");
            cmdlist.add("localhost");
            cmdlist.add("-D");
            cmdlist.add("cn=directory manager");
            cmdlist.add("-w");
            cmdlist.add(passwd);
            cmdlist.add("--no-prompt");
            cmdlist.add("set-replication-server-prop");
            cmdlist.add("--provider-name");
            cmdlist.add("Multimaster Synchronization");
            int numremoved = 0;
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken().trim();
                if (currServerSet.contains(tok)) continue;
                cmdlist.add("--remove");
                cmdlist.add("replication-server:" + tok);
                ++numremoved;
            }
            if (numremoved > 0) {
                String[] args1 = cmdlist.toArray(new String[cmdlist.size()]);
                if (debug.messageEnabled()) {
                    String dbgcmd1 = EmbeddedOpenDS.concat(args1).replaceAll(passwd, "****");
                    debug.message("EmbeddedOpenDS:syncReplication:Execute:" + dbgcmd1);
                }
                bos = new ByteArrayOutputStream();
                boe = new ByteArrayOutputStream();
                DSConfig.main((String[])args1, (boolean)false, (OutputStream)bos, (OutputStream)boe);
                str = bos.toString();
                stre = boe.toString();
                if (debug.messageEnabled()) {
                    debug.message("EmbeddedOpenDS:syncReplication:Result:" + str);
                }
                if (stre.length() != 0) {
                    debug.error("EmbeddedOpenDS:syncReplication:cmd stderr:" + stre);
                }
            }
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS:syncReplication:Failed:", (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean syncReplicatedDomains(Set currServerSet, String port, String passwd) {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        debug.message("EmbeddedOpenDS:syncReplication:Domains:started");
        String[] args = new String[]{"-p", port, "-h", "localhost", "-D", "cn=directory manager", "-w", passwd, "list-replication-domains", "--provider-name", "Multimaster Synchronization", "--property", "replication-server", "--no-prompt"};
        if (debug.messageEnabled()) {
            String dbgcmd = EmbeddedOpenDS.concat(args).replaceAll(passwd, "****");
            debug.message("EmbeddedOpenDS:syncReplication:exec dsconfig:" + dbgcmd);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream boe = new ByteArrayOutputStream();
        DSConfig.main((String[])args, (boolean)false, (OutputStream)bos, (OutputStream)boe);
        String str = bos.toString();
        String stre = boe.toString();
        if (stre.length() != 0) {
            debug.error("EmbeddedOpenDS:syncReplication:stderr:" + stre);
        }
        BufferedReader brd = new BufferedReader(new StringReader(str));
        String line = null;
        try {
            line = brd.readLine();
            line = brd.readLine();
            while ((line = brd.readLine()) != null) {
                try {
                    int dcolon = line.indexOf(58);
                    String domainname = line.substring(0, dcolon).trim();
                    int stcolon = line.indexOf(58, dcolon + 1);
                    String replservers = line.substring(stcolon + 1);
                    if (debug.messageEnabled()) {
                        debug.message("EmbeddedOpenDS:syncRepl:domain=" + domainname + " replservers=" + replservers);
                    }
                    StringTokenizer stok = new StringTokenizer(replservers, ",");
                    ArrayList<String> cmdlist = new ArrayList<String>();
                    cmdlist.add("-p");
                    cmdlist.add(port);
                    cmdlist.add("-h");
                    cmdlist.add("localhost");
                    cmdlist.add("-D");
                    cmdlist.add("cn=directory manager");
                    cmdlist.add("-w");
                    cmdlist.add(passwd);
                    cmdlist.add("--no-prompt");
                    cmdlist.add("set-replication-domain-prop");
                    cmdlist.add("--provider-name");
                    cmdlist.add("Multimaster Synchronization");
                    cmdlist.add("--domain-name");
                    cmdlist.add(domainname);
                    int numremoved = 0;
                    while (stok.hasMoreTokens()) {
                        String tok = stok.nextToken().trim();
                        if (currServerSet.contains(tok)) continue;
                        cmdlist.add("--remove");
                        cmdlist.add("replication-server:" + tok);
                        ++numremoved;
                    }
                    if (numremoved <= 0) continue;
                    String[] args1 = cmdlist.toArray(new String[cmdlist.size()]);
                    if (debug.messageEnabled()) {
                        String dbgcmd1 = EmbeddedOpenDS.concat(args1).replaceAll(passwd, "****");
                        debug.message("EmbeddedOpenDS:syncReplication:Execute:" + dbgcmd1);
                    }
                    bos = new ByteArrayOutputStream();
                    boe = new ByteArrayOutputStream();
                    DSConfig.main((String[])args1, (boolean)false, (OutputStream)bos, (OutputStream)boe);
                    str = bos.toString();
                    stre = boe.toString();
                    if (stre.length() != 0) {
                        debug.error("EmbeddedOpenDS:syncRepl:stderr=" + stre);
                    }
                    if (!debug.messageEnabled()) continue;
                    debug.message("EmbeddedOpenDS:syncReplication:Result:" + str);
                }
                catch (Exception ex) {
                    debug.error("EmbeddedOpenDS:syncReplication:Failed:", (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS:syncReplication:Failed:", (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean syncReplicatedServerList(Set currServerSet, String port, String passwd) {
        Set dsServers;
        LDAPConnection lc;
        block6: {
            lc = null;
            lc = EmbeddedOpenDS.getLDAPConnection("localhost", port, "cn=Directory Manager", passwd);
            dsServers = EmbeddedOpenDS.getServerSet(lc);
            if (dsServers != null) break block6;
            boolean bl = false;
            EmbeddedOpenDS.disconnectDServer(lc);
            return bl;
        }
        try {
            for (String tok : dsServers) {
                if (currServerSet.contains(tok)) continue;
                EmbeddedOpenDS.delOpenDSServer(lc, tok);
            }
        }
        catch (Exception ex) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                EmbeddedOpenDS.disconnectDServer(lc);
                throw throwable;
            }
            EmbeddedOpenDS.disconnectDServer(lc);
            return bl;
        }
        EmbeddedOpenDS.disconnectDServer(lc);
        return true;
    }

    private static LDAPConnection getLDAPConnection(String dsHostName, String dsPort, String dsManager, String dsAdminPwd) {
        LDAPConnection ld = null;
        try {
            int dsPortInt = Integer.parseInt(dsPort);
            ld = new LDAPConnection();
            ld.setConnectTimeout(300);
            ld.connect(3, dsHostName, dsPortInt, dsManager, dsAdminPwd);
        }
        catch (LDAPException ex) {
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setup(). Error getting LDAPConnection:", (Throwable)ex);
        }
        return ld;
    }

    private static void disconnectDServer(LDAPConnection ld) {
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    public static void delOpenDSServer(LDAPConnection lc, String delServer) {
        String replServerDN = "cn=" + delServer + ",cn=Servers,cn=admin data";
        String[] attrs = new String[]{"ds-cfg-key-id"};
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        if (lc == null) {
            debug.error("EmbeddedOpenDS:syncOpenDSServer():Could not connect to local opends instance." + replServerDN);
            return;
        }
        String trustKey = null;
        try {
            LDAPEntry le = lc.read(replServerDN, attrs);
            if (le != null) {
                Enumeration en;
                LDAPAttribute la = le.getAttribute(attrs[0]);
                if (la != null && (en = la.getStringValues()) != null && en.hasMoreElements()) {
                    trustKey = (String)en.nextElement();
                }
                String keyDN = "ds-cfg-key-id=" + trustKey + ",cn=instance keys,cn=admin data";
                lc.delete(keyDN);
            } else {
                debug.error("EmbeddedOpenDS:syncOpenDSServer():Could not find trustkey for:" + replServerDN);
            }
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS.syncOpenDSServer(). Error getting replication key:", (Throwable)ex);
        }
        try {
            lc.delete(replServerDN);
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS.syncOpenDSServer(). Error getting deleting server entrt:" + replServerDN, (Throwable)ex);
        }
        try {
            LDAPAttribute attr = new LDAPAttribute("uniqueMember", "cn=" + delServer);
            LDAPModification mod = new LDAPModification(1, attr);
            lc.modify(replDN, mod);
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS.syncOpenDSServer(). Error getting removing :cn=all-servers,cn=Server Groups,cn=admin data", (Throwable)ex);
        }
    }

    public static Set getServerSet(LDAPConnection lc) {
        String[] attrs = new String[]{"uniqueMember"};
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        try {
            if (lc != null) {
                LDAPEntry le = lc.read(replDN, attrs);
                if (le != null) {
                    HashSet<String> hostSet = new HashSet<String>();
                    LDAPAttribute la = le.getAttribute(attrs[0]);
                    if (la != null) {
                        Enumeration en = la.getStringValues();
                        while (en != null && en.hasMoreElements()) {
                            String val = (String)en.nextElement();
                            hostSet.add(val.substring(3, val.length()));
                        }
                    }
                    return hostSet;
                }
                debug.error("EmbeddedOpenDS:syncOpenDSServer():Could not find trustkey for:cn=all-servers,cn=Server Groups,cn=admin data");
            } else {
                debug.error("EmbeddedOpenDS:syncOpenDSServer():Could not connect to local opends instance.");
            }
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS.syncOpenDSServer(). Error getting replication key:", (Throwable)ex);
        }
        return null;
    }

    public static void rebuildIndex(Map map) throws Exception {
        EmbeddedOpenDS.shutdownServer("Rebuild index");
        String basedir = (String)map.get("BASE_DIR");
        String odsRoot = basedir + "/" + "opends";
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        String[] args = new String[]{"--configClass", "org.opends.server.extensions.ConfigFileHandler", "--configFile", odsRoot + "/config/config.ldif", "--baseDN", (String)map.get("ROOT_SUFFIX"), "--index", "sunxmlkeyvalue", "--index", "sunOrganizationAlias", "--index", "memberof", "--index", "iplanet-am-static-group-dn", "--index", "iplanet-am-modifiable-by", "--index", "iplanet-am-user-federation-info-key", "--index", "sun-fm-saml2-nameid-infokey"};
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream boe = new ByteArrayOutputStream();
        RebuildIndex.mainRebuildIndex((String[])args, (boolean)true, (OutputStream)bos, (OutputStream)boe);
        String outStr = ((Object)bos).toString();
        String errStr = ((Object)boe).toString();
        if (errStr.length() != 0) {
            debug.error("EmbeddedOpenDS:rebuildIndex:stderr=" + errStr);
        }
        if (debug.messageEnabled()) {
            String msg = "msg=Rebuild complete.";
            int idx = outStr.indexOf(msg);
            if (idx >= 0) {
                debug.message("EmbeddedOpenDS:rebuildIndex: Rebuild Status: " + outStr.substring(idx));
            }
            debug.message("EmbeddedOpenDS:rebuildIndex:Result:" + outStr);
        }
        EmbeddedOpenDS.startServer(odsRoot);
    }
}

