/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import junit.framework.TestCase;
import org.gatein.pc.api.InvokerUnavailableException;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.services.ServiceFactory;
import org.gatein.wsrp.test.protocol.v2.BehaviorBackedServiceFactory;

public class EndpointConfigurationInfoTestCase
extends TestCase {
    private EndpointConfigurationInfo info;
    private String url = "http://www.example.com/";

    protected void setUp() throws Exception {
        this.info = new EndpointConfigurationInfo((ServiceFactory)new BehaviorBackedServiceFactory());
    }

    public void testSetWSDLURL() throws InvokerUnavailableException {
        String bea = "http://wsrp.bea.com:7001/producer/producer?WSDL";
        this.info.setWsdlDefinitionURL(bea);
        EndpointConfigurationInfoTestCase.assertEquals((String)bea, (String)this.info.getWsdlDefinitionURL());
    }

    public void testSetWSDLURLDoesNotTriggerWSDLRetrieval() {
        this.info.setWsdlDefinitionURL(this.url);
        EndpointConfigurationInfoTestCase.assertEquals((String)this.url, (String)this.info.getWsdlDefinitionURL());
    }

    public void testRefreshWSDL() throws Exception {
        EndpointConfigurationInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded());
        EndpointConfigurationInfoTestCase.assertFalse((boolean)this.info.isAvailable());
        String bea = "http://wsrp.bea.com:7001/producer/producer?WSDL";
        this.info.setWsdlDefinitionURL(bea);
        EndpointConfigurationInfoTestCase.assertTrue((boolean)this.info.refresh());
        EndpointConfigurationInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded());
        EndpointConfigurationInfoTestCase.assertTrue((boolean)this.info.isAvailable());
    }

    public void testGetRemoteHost() {
        String bea = "http://wsrp.bea.com:7001/producer/producer?WSDL";
        this.info.setWsdlDefinitionURL(bea);
        EndpointConfigurationInfoTestCase.assertEquals((String)"http://wsrp.bea.com:7001", (String)this.info.getRemoteHostAddress());
    }

    public void testGetServiceFactory() throws Exception {
        EndpointConfigurationInfoTestCase.assertTrue((boolean)this.info.isRefreshNeeded());
        EndpointConfigurationInfoTestCase.assertFalse((boolean)this.info.isAvailable());
        ServiceFactory factory = this.info.getServiceFactory();
        EndpointConfigurationInfoTestCase.assertNotNull((Object)factory);
        EndpointConfigurationInfoTestCase.assertFalse((boolean)this.info.isRefreshNeeded());
        EndpointConfigurationInfoTestCase.assertTrue((boolean)this.info.isAvailable());
        EndpointConfigurationInfoTestCase.assertTrue((boolean)factory.isAvailable());
    }
}

