/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import junit.framework.TestCase;
import org.apache.commons.httpclient.Cookie;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;

public class ProducerSessionInformationTestCase
extends TestCase {
    ProducerSessionInformation info;
    private static final int SLEEP_TIME = 1500;

    protected void setUp() throws Exception {
        this.info = new ProducerSessionInformation();
    }

    public void testUserCookie() throws Exception {
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getUserCookie());
        Cookie[] cookies = new Cookie[]{this.createCookie("name", "value", 1)};
        this.info.setUserCookie(cookies);
        ProducerSessionInformationTestCase.assertEquals((String)"name=value", (String)this.info.getUserCookie());
        Thread.sleep(1500L);
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getUserCookie());
        cookies = new Cookie[]{this.createCookie("name1", "value1", 1), this.createCookie("name2", "value2", 3)};
        this.info.setUserCookie(cookies);
        ProducerSessionInformationTestCase.assertEquals((String)"name1=value1,name2=value2", (String)this.info.getUserCookie());
        Thread.sleep(1500L);
        ProducerSessionInformationTestCase.assertEquals((String)"name2=value2", (String)this.info.getUserCookie());
        try {
            this.info.setUserCookie(null);
            ProducerSessionInformationTestCase.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGroupCookies() throws Exception {
        String groupId = "groupId";
        try {
            this.info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name1", "value1", 1), this.createCookie("name2", "value2", -1)});
            ProducerSessionInformationTestCase.fail((String)"Cannot add group cookie if not perGroup");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.info.setPerGroupCookies(true);
        this.info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name1", "value1", 1), this.createCookie("name2", "value2", -1)});
        ProducerSessionInformationTestCase.assertEquals((String)"name1=value1,name2=value2", (String)this.info.getGroupCookieFor(groupId));
        Thread.sleep(1500L);
        ProducerSessionInformationTestCase.assertEquals((String)"name2=value2", (String)this.info.getGroupCookieFor(groupId));
        this.info.clearGroupCookies();
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getGroupCookieFor(groupId));
    }

    public void testSessionForPortlet() throws Exception {
        String handle = "handle";
        String handle2 = "handle2";
        String sid = "id";
        String sid2 = "id2";
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getSessionIdForPortlet(handle));
        ProducerSessionInformationTestCase.assertEquals((int)0, (int)this.info.getNumberOfSessions());
        this.addSession(handle, sid, 1);
        this.addSession(handle2, sid2, 3);
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getSessionIdForPortlet("unknown"));
        ProducerSessionInformationTestCase.assertEquals((String)sid, (String)this.info.getSessionIdForPortlet(handle));
        ProducerSessionInformationTestCase.assertEquals((int)2, (int)this.info.getNumberOfSessions());
        Thread.sleep(1500L);
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getSessionIdForPortlet(handle));
        ProducerSessionInformationTestCase.assertEquals((String)sid2, (String)this.info.getSessionIdForPortlet(handle2));
        ProducerSessionInformationTestCase.assertEquals((int)1, (int)this.info.getNumberOfSessions());
        this.info.removeSessionForPortlet(handle2);
        ProducerSessionInformationTestCase.assertEquals((int)0, (int)this.info.getNumberOfSessions());
    }

    public void testReplaceUserCookies() throws Exception {
        this.info.setUserCookie(new Cookie[]{this.createCookie("name", "value", 1)});
        this.info.replaceUserCookiesWith(null);
        ProducerSessionInformationTestCase.assertEquals((String)"name=value", (String)this.info.getUserCookie());
        ProducerSessionInformation other = new ProducerSessionInformation();
        this.info.replaceUserCookiesWith(other);
        ProducerSessionInformationTestCase.assertEquals((String)"name=value", (String)this.info.getUserCookie());
        other.setUserCookie(new Cookie[]{this.createCookie("name2", "value2", 1)});
        this.info.replaceUserCookiesWith(other);
        ProducerSessionInformationTestCase.assertEquals((String)"name2=value2", (String)this.info.getUserCookie());
        Thread.sleep(1500L);
        this.info.replaceUserCookiesWith(other);
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getUserCookie());
    }

    public void testReleaseSessions() {
        this.addSession("handle", "id", 1);
        this.addSession("handle2", "id2", 1);
        this.addSession("handle3", "id3", 1);
        ProducerSessionInformationTestCase.assertEquals((int)3, (int)this.info.getNumberOfSessions());
        this.info.removeSessions();
        ProducerSessionInformationTestCase.assertEquals((int)0, (int)this.info.getNumberOfSessions());
        this.addSession("handle", "id", 1);
        this.addSession("handle2", "id2", 2);
        this.info.removeSession("id2");
        ProducerSessionInformationTestCase.assertEquals((int)1, (int)this.info.getNumberOfSessions());
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getSessionIdForPortlet("handle2"));
        ProducerSessionInformationTestCase.assertEquals((String)"id", (String)this.info.getSessionIdForPortlet("handle"));
        this.info.removeSessionForPortlet("handle");
        ProducerSessionInformationTestCase.assertEquals((int)0, (int)this.info.getNumberOfSessions());
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getSessionIdForPortlet("handle"));
        try {
            this.info.removeSessionForPortlet("handle");
            ProducerSessionInformationTestCase.fail((String)"Session for portlet 'handle' should have already been released!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetParentSessionId() {
        ProducerSessionInformationTestCase.assertNull((Object)this.info.getParentSessionId());
        String id = "session";
        this.info.setParentSessionId(id);
        ProducerSessionInformationTestCase.assertEquals((String)id, (String)this.info.getParentSessionId());
        this.info.setParentSessionId(id);
        try {
            this.info.setParentSessionId("other");
            ProducerSessionInformationTestCase.fail((String)"Cannot modify session id once it has been set");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Cookie createCookie(String name, String value, int secondsBeforeExpiration) {
        return new Cookie("domain", name, value, "path", secondsBeforeExpiration, false);
    }

    private void addSession(String handle, String sid, int expires) {
        this.info.addSessionForPortlet(handle, WSRPTypeFactory.createSessionContext((String)sid, (int)expires));
    }
}

