/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.handlers;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import junit.framework.TestCase;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.consumer.handlers.MimeResponseHandler;
import org.gatein.wsrp.consumer.handlers.RenderHandler;
import org.gatein.wsrp.consumer.handlers.ResourceHandler;
import org.gatein.wsrp.consumer.spi.WSRPConsumerSPI;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.support.MockWSRPConsumer;
import org.gatein.wsrp.test.support.TestPortletInvocationContext;
import org.gatein.wsrp.test.support.TestRenderInvocation;
import org.gatein.wsrp.test.support.TestResourceInvocation;
import org.oasis.wsrp.v2.MarkupContext;
import org.oasis.wsrp.v2.MimeResponse;
import org.oasis.wsrp.v2.ResourceContext;

public class MimeResponseHandlerTestCase
extends TestCase {
    public static final String NAMESPACE = "NAMESPACE";
    public static final String PORTLETID = "PORTLETID";
    public static final MockWSRPConsumer CONSUMER = new MockWSRPConsumer("foo");
    public static final PortletContext PORTLET_CONTEXT = PortletContext.createPortletContext((String)"PORTLETID", (boolean)false);
    public static final TestPortletInvocationContext CONTEXT = new TestPortletInvocationContext();
    public static final URLFormat FORMAT = new URLFormat(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));

    protected void setUp() throws Exception {
        CONSUMER.setUsingWSRP2(true);
    }

    public void testProcessMarkupV1() {
        CONSUMER.setUsingWSRP2(false);
        String markup = "khlaksdhjflkjhsadljkwsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewritefadsfadswsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewritefajdshfkjdshgfgrept";
        String expected = "khlaksdhjflkjhsadljkAction is=JBPNS_ ns=null ws=null m=nullfadsfadsRender ns=JBPNS_ ws=null m=nullfajdshfkjdshgfgrept";
        this.processMarkupAndCheck(markup, expected);
        markup = "<form method='post' action='wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite' id='wsrp_rewrite_portfolioManager'><table><tr><td>Stock symbol</td><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>";
        expected = "<form method='post' action='Action is=JBPNS_ ns=null ws=null m=null' id='NAMESPACEportfolioManager'><table><tr><td>Stock symbol</td><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>";
        this.processMarkupAndCheck(markup, expected);
    }

    public void testProcessMarkupV2() {
        String markup = "khlaksdhjflkjhsadljkwsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewritefadsfadswsrp_rewrite?wsrp-urlType=render&wsrp-navigationalState=JBPNS_/wsrp_rewritefajdshfkjdshgfgrept";
        String expected = "khlaksdhjflkjhsadljkAction is=JBPNS_ ns=null ws=null m=nullfadsfadsRender ns=JBPNS_ ws=null m=nullfajdshfkjdshgfgrept";
        this.processMarkupAndCheck(markup, expected);
        markup = "<form method='post' action='wsrp_rewrite?wsrp-urlType=blockingAction&wsrp-interactionState=JBPNS_/wsrp_rewrite' id='wsrp_rewrite_portfolioManager'><table><tr><td>Stock symbol</td><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>";
        expected = "<form method='post' action='Action is=JBPNS_ ns=null ws=null m=null' id='NAMESPACEportfolioManager'><table><tr><td>Stock symbol</td><td><input name='symbol'/></td></tr><tr><td><input type='submit' value='Submit'></td></tr></table></form>";
        this.processMarkupAndCheck(markup, expected);
    }

    public void testURLEscaping() throws Exception {
        String resourceID = WSRPResourceURL.encodeResource(null, (URL)new URL("http://localhost:8080/test-resource-portlet/gif/logo.gif"), (boolean)false);
        String markup = "<img src='wsrp_rewrite?wsrp-urlType=resource&amp;wsrp-url=http%3A%2F%2Flocalhost%3A8080%2Ftest-resource-portlet%2Fgif%2Flogo.gif&amp;wsrp-requiresRewrite=true/wsrp_rewrite'/>";
        String expected = "<img src='http://test/mock:type=resource?mock:ComponentID=foo-bar&amp;mock:resourceID=" + resourceID + "'/>";
        this.processMarkupAndCheck(markup, expected);
        markup = "<img src='wsrp_rewrite?wsrp-urlType=resource&wsrp-url=http%3A%2F%2Flocalhost%3A8080%2Ftest-resource-portlet%2Fgif%2Flogo.gif&wsrp-requiresRewrite=true/wsrp_rewrite'/>";
        expected = "<img src='http://test/mock:type=resource?mock:ComponentID=foo-bar&mock:resourceID=" + resourceID + "'/>";
        this.processMarkupAndCheck(markup, expected);
        markup = "<img src='wsrp_rewrite?wsrp\\x2DurlType=resource\\x26wsrp-url=http%3A%2F%2Flocalhost%3A8080%2Ftest\\x2Dresource\\x2Dportlet%2Fgif%2Flogo.gif\\x26wsrp\\x2DrequiresRewrite=true/wsrp_rewrite'/>";
        expected = "<img src='http://test/mock:type=resource?mock:ComponentID=foo\\x2Dbar\\x26mock:resourceID=" + resourceID + "'/>";
        this.processMarkupAndCheck(markup, expected);
        markup = "<img src='wsrp_rewrite?wsrp\\u002DurlType=resource\\u0026wsrp-url=http%3A%2F%2Flocalhost%3A8080%2Ftest\\u002Dresource\\u002Dportlet%2Fgif%2Flogo.gif\\u0026wsrp\\u002DrequiresRewrite=true/wsrp_rewrite'\\/>";
        expected = "<img src='http://test/mock:type=resource?mock:ComponentID=foo\\u002Dbar\\u0026mock:resourceID=" + resourceID + "'\\/>";
        this.processMarkupAndCheck(markup, expected);
    }

    public void testRegularURLIsNotAffected() {
        String markup = "<a href=\"/portal/portal/default/Test/EXAMPLE/EXAMPLE?action=1d&windowstate=&mode=&ns=_next%3D%2Fdk%2Fskat%2Fportal%2Ffront%2Fportlets%2Fexample%2Findex.jsp&is=_action%3D%252Fdk%252Fskat%252Fportal%252Ffront%252Fportlets%252Fexample%252FprocessLink%26jbpns_2fdefault_2fTest_2fEXAMPLE_2fEXAMPLEsnpbjname%3DChris\">Press to use default name.</a>";
        this.processMarkupAndCheck(markup, markup);
    }

    public void testRewritingRequiredWithBinaryContent() throws UnsupportedEncodingException, PortletInvokerException {
        String expected = "/* Style Sheet */\n.namespaceExternalStyleClass\n{\n\tfont-weight: bold;\n\tcolor: green;\n\tfont-family: Arial;\n\tborder:dashed 1px black; \n\tpadding: 15px;\n}";
        byte[] expectedBinary = expected.getBytes("UTF-8");
        String original = "/* Style Sheet */\n.wsrp_rewrite_ExternalStyleClass\n{\n\tfont-weight: bold;\n\tcolor: green;\n\tfont-family: Arial;\n\tborder:dashed 1px black; \n\tpadding: 15px;\n}";
        byte[] originalBinary = original.getBytes("UTF-8");
        this.processBinaryAndCheck(expectedBinary, (MimeResponseHandler)new RenderHandler((WSRPConsumerSPI)CONSUMER), (PortletInvocation)new TestRenderInvocation(CONTEXT), WSRPTypeFactory.createMimeResponse((String)"text/css", null, (byte[])originalBinary, MarkupContext.class));
        this.processBinaryAndCheck(expectedBinary, (MimeResponseHandler)new ResourceHandler((WSRPConsumerSPI)CONSUMER), (PortletInvocation)new TestResourceInvocation(CONTEXT), WSRPTypeFactory.createMimeResponse((String)"text/css", null, (byte[])originalBinary, ResourceContext.class));
        original = "//JScript file\nfunction wsrp_rewrite_ExternalScriptFunction()\n{\n\talert('Script Function in Script File');\n}";
        originalBinary = original.getBytes("UTF-8");
        expected = "//JScript file\nfunction namespaceExternalScriptFunction()\n{\n\talert('Script Function in Script File');\n}";
        expectedBinary = expected.getBytes("UTF-8");
        this.processBinaryAndCheck(expectedBinary, (MimeResponseHandler)new RenderHandler((WSRPConsumerSPI)CONSUMER), (PortletInvocation)new TestRenderInvocation(CONTEXT), WSRPTypeFactory.createMimeResponse((String)"application/x-javascript", null, (byte[])originalBinary, MarkupContext.class));
        this.processBinaryAndCheck(expectedBinary, (MimeResponseHandler)new ResourceHandler((WSRPConsumerSPI)CONSUMER), (PortletInvocation)new TestResourceInvocation(CONTEXT), WSRPTypeFactory.createMimeResponse((String)"application/x-javascript", null, (byte[])originalBinary, ResourceContext.class));
    }

    private void processBinaryAndCheck(byte[] expectedBinary, MimeResponseHandler handler, PortletInvocation invocation, MimeResponse mimeResponse) throws PortletInvokerException {
        mimeResponse.setRequiresRewriting(Boolean.valueOf(true));
        PortletInvocationResponse response = handler.rewriteResponseIfNeeded(mimeResponse, invocation);
        MimeResponseHandlerTestCase.assertTrue((boolean)(response instanceof ContentResponse));
        ContentResponse contentResponse = (ContentResponse)response;
        ExtendedAssert.assertEquals((byte[])expectedBinary, (byte[])contentResponse.getBytes());
    }

    private void processMarkupAndCheck(String markup, String expected) {
        String result = MimeResponseHandler.processMarkup((String)markup, (String)NAMESPACE, (PortletInvocationContext)CONTEXT, (PortletContext)PORTLET_CONTEXT, (URLFormat)FORMAT, (WSRPConsumer)CONSUMER);
        MimeResponseHandlerTestCase.assertEquals((String)expected, (String)result);
    }

    private String getResourceURL(String encodedURL, boolean requiresRewrite) {
        String result = "wsrp_rewrite*{wsrp-url}*{wsrp-requiresRewrite}/wsrp_rewrite".replace("{wsrp-url}", encodedURL);
        result = result.replace("{wsrp-requiresRewrite}", Boolean.toString(requiresRewrite));
        return result;
    }
}

