/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer.registry;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.wsrp.WSRPConsumer;
import org.gatein.wsrp.consumer.ConsumerException;
import org.gatein.wsrp.consumer.EndpointConfigurationInfo;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.consumer.RegistrationInfo;
import org.gatein.wsrp.consumer.registry.AbstractConsumerRegistry;
import org.gatein.wsrp.consumer.registry.InMemoryConsumerRegistry;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.RegistrationData;

public abstract class ConsumerRegistryTestCase
extends TestCase {
    protected AbstractConsumerRegistry registry;

    protected void setUp() throws Exception {
        this.registry = new InMemoryConsumerRegistry();
    }

    public void testCreateAndGet() {
        String id = "test";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ConsumerRegistryTestCase.assertNotNull((Object)consumer);
        ConsumerRegistryTestCase.assertEquals((String)id, (String)consumer.getProducerId());
        ProducerInfo info = consumer.getProducerInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)info);
        ConsumerRegistryTestCase.assertNotNull((Object)info.getKey());
        ConsumerRegistryTestCase.assertEquals((String)consumer.getProducerId(), (String)info.getId());
        EndpointConfigurationInfo endpoint = info.getEndpointConfigurationInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)endpoint);
        RegistrationInfo regInfo = info.getRegistrationInfo();
        ConsumerRegistryTestCase.assertTrue((boolean)regInfo.isUndetermined());
        ConsumerRegistryTestCase.assertEquals((Object)this.registry, (Object)info.getRegistry());
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(id));
        long initial = info.getLastModified();
        WSRPConsumer fromRegistry = this.registry.getConsumer(id);
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistry);
        ConsumerRegistryTestCase.assertEquals((String)consumer.getProducerId(), (String)fromRegistry.getProducerId());
        ProducerInfo fromRegistryInfo = fromRegistry.getProducerInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistryInfo);
        ConsumerRegistryTestCase.assertEquals((String)fromRegistry.getProducerId(), (String)fromRegistryInfo.getId());
        ConsumerRegistryTestCase.assertNotNull((Object)fromRegistryInfo.getEndpointConfigurationInfo());
        ConsumerRegistryTestCase.assertTrue((boolean)fromRegistryInfo.getRegistrationInfo().isUndetermined());
        ConsumerRegistryTestCase.assertEquals((Object)this.registry, (Object)fromRegistryInfo.getRegistry());
        ConsumerRegistryTestCase.assertEquals((long)initial, (long)info.getLastModified());
        ConsumerRegistryTestCase.assertEquals((String)info.getId(), (String)fromRegistryInfo.getId());
        ConsumerRegistryTestCase.assertEquals((Object)info.getEndpointConfigurationInfo(), (Object)fromRegistryInfo.getEndpointConfigurationInfo());
        ConsumerRegistryTestCase.assertEquals((Object)info.getRegistrationInfo(), (Object)fromRegistryInfo.getRegistrationInfo());
        List consumers = this.registry.getConfiguredConsumers();
        ConsumerRegistryTestCase.assertNotNull((Object)consumers);
        ConsumerRegistryTestCase.assertEquals((int)1, (int)consumers.size());
        ConsumerRegistryTestCase.assertTrue((boolean)consumers.contains(consumer));
        Collection ids = this.registry.getConfiguredConsumersIds();
        ConsumerRegistryTestCase.assertNotNull((Object)ids);
        ConsumerRegistryTestCase.assertEquals((int)1, (int)ids.size());
        ConsumerRegistryTestCase.assertTrue((boolean)ids.contains(id));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testGetConsumer() {
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer("inexistent"));
    }

    public void testDoubleRegistrationOfConsumerWithSameId() {
        String id = "foo";
        this.registry.createConsumer(id, null, null);
        try {
            this.registry.createConsumer(id, null, null);
            ConsumerRegistryTestCase.fail((String)"Shouldn't be possible to create a consumer with an existing id");
        }
        catch (ConsumerException consumerException) {
            // empty catch block
        }
    }

    public void testDelete() {
        String id = "id";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        this.registry.destroyConsumer(id);
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertEquals((int)0, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testUpdateProducerInfo() {
        String id = "foo";
        WSRPConsumer consumer = this.registry.createConsumer(id, null, null);
        ProducerInfo info = consumer.getProducerInfo();
        long initial = info.getLastModified();
        String previousId = this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertNull((Object)previousId);
        ConsumerRegistryTestCase.assertEquals((long)initial, (long)info.getLastModified());
        info.setId("bar");
        previousId = this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertEquals((String)"foo", (String)previousId);
        ConsumerRegistryTestCase.assertTrue((initial < info.getLastModified() ? 1 : 0) != 0);
        ConsumerRegistryTestCase.assertNull((Object)this.registry.getConsumer(id));
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer(id));
        ConsumerRegistryTestCase.assertEquals((Object)info, (Object)consumer.getProducerInfo());
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)this.registry.getConsumer("bar"));
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("bar"));
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
    }

    public void testStoppingShouldNotStartConsumers() throws Exception {
        ProducerInfo info = (ProducerInfo)Mockito.mock(ProducerInfo.class);
        Mockito.stub((Object)info.isActive()).toReturn((Object)true);
        Mockito.stub((Object)info.getId()).toReturn((Object)"foo");
        Mockito.stub((Object)info.getKey()).toReturn((Object)"fooKey");
        EndpointConfigurationInfo endpoint = (EndpointConfigurationInfo)Mockito.mock(EndpointConfigurationInfo.class);
        Mockito.stub((Object)info.getEndpointConfigurationInfo()).toReturn((Object)endpoint);
        this.registry.save(info, "Couldn't save ProducerInfo");
        WSRPConsumer original = this.registry.createConsumerFrom(info, true);
        ConsumerRegistryTestCase.assertEquals((Object)original, (Object)this.registry.getFederatingPortletInvoker().getFederatedInvoker("foo").getPortletInvoker());
        WSRPConsumer consumer = (WSRPConsumer)Mockito.spy((Object)original);
        AbstractConsumerRegistry registrySpy = (AbstractConsumerRegistry)Mockito.spy((Object)this.registry);
        ((AbstractConsumerRegistry)Mockito.doReturn((Object)consumer).when((Object)registrySpy)).getConsumer("foo");
        ((AbstractConsumerRegistry)Mockito.doReturn(Collections.singletonList(consumer)).when((Object)registrySpy)).getConsumers(false);
        WSRPConsumer foo = registrySpy.getConsumer("foo");
        ConsumerRegistryTestCase.assertTrue((boolean)foo.getProducerInfo().isActive());
        ConsumerRegistryTestCase.assertEquals((Object)consumer, (Object)foo);
        consumer.stop();
        registrySpy.stop();
        ((WSRPConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)0))).start();
        ConsumerRegistryTestCase.assertEquals(null, (Object)registrySpy.getFederatingPortletInvoker().getFederatedInvoker("foo"));
    }

    public void testReloadConsumers() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        WSRPConsumer consumer2 = this.registry.createConsumer("consumer2", null, null);
        ConsumerRegistryTestCase.assertEquals((int)2, (int)this.registry.getConfiguredConsumersIds().size());
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer2, (Object)this.registry.getConsumer(consumer2.getProducerId()));
        this.registry.reloadConsumers();
        ConsumerRegistryTestCase.assertEquals((int)2, (int)this.registry.getConfiguredConsumersIds().size());
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer2, (Object)this.registry.getConsumer(consumer2.getProducerId()));
    }

    public void testCacheSimple() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(consumer1.getProducerId()));
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.consumerCache.getConsumer(consumer1.getProducerId()));
        ProducerInfo info = consumer1.getProducerInfo();
        info.setId("foo");
        this.registry.updateProducerInfo(info);
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer("foo"));
        this.registry.destroyConsumer("foo");
        ConsumerRegistryTestCase.assertFalse((boolean)this.registry.containsConsumer("foo"));
    }

    public void testCacheModifyingProducerInfo() {
        WSRPConsumer consumer1 = this.registry.createConsumer("consumer1", null, null);
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer(consumer1.getProducerId()));
        ProducerInfo info = consumer1.getProducerInfo();
        info.setId("foo");
        this.registry.update(info);
        ConsumerRegistryTestCase.assertEquals((Object)consumer1, (Object)this.registry.getConsumer("foo"));
    }

    public void testDefaultConfiguration() throws Exception {
        String selfv1 = "selfv1";
        String selfv2 = "selfv2";
        this.loadConsumersConfiguration("default.xml");
        ConsumerRegistryTestCase.assertEquals((int)2, (int)this.registry.getConfiguredConsumerNumber());
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("selfv1"));
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("selfv2"));
        this.checkConsumer("selfv1", 500, 50000, false, "http://localhost:8080/wsrp-producer/v1/MarkupService?wsdl");
        this.checkConsumer("selfv2", 500, 50000, false, "http://localhost:8080/wsrp-producer/v2/MarkupService?wsdl");
    }

    public void testImproperCache() throws Exception {
        this.loadConsumersConfiguration("improper-cache.xml");
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        String id = "improper-cache";
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("improper-cache"));
        this.checkConsumer("improper-cache", ProducerInfo.DEFAULT_CACHE_VALUE, 10000, false, "http://localhost:8080/wsrp-producer/v1/MarkupService?wsdl");
    }

    public void testImproperUseWSS() throws Exception {
        this.loadConsumersConfiguration("improper-usewss.xml");
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        String id = "improper-usewss";
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("improper-usewss"));
        this.checkConsumer("improper-usewss", ProducerInfo.DEFAULT_CACHE_VALUE, 10000, false, "http://localhost:8080/wsrp-producer/v1/MarkupService?wsdl");
    }

    public void testWSSEnabled() throws Exception {
        this.loadConsumersConfiguration("wssEnabled.xml");
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        String id = "wss-enabled";
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("wss-enabled"));
        this.checkConsumer("wss-enabled", 400, 10000, true, "http://localhost:8080/wsrp-producer/v1/MarkupService?wsdl");
    }

    public void testVignette() throws Exception {
        this.loadConsumersConfiguration("vignette.xml");
        ConsumerRegistryTestCase.assertEquals((int)1, (int)this.registry.getConfiguredConsumerNumber());
        String id = "vignette";
        ConsumerRegistryTestCase.assertTrue((boolean)this.registry.containsConsumer("vignette"));
        WSRPConsumer consumer = this.checkConsumer("vignette", 300, 10000, false, "http://wsrpdemo.vignette.com:8080/producer/wsdl");
        RegistrationData registrationData = consumer.getProducerInfo().getRegistrationInfo().getRegistrationData();
        ConsumerRegistryTestCase.assertNotNull((Object)registrationData);
        List registrationProperties = registrationData.getRegistrationProperties();
        ConsumerRegistryTestCase.assertEquals((int)2, (int)registrationProperties.size());
        for (Property property : registrationProperties) {
            QName name = property.getName();
            ConsumerRegistryTestCase.assertTrue((name.equals(QName.valueOf("com.vignette.wsrp.registration.username")) || name.equals(QName.valueOf("com.vignette.wsrp.registration.password")) ? 1 : 0) != 0);
        }
    }

    private WSRPConsumer checkConsumer(String id, int expirationCache, int wsTimeOut, boolean wssEnabled, String wsdlURL) {
        WSRPConsumer consumer = this.registry.getConsumer(id);
        ConsumerRegistryTestCase.assertNotNull((Object)consumer);
        ProducerInfo producerInfo = consumer.getProducerInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)producerInfo);
        ConsumerRegistryTestCase.assertEquals((String)id, (String)producerInfo.getId());
        ConsumerRegistryTestCase.assertEquals((int)expirationCache, (int)producerInfo.getExpirationCacheSeconds());
        EndpointConfigurationInfo endpoint = producerInfo.getEndpointConfigurationInfo();
        ConsumerRegistryTestCase.assertNotNull((Object)endpoint);
        ConsumerRegistryTestCase.assertEquals((int)wsTimeOut, (int)endpoint.getWSOperationTimeOut());
        ConsumerRegistryTestCase.assertEquals((boolean)wssEnabled, (boolean)endpoint.getWSSEnabled());
        ConsumerRegistryTestCase.assertEquals((String)wsdlURL, (String)endpoint.getWsdlDefinitionURL());
        return consumer;
    }

    protected void loadConsumersConfiguration(String fileName) throws Exception {
        URL location = Thread.currentThread().getContextClassLoader().getResource(fileName);
        ConsumerRegistryTestCase.assertNotNull((Object)location);
        System.out.println("Loading consumers configuration = " + location);
        this.loadConsumersConfiguration(location);
    }

    protected abstract void loadConsumersConfiguration(URL var1) throws IOException;
}

