/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Cookie;
import org.gatein.wsrp.consumer.handlers.ProducerSessionInformation;
import org.gatein.wsrp.handler.RequestHeaderClientHandler;
import org.gatein.wsrp.test.handler.MockSOAPMessage;
import org.gatein.wsrp.test.handler.MockSOAPMessageContext;

public class RequestHeaderClientHandlerTestCase
extends TestCase {
    RequestHeaderClientHandler handler;

    protected void setUp() throws Exception {
        this.handler = new RequestHeaderClientHandler();
        RequestHeaderClientHandler.resetCurrentInfo();
    }

    public void testSimpleCookieHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.handler.handleRequest(msgContext);
        this.checkCookies(msgContext, 0, null);
        ProducerSessionInformation sessionInformation = new ProducerSessionInformation();
        sessionInformation.setUserCookie(new Cookie[]{this.createCookie("name", "value", 1)});
        RequestHeaderClientHandler.setCurrentInfo(null, (ProducerSessionInformation)sessionInformation);
        this.handler.handleRequest(msgContext);
        this.checkCookies(msgContext, 1, "name=value");
    }

    public void testGroupCookieHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ProducerSessionInformation info = new ProducerSessionInformation();
        info.setPerGroupCookies(true);
        String groupId = "group";
        info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name", "value", 1)});
        RequestHeaderClientHandler.setCurrentInfo(null, (ProducerSessionInformation)info);
        try {
            this.handler.handleRequest(msgContext);
            RequestHeaderClientHandlerTestCase.fail((String)"group id hasn't been set so shouldn't be able to complete request");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        RequestHeaderClientHandler.setCurrentGroupId((String)groupId);
        this.handler.handleRequest(msgContext);
        this.checkCookies(msgContext, 1, "name=value");
    }

    public void testBothCookiesHandleRequest() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        ProducerSessionInformation info = new ProducerSessionInformation();
        info.setPerGroupCookies(true);
        String groupId = "group";
        info.setGroupCookieFor(groupId, new Cookie[]{this.createCookie("name", "value", 1)});
        info.setUserCookie(new Cookie[]{this.createCookie("usercookie", "uservalue", 1)});
        RequestHeaderClientHandler.setCurrentInfo((String)groupId, (ProducerSessionInformation)info);
        this.handler.handleRequest(msgContext);
        this.checkCookies(msgContext, 1, "name=value,usercookie=uservalue");
    }

    public void testCookieWithoutInitHandleResponse() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.setCookies(msgContext, "name=value");
        this.handler.handleResponse((MessageContext)msgContext);
        ProducerSessionInformation info = RequestHeaderClientHandler.getCurrentProducerSessionInformation();
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name=value", (String)info.getUserCookie());
        RequestHeaderClientHandlerTestCase.assertFalse((boolean)info.isInitCookieDone());
        RequestHeaderClientHandlerTestCase.assertFalse((boolean)info.isPerGroupCookies());
    }

    public void testMultipleCookiesInResponse() {
        MockSOAPMessage message = new MockSOAPMessage();
        SOAPMessageContext msgContext = MockSOAPMessageContext.createMessageContext((MockSOAPMessage)message, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.setCookies(msgContext, "name1=value1", "name2=value2", "name3=value3");
        this.handler.handleResponse((MessageContext)msgContext);
        ProducerSessionInformation info = RequestHeaderClientHandler.getCurrentProducerSessionInformation();
        RequestHeaderClientHandlerTestCase.assertEquals((String)"name1=value1,name2=value2,name3=value3", (String)info.getUserCookie());
    }

    public void testCurrentInfo() {
        RequestHeaderClientHandlerTestCase.assertNull((Object)RequestHeaderClientHandler.getCurrentProducerSessionInformation());
        RequestHeaderClientHandlerTestCase.assertNull((Object)RequestHeaderClientHandler.getCurrentGroupId());
        try {
            RequestHeaderClientHandler.setCurrentGroupId((String)"foo");
            RequestHeaderClientHandlerTestCase.fail((String)"Current info was not set, shouldn't have thrown an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ProducerSessionInformation info = new ProducerSessionInformation();
        String groupId = "group";
        RequestHeaderClientHandler.setCurrentInfo((String)groupId, (ProducerSessionInformation)info);
        RequestHeaderClientHandlerTestCase.assertSame((Object)info, (Object)RequestHeaderClientHandler.getCurrentProducerSessionInformation());
        RequestHeaderClientHandlerTestCase.assertEquals((String)groupId, (String)RequestHeaderClientHandler.getCurrentGroupId());
    }

    private void setCookies(SOAPMessageContext context, String ... values) {
        HashMap httpHeaders = new HashMap();
        ArrayList<String> cookies = new ArrayList<String>(values.length);
        for (String value : values) {
            context.getMessage().getMimeHeaders().addHeader("Set-Cookie", value);
            cookies.add(value);
        }
        httpHeaders.put("Cookie", cookies);
        context.put((Object)"javax.xml.ws.http.request.headers", httpHeaders);
    }

    private void checkCookies(SOAPMessageContext messageContext, int number, String ... values) {
        MimeHeaders mimeHeaders = messageContext.getMessage().getMimeHeaders();
        String[] cookies = mimeHeaders.getHeader("Cookie");
        Map httpHeaders = (Map)messageContext.get((Object)"javax.xml.ws.http.request.headers");
        List cookiesList = (List)httpHeaders.get("Cookie");
        if (number == 0) {
            RequestHeaderClientHandlerTestCase.assertNull((Object)cookies);
            RequestHeaderClientHandlerTestCase.assertNull((Object)cookiesList);
        } else {
            RequestHeaderClientHandlerTestCase.assertEquals((int)number, (int)cookies.length);
            RequestHeaderClientHandlerTestCase.assertEquals((int)number, (int)cookiesList.size());
            int i = 0;
            for (String value : values) {
                RequestHeaderClientHandlerTestCase.assertEquals((String)value, (String)cookies[i]);
                RequestHeaderClientHandlerTestCase.assertEquals((String)value, (String)((String)cookiesList.get(i)));
                ++i;
            }
        }
    }

    private Cookie createCookie(String name, String value, int secondsBeforeExpiration) {
        return new Cookie("domain", name, value, "path", secondsBeforeExpiration, false);
    }
}

