/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.wsrp.consumer.migration.ExportInfo;
import org.gatein.wsrp.protocol.v2.V2ConsumerBaseTest;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.behaviors.DestroyClonesPortletManagementBehavior;

public class PortletManagementTestCase
extends V2ConsumerBaseTest {
    public void testClone() throws Exception {
        PortletContext original = PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false);
        PortletContext clone = this.consumer.createClone(PortletStateType.OPAQUE, original);
        ExtendedAssert.assertNotNull((Object)clone);
        ExtendedAssert.assertFalse((boolean)original.equals((Object)clone));
        ExtendedAssert.assertEquals((String)"SamplePortletHandle_clone", (String)clone.getId());
        Portlet originalPortlet = this.consumer.getPortlet(original);
        Portlet clonePortlet = this.consumer.getPortlet(clone);
        ExtendedAssert.assertNotNull((Object)clonePortlet);
        ExtendedAssert.assertFalse((boolean)originalPortlet.getContext().equals((Object)clonePortlet.getContext()));
        MetaInfo originalInfo = originalPortlet.getInfo().getMeta();
        MetaInfo cloneInfo = clonePortlet.getInfo().getMeta();
        ExtendedAssert.assertEquals((Object)originalInfo.getMetaValue("title"), (Object)cloneInfo.getMetaValue("title"));
        ExtendedAssert.assertEquals((Object)originalInfo.getMetaValue("description"), (Object)cloneInfo.getMetaValue("description"));
    }

    public void testGetSetProperties() throws Exception {
        PortletContext original = PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false);
        PropertyMap props = this.consumer.getProperties(original);
        this.checkProperties(props, "value1");
        PortletContext clone = this.consumer.createClone(PortletStateType.OPAQUE, original);
        props = this.consumer.getProperties(clone);
        this.checkProperties(props, "value1");
        this.consumer.setProperties(clone, new PropertyChange[]{PropertyChange.newUpdate((String)"prop1", (String)"value2")});
        this.checkProperties(this.consumer.getProperties(clone), "value2");
        this.consumer.setProperties(clone, new PropertyChange[]{PropertyChange.newReset((String)"prop1")});
        this.checkProperties(this.consumer.getProperties(clone), "value1");
    }

    public void testSetResetSameProperty() throws PortletInvokerException {
        PortletContext original = PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false);
        PortletContext clone = this.consumer.createClone(PortletStateType.OPAQUE, original);
        try {
            this.consumer.setProperties(clone, new PropertyChange[]{PropertyChange.newUpdate((String)"prop1", (String)"value2"), PropertyChange.newReset((String)"prop1")});
            PortletManagementTestCase.fail((String)"Shouldn't be possible to set and reset the same property in the same call");
        }
        catch (Exception e) {
            PortletManagementTestCase.assertTrue((boolean)e.getCause().getLocalizedMessage().contains("Cannot both set and reset a property at the same time!"));
        }
    }

    private void checkProperties(PropertyMap props, String expectedValue) {
        ExtendedAssert.assertNotNull((Object)props);
        ExtendedAssert.assertEquals((int)1, (int)props.size());
        ExtendedAssert.assertEquals((String)expectedValue, (String)((String)props.getProperty("prop1").get(0)));
    }

    public void testDestroyClones() throws Exception {
        BehaviorRegistry behaviorRegistry = this.producer.getBehaviorRegistry();
        behaviorRegistry.setPortletManagementBehavior(new DestroyClonesPortletManagementBehavior(behaviorRegistry));
        PortletContext original = PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false);
        PortletContext clone = this.consumer.createClone(PortletStateType.OPAQUE, original);
        ExtendedAssert.assertNotNull((Object)clone);
        Portlet portlet = this.consumer.getPortlet(clone);
        ExtendedAssert.assertNotNull((Object)portlet);
        ExtendedAssert.assertEquals((String)"SamplePortletHandle_clone", (String)portlet.getContext().getId());
        ArrayList<PortletContext> clones = new ArrayList<PortletContext>(1);
        clones.add(clone);
        List result = this.consumer.destroyClones(clones);
        ExtendedAssert.assertTrue((boolean)result.isEmpty());
        try {
            this.consumer.getPortlet(clone);
            ExtendedAssert.fail((String)"Should have failed: clone should not exist anymore!");
        }
        catch (PortletInvokerException expected) {
            // empty catch block
        }
        clone = this.consumer.createClone(PortletStateType.OPAQUE, original);
        PortletContext invalidContext = PortletContext.createPortletContext((String)"invalid", (boolean)false);
        clones.add(invalidContext);
        result = this.consumer.destroyClones(clones);
        ExtendedAssert.assertEquals((int)1, (int)result.size());
        DestroyCloneFailure failure = (DestroyCloneFailure)result.get(0);
        ExtendedAssert.assertEquals((String)"invalid", (String)failure.getPortletId());
        try {
            this.consumer.getPortlet(clone);
            ExtendedAssert.fail((String)"Should have failed: clone should not exist anymore!");
        }
        catch (PortletInvokerException expected) {
            // empty catch block
        }
    }

    public void testInvalidSetProperties() throws Exception {
        PortletContext original = PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false);
        try {
            this.consumer.setProperties(original, null);
            ExtendedAssert.fail((String)"Shouldn't be possible to set properties with null changes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullExportPortlets() throws PortletInvokerException {
        try {
            this.consumer.exportPortlets(null);
            PortletManagementTestCase.fail((String)"Cannot export without a list of portlet handles!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyExportPortlets() throws PortletInvokerException {
        try {
            this.consumer.exportPortlets(Collections.emptyList());
            PortletManagementTestCase.fail((String)"Cannot export without a list of portlet handles!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExportPortlets() throws PortletInvokerException {
        long now = System.currentTimeMillis();
        ArrayList<String> portletContexts = new ArrayList<String>();
        portletContexts.add("SamplePortletHandle");
        ExportInfo ei = this.consumer.exportPortlets(portletContexts);
        PortletManagementTestCase.assertNotNull((Object)ei);
        long tenSeconds = 10000L;
        PortletManagementTestCase.assertTrue((ei.getExportTime() - now < tenSeconds ? 1 : 0) != 0);
        PortletManagementTestCase.assertEquals((long)0L, (long)ei.getExpirationTime());
        List exportedPortlets = ei.getExportedPortletHandles();
        PortletManagementTestCase.assertNotNull((Object)exportedPortlets);
        PortletManagementTestCase.assertEquals((int)1, (int)exportedPortlets.size());
        PortletManagementTestCase.assertTrue((boolean)exportedPortlets.contains("SamplePortletHandle"));
        PortletManagementTestCase.assertNotNull((Object)ei.getPortletStateFor("SamplePortletHandle"));
        PortletManagementTestCase.assertTrue((boolean)ei.getErrorCodesToFailedPortletHandlesMapping().isEmpty());
        List availableExportInfos = this.consumer.getMigrationService().getAvailableExportInfos();
        PortletManagementTestCase.assertEquals((int)1, (int)availableExportInfos.size());
        PortletManagementTestCase.assertEquals((Object)ei, availableExportInfos.get(0));
    }
}

